/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.kubernetes.ui.actions.QuickHelmActionBase;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\bH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmViewTemplateRenderAction;", "Lcom/intellij/kubernetes/ui/actions/QuickHelmActionBase;", "<init>", "()V", "getHelmCommand", "", "", "ctx", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "isApplicable", "", "context", "getChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "processOutput", "", "request", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "Lcom/intellij/execution/process/ProcessOutput;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmViewTemplateRenderAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmViewTemplateRenderAction.kt\ncom/intellij/kubernetes/ui/actions/HelmViewTemplateRenderAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n30#2,2:45\n1#3:47\n23#4:48\n*S KotlinDebug\n*F\n+ 1 HelmViewTemplateRenderAction.kt\ncom/intellij/kubernetes/ui/actions/HelmViewTemplateRenderAction\n*L\n30#1:45,2\n35#1:48\n*E\n"})
public final class HelmViewTemplateRenderAction
extends QuickHelmActionBase {
    public HelmViewTemplateRenderAction() {
        String string = KubernetesBundle.message((String)"HelmViewTemplateRenderAction.task.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, true);
    }

    @Override
    @NotNull
    protected List<String> getHelmCommand(@NotNull KubernetesActionBase.ActionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object[] objectArray = new String[]{"template", "--debug"};
        List fallbackCommand = CollectionsKt.listOf((Object[])objectArray);
        Chart chart = this.getChart(ctx);
        if (chart == null) {
            return fallbackCommand;
        }
        Chart chart2 = chart;
        String tplRelPath = VfsUtil.getRelativePath((VirtualFile)ctx.getCurrentFile(), (VirtualFile)chart2.getBaseDir());
        if (tplRelPath == null) {
            return fallbackCommand;
        }
        Object[] objectArray2 = new String[]{"template", "--show-only", tplRelPath, "--debug"};
        return CollectionsKt.listOf((Object[])objectArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApplicable(@NotNull KubernetesActionBase.ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.getChart(context2) == null) return false;
        String string = context2.getCurrentFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!Chart.Companion.isRenderableTemplateFile(string)) return false;
        return true;
    }

    @Override
    @Nullable
    protected Chart getChart(@NotNull KubernetesActionBase.ActionContext context2) {
        Chart chart;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ComponentManager $this$service$iv = (ComponentManager)context2.getProject();
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart2 = ((ChartManager)object).findChartByTemplateFile(context2.getCurrentFile());
        if (chart2 != null) {
            Chart chart3;
            Chart it = chart3 = chart2;
            boolean bl = false;
            chart = it.getChartFile() != null ? chart3 : null;
        } else {
            chart = null;
        }
        return chart;
    }

    @Override
    protected void processOutput(@NotNull KubernetesActionBase.ActionContext context2, @NotNull HelmExecutionManager.ExecutionRequest request, @NotNull ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        if (processOutput.getExitCode() != 0) {
            HelmViewTemplateRenderAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(HelmViewTemplateRenderAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to render helm template: " + processOutput.getStderr());
            return;
        }
        Object[] objectArray = new Object[]{context2.getCurrentFile().getName()};
        Object[] $this$processOutput_u24lambda_u240 = objectArray = new LightVirtualFile(KubernetesBundle.message((String)"HelmViewTemplateRenderAction.result.window.title", (Object[])objectArray), (CharSequence)processOutput.getStdout());
        boolean bl = false;
        $this$processOutput_u24lambda_u240.setWritable(false);
        Object[] result2 = objectArray;
        ActionsKt.runInEdt$default(null, () -> HelmViewTemplateRenderAction.processOutput$lambda$1(context2, (LightVirtualFile)result2), (int)1, null);
    }

    private static final Unit processOutput$lambda$1(KubernetesActionBase.ActionContext $context, LightVirtualFile $result) {
        FileEditorManager.getInstance((Project)$context.getProject()).openFile((VirtualFile)$result, true);
        return Unit.INSTANCE;
    }
}

