/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.kubernetes.KubernetesConfigurationUtilKt;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.KubernetesResourceKindType;
import com.intellij.kubernetes.model.ResourceIdentity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J#\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/ui/intentions/ApplyCrdIntentionAction;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "<init>", "()V", "startInWriteAction", "", "getText", "", "getFamilyName", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nApplyCrdIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplyCrdIntentionAction.kt\ncom/intellij/kubernetes/ui/intentions/ApplyCrdIntentionAction\n+ 2 KubernetesUtil.kt\ncom/intellij/kubernetes/KubernetesUtilKt\n*L\n1#1,37:1\n273#2:38\n*S KotlinDebug\n*F\n+ 1 ApplyCrdIntentionAction.kt\ncom/intellij/kubernetes/ui/intentions/ApplyCrdIntentionAction\n*L\n28#1:38\n*E\n"})
public final class ApplyCrdIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        String string = KubernetesBundle.message((String)"ApplyCrdIntentionAction.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        YAMLScalar yAMLScalar = (YAMLScalar)YamlUtilKt.getTypedAncestorOrSelf((PsiElement)element, YAMLScalar.class);
        if (yAMLScalar == null) {
            return false;
        }
        YAMLScalar scalar = yAMLScalar;
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)scalar));
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vfsFile = virtualFile;
        if (!(vfsFile.getFileSystem() instanceof LocalFileSystem)) {
            return false;
        }
        YAMLPsiElement $this$k8sMetaType$iv = (YAMLPsiElement)scalar;
        boolean $i$f$k8sMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getK8sMetaTypeProxy($this$k8sMetaType$iv);
        Object object2 = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        if (!(object2 instanceof KubernetesResourceKindType)) {
            object2 = null;
        }
        if (!Intrinsics.areEqual((object = (KubernetesResourceKindType)((YamlMetaType)((KubernetesResourceKindType)object2))) != null && (object = ((KubernetesResourceKindType)object).getResourceIdentity(scalar)) != null ? ((ResourceIdentity)object).getKind() : null, (Object)"CustomResourceDefinition")) {
            return false;
        }
        return !KubernetesConfigurationUtilKt.getAllExternalSpecPathsOrUrls(project).contains(vfsFile.getPath());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)element);
        if (virtualFile == null) {
            return;
        }
        KubernetesConfigurationUtilKt.addCrdSpecToProjectConfiguration(project, virtualFile);
    }
}

