/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.checkin.GitCheckinExplicitMovementProvider;
import git4idea.i18n.GitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B/\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001c0\u001bH\u0016R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgit4idea/checkin/ConvertLanguageExplicitMovementProvider;", "Lgit4idea/checkin/GitCheckinExplicitMovementProvider;", "sourceLanguageExtension", "", "Lcom/intellij/openapi/util/NlsSafe;", "targetLanguageExtension", "userDataKey", "Lcom/intellij/openapi/util/Key;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/util/Key;)V", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "getDescription", "getCommitMessage", "originalCommitMessage", "collectExplicitMovements", "", "Lgit4idea/checkin/GitCheckinExplicitMovementProvider$Movement;", "beforePaths", "", "Lcom/intellij/openapi/vcs/FilePath;", "afterPaths", "afterMovementsCommitted", "", "movedPaths", "", "Lcom/intellij/openapi/util/Couple;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nConvertLanguageExplicitMovementProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertLanguageExplicitMovementProvider.kt\ngit4idea/checkin/ConvertLanguageExplicitMovementProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1807#2,3:69\n1807#2,3:72\n296#2,2:75\n1915#2,2:77\n*S KotlinDebug\n*F\n+ 1 ConvertLanguageExplicitMovementProvider.kt\ngit4idea/checkin/ConvertLanguageExplicitMovementProvider\n*L\n34#1:69,3\n35#1:72,3\n43#1:75,2\n65#1:77,2\n*E\n"})
public abstract class ConvertLanguageExplicitMovementProvider
extends GitCheckinExplicitMovementProvider {
    @NotNull
    private final String sourceLanguageExtension;
    @NotNull
    private final String targetLanguageExtension;
    @NotNull
    private final Key<String> userDataKey;

    public ConvertLanguageExplicitMovementProvider(@NotNull String sourceLanguageExtension, @NotNull String targetLanguageExtension, @NotNull Key<String> userDataKey) {
        Intrinsics.checkNotNullParameter((Object)sourceLanguageExtension, (String)"sourceLanguageExtension");
        Intrinsics.checkNotNullParameter((Object)targetLanguageExtension, (String)"targetLanguageExtension");
        Intrinsics.checkNotNullParameter(userDataKey, (String)"userDataKey");
        this.sourceLanguageExtension = sourceLanguageExtension;
        this.targetLanguageExtension = targetLanguageExtension;
        this.userDataKey = userDataKey;
    }

    @Override
    public boolean isEnabled(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @Override
    @NotNull
    public String getDescription() {
        Object[] objectArray = new Object[]{this.sourceLanguageExtension, this.targetLanguageExtension};
        String string = GitBundle.message((String)"convert.language.extra.commit.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getCommitMessage(@NotNull String originalCommitMessage) {
        Intrinsics.checkNotNullParameter((Object)originalCommitMessage, (String)"originalCommitMessage");
        Object[] objectArray = new Object[]{this.sourceLanguageExtension, this.targetLanguageExtension};
        String string = GitBundle.message((String)"convert.language.extra.commit.commit.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Collection<GitCheckinExplicitMovementProvider.Movement> collectExplicitMovements(@NotNull Project project, @NotNull List<? extends FilePath> beforePaths, @NotNull List<? extends FilePath> afterPaths) {
        boolean afterWasTargetLanguage;
        boolean beforeWasSourceLanguage;
        block13: {
            boolean bl;
            block12: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(beforePaths, (String)"beforePaths");
                Intrinsics.checkNotNullParameter(afterPaths, (String)"afterPaths");
                Iterable $this$any$iv = beforePaths;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : $this$any$iv) {
                        FilePath it = (FilePath)t;
                        boolean bl2 = false;
                        String string = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (!StringsKt.endsWith$default((String)string, (String)("." + this.sourceLanguageExtension), (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            beforeWasSourceLanguage = bl;
            Iterable $this$any$iv = afterPaths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FilePath filePath = (FilePath)element$iv;
                    boolean bl3 = false;
                    String string = filePath.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)("." + this.targetLanguageExtension), (boolean)false, (int)2, null)) continue;
                    v2 = true;
                    break block13;
                }
                v2 = afterWasTargetLanguage = false;
            }
        }
        if (!beforeWasSourceLanguage || !afterWasTargetLanguage) {
            return CollectionsKt.emptyList();
        }
        ArrayList<GitCheckinExplicitMovementProvider.Movement> movedChanges = new ArrayList<GitCheckinExplicitMovementProvider.Movement>();
        for (FilePath filePath : afterPaths) {
            FilePath filePath2;
            Object v5;
            block14: {
                Object object = filePath.getVirtualFile();
                if (object == null || (object = (String)object.getUserData(this.userDataKey)) == null) continue;
                Object pathBeforeConversion = object;
                Iterable $this$firstOrNull$iv = beforePaths;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FilePath it = (FilePath)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPath(), (Object)pathBeforeConversion)) continue;
                    v5 = element$iv;
                    break block14;
                }
                v5 = null;
            }
            if ((FilePath)v5 == null) continue;
            movedChanges.add(new GitCheckinExplicitMovementProvider.Movement(filePath2, filePath));
        }
        if (beforePaths.size() > 1000) {
            return movedChanges;
        }
        Set existing = CollectionsKt.toSet((Iterable)movedChanges);
        HashMap hashMap = new HashMap();
        for (FilePath filePath : beforePaths) {
            String string = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!StringsKt.endsWith$default((String)string, (String)("." + this.sourceLanguageExtension), (boolean)false, (int)2, null)) continue;
            Map bl3 = hashMap;
            String string2 = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            bl3.put(StringsKt.dropLast((String)string2, (int)this.sourceLanguageExtension.length()) + this.targetLanguageExtension, filePath);
        }
        for (FilePath filePath : afterPaths) {
            FilePath before;
            GitCheckinExplicitMovementProvider.Movement movement;
            if ((FilePath)hashMap.get(filePath.getPath()) == null || existing.contains(movement = new GitCheckinExplicitMovementProvider.Movement(before, filePath))) continue;
            movedChanges.add(movement);
        }
        return movedChanges;
    }

    @Override
    public void afterMovementsCommitted(@NotNull Project project, @NotNull List<Couple<FilePath>> movedPaths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(movedPaths, (String)"movedPaths");
        Iterable $this$forEach$iv = movedPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Couple it = (Couple)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = ((FilePath)it.second).getVirtualFile();
            if (virtualFile == null) continue;
            virtualFile.putUserData(this.userDataKey, null);
        }
    }
}

