/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitUtil;
import git4idea.applyChanges.GitApplyChangesProcess;
import git4idea.cherrypick.EmptyCherryPickResolutionStrategy;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001f\u0010\n\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007*\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u0001*\u00020\u00042\b\b\u0003\u0010\u0010\u001a\u00020\u0006H\u0002\"\u001d\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"apply", "Lgit4idea/commands/GitCommandResult;", "Lgit4idea/cherrypick/EmptyCherryPickResolutionStrategy;", "repository", "Lgit4idea/repo/GitRepository;", "settingsMessage", "", "Lorg/jetbrains/annotations/Nls;", "getSettingsMessage", "(Lgit4idea/cherrypick/EmptyCherryPickResolutionStrategy;)Ljava/lang/String;", "notificationMessage", "appliedCommits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "skipCherryPick", "createEmptyCommit", "fallbackMessage", "intellij.vcs.git"})
public final class EmptyCherryPickResolutionStrategyKt {
    @NotNull
    public static final GitCommandResult apply(@NotNull EmptyCherryPickResolutionStrategy $this$apply, @NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$apply), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$apply.ordinal()]) {
            case 1 -> EmptyCherryPickResolutionStrategyKt.skipCherryPick(repository2);
            case 2 -> EmptyCherryPickResolutionStrategyKt.createEmptyCommit$default(repository2, null, 1, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final String getSettingsMessage(@NotNull EmptyCherryPickResolutionStrategy $this$settingsMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$settingsMessage), (String)"<this>");
        String string = GitBundle.message((String)(switch (WhenMappings.$EnumSwitchMapping$0[$this$settingsMessage.ordinal()]) {
            case 1 -> "settings.cherry.pick.empty.commit.skip";
            case 2 -> "settings.cherry.pick.empty.commit.create";
            default -> throw new NoWhenBranchMatchedException();
        }), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public static final String notificationMessage(@NotNull EmptyCherryPickResolutionStrategy $this$notificationMessage, @NotNull List<? extends VcsCommitMetadata> appliedCommits) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$notificationMessage), (String)"<this>");
        Intrinsics.checkNotNullParameter(appliedCommits, (String)"appliedCommits");
        CharSequence charSequence = switch (WhenMappings.$EnumSwitchMapping$0[$this$notificationMessage.ordinal()]) {
            case 1 -> {
                Object[] var6_2 = new Object[]{appliedCommits.size()};
                yield GitBundle.message((String)"cherry.pick.empty.commit.skip.notification.message", (Object[])var6_2);
            }
            case 2 -> {
                Object[] var6_2 = new Object[]{appliedCommits.size()};
                yield GitBundle.message((String)"cherry.pick.empty.commit.create.notification.message", (Object[])var6_2);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)charSequence);
        String baseMessage = charSequence;
        CharSequence $this$notificationMessage_u24lambda_u240 = charSequence = new StringBuilder();
        boolean bl = false;
        ((StringBuilder)$this$notificationMessage_u24lambda_u240).append(baseMessage);
        if (!((Collection)appliedCommits).isEmpty()) {
            ((StringBuilder)$this$notificationMessage_u24lambda_u240).append("<br/>");
            ((StringBuilder)$this$notificationMessage_u24lambda_u240).append(GitApplyChangesProcess.Companion.getCommitsDetails$intellij_vcs_git((Collection<? extends VcsCommitMetadata>)appliedCommits));
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static final GitCommandResult skipCherryPick(GitRepository $this$skipCherryPick) {
        GitLineHandler gitLineHandler;
        GitLineHandler $this$skipCherryPick_u24lambda_u240 = gitLineHandler = new GitLineHandler($this$skipCherryPick.getProject(), $this$skipCherryPick.getRoot(), GitCommand.CHERRY_PICK);
        boolean bl = false;
        String[] stringArray = new String[]{"--skip"};
        $this$skipCherryPick_u24lambda_u240.addParameters(stringArray);
        GitLineHandler handler = gitLineHandler;
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        return gitCommandResult;
    }

    private static final GitCommandResult createEmptyCommit(GitRepository $this$createEmptyCommit, @Nls String fallbackMessage) {
        GitLineHandler gitLineHandler;
        Pair pair;
        try {
            pair = TuplesKt.to((Object)GitUtil.hasLocalChanges(true, $this$createEmptyCommit.getProject(), $this$createEmptyCommit.getRoot()), null);
        }
        catch (VcsException e) {
            pair = TuplesKt.to((Object)false, (Object)e.getMessage());
        }
        Pair pair2 = pair;
        boolean hasStagedChanges = (Boolean)pair2.component1();
        String errorMsg = (String)pair2.component2();
        if (hasStagedChanges) {
            String string = errorMsg;
            if (string == null) {
                String string2 = GitBundle.message((String)"git.empty.commit.not.empty", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            GitCommandResult gitCommandResult = GitCommandResult.error(string);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"error(...)");
            return gitCommandResult;
        }
        File file = $this$createEmptyCommit.getRepositoryFiles().getMergeMessageFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getMergeMessageFile(...)");
        File messageFile = file;
        GitLineHandler $this$createEmptyCommit_u24lambda_u240 = gitLineHandler = new GitLineHandler($this$createEmptyCommit.getProject(), $this$createEmptyCommit.getRoot(), GitCommand.COMMIT);
        boolean bl = false;
        String[] stringArray = new String[]{"--allow-empty"};
        $this$createEmptyCommit_u24lambda_u240.addParameters(stringArray);
        if (messageFile.exists()) {
            stringArray = new String[]{"-F", messageFile.getAbsolutePath()};
            $this$createEmptyCommit_u24lambda_u240.addParameters(stringArray);
        } else {
            stringArray = new String[]{"-m", fallbackMessage};
            $this$createEmptyCommit_u24lambda_u240.addParameters(stringArray);
        }
        GitLineHandler handler = gitLineHandler;
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        return gitCommandResult;
    }

    static /* synthetic */ GitCommandResult createEmptyCommit$default(GitRepository gitRepository, String string, int n, Object object) {
        if ((n & 1) != 0) {
            String string2 = GitBundle.message((String)"cherry.pick.empty.cherry.pick.commit", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            string = string2;
        }
        return EmptyCherryPickResolutionStrategyKt.createEmptyCommit(gitRepository, string);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EmptyCherryPickResolutionStrategy.values().length];
            try {
                nArray[EmptyCherryPickResolutionStrategy.SKIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmptyCherryPickResolutionStrategy.CREATE_EMPTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

