/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.commit.CommitModeManager;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lgit4idea/index/CommitModeListener;", "Lcom/intellij/vcs/commit/CommitModeManager$CommitModeListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "commitModeChanged", "", "intellij.vcs.git"})
public final class CommitModeListener
implements CommitModeManager.CommitModeListener {
    @NotNull
    private final Project project;

    public CommitModeListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void commitModeChanged() {
        ThreadingAssertions.assertEventDispatchThread();
        if (GitStageManagerKt.isStagingAreaAvailable(this.project)) {
            GitStageTracker.Companion.getInstance(this.project).updateTrackerState();
        }
        ActionsKt.invokeLater$default(null, CommitModeListener::commitModeChanged$lambda$0, (int)1, null);
    }

    private static final Unit commitModeChanged$lambda$0() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = LineStatusTrackerSettingListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((LineStatusTrackerSettingListener)messageBus.syncPublisher(topic)).settingsUpdated();
        return Unit.INSTANCE;
    }
}

