/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.index.GitFileStatus;
import git4idea.index.LightFileStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u001aD\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f\u001aL\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016\u001a2\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0002\u001a \u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u001a:\u0010\u001f\u001a\u00020\u00182\b\b\u0001\u0010 \u001a\u00020\u00012\b\b\u0001\u0010\u001e\u001a\u00020\u00012\b\b\u0001\u0010!\u001a\u00020\u00012\b\b\u0001\u0010\"\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020#H\u0002\u001a\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020#H\u0002\u001a\u0016\u0010\u000f\u001a\u0004\u0018\u00010'2\n\u0010&\u001a\u00060#j\u0002`(H\u0000\u001a\u0012\u0010*\u001a\u00020\f2\n\u0010&\u001a\u00060#j\u0002`(\u001a\u0012\u0010+\u001a\u00020\f2\n\u0010&\u001a\u00060#j\u0002`(\u001a\u0012\u0010,\u001a\u00020\f2\n\u0010&\u001a\u00060#j\u0002`(\u001a\u0012\u0010-\u001a\u00020\f2\n\u0010&\u001a\u00060#j\u0002`(\u001a\u001e\u0010.\u001a\u00020\f2\n\u0010/\u001a\u00060#j\u0002`(2\n\u00100\u001a\u00060#j\u0002`(\u001a\u0012\u00101\u001a\u00020\f2\n\u0010&\u001a\u00060#j\u0002`(\u001a\u001e\u00102\u001a\u00020\f2\n\u0010/\u001a\u00060#j\u0002`(2\n\u00100\u001a\u00060#j\u0002`(\u001a\n\u00103\u001a\u00020\f*\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u00104\u001a\u0004\u0018\u00010\u0001*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b5\u00106*\n\u0010)\"\u00020#2\u00020#\u00a8\u00067"}, d2={"NUL", "", "getStatus", "", "Lgit4idea/index/GitFileStatus;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "Lcom/intellij/openapi/vcs/FilePath;", "withRenames", "", "withUntracked", "withIgnored", "getFileStatus", "Lgit4idea/index/LightFileStatus$StatusRecord;", "statusCommand", "Lgit4idea/commands/GitCommand;", "Lgit4idea/index/LightFileStatus;", "filePath", "executable", "Lgit4idea/config/GitExecutable;", "appendParameters", "", "Lgit4idea/commands/GitLineHandler;", "gitVersion", "Lgit4idea/config/GitVersion;", "getFilePath", "parseGitStatusOutput", "output", "throwGFE", "message", "line", "xStatus", "", "yStatus", "isKnownStatus", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "Lgit4idea/index/StatusCode;", "StatusCode", "isIgnored", "isUntracked", "isRenamed", "isAdded", "isIntendedToBeAdded", "index", "workTree", "isDeleted", "isConflicted", "isTracked", "repositoryPath", "getRepositoryPath", "(Lgit4idea/index/LightFileStatus;)Ljava/lang/String;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitIndexStatusUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexStatusUtil.kt\ngit4idea/index/GitIndexStatusUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,260:1\n1586#2:261\n1661#2,3:262\n37#3,2:265\n*S KotlinDebug\n*F\n+ 1 GitIndexStatusUtil.kt\ngit4idea/index/GitIndexStatusUtilKt\n*L\n66#1:261\n66#1:262,3\n148#1:265,2\n*E\n"})
public final class GitIndexStatusUtilKt {
    @NotNull
    public static final String NUL = "\u0000";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<GitFileStatus> getStatus(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends FilePath> files, boolean withRenames, boolean withUntracked, boolean withIgnored) throws VcsException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable iterable = GitIndexStatusUtilKt.getFileStatus$default(project, root, files, withRenames, withUntracked, withIgnored, null, 64, null);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LightFileStatus.StatusRecord statusRecord = (LightFileStatus.StatusRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new GitFileStatus(root, (LightFileStatus.StatusRecord)it));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getStatus$default(Project project, VirtualFile virtualFile, List list, boolean bl, boolean bl2, boolean bl3, int n, Object object) throws VcsException {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return GitIndexStatusUtilKt.getStatus(project, virtualFile, list, bl, bl2, bl3);
    }

    @NotNull
    public static final List<LightFileStatus.StatusRecord> getFileStatus(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends FilePath> files, boolean withRenames, boolean withUntracked, boolean withIgnored, @NotNull GitCommand statusCommand) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)statusCommand, (String)"statusCommand");
        Object t = GitUtil.createHandlerWithPaths((Collection<? extends FilePath>)files, () -> GitIndexStatusUtilKt.getFileStatus$lambda$0(project, root, statusCommand, withRenames, withUntracked, withIgnored));
        Intrinsics.checkNotNullExpressionValue(t, (String)"createHandlerWithPaths(...)");
        GitLineHandler h = (GitLineHandler)t;
        String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
        String output2 = string;
        return GitIndexStatusUtilKt.parseGitStatusOutput(output2);
    }

    public static /* synthetic */ List getFileStatus$default(Project project, VirtualFile virtualFile, List list, boolean bl, boolean bl2, boolean bl3, GitCommand gitCommand, int n, Object object) throws VcsException {
        if ((n & 0x40) != 0) {
            GitCommand gitCommand2 = GitCommand.STATUS;
            Intrinsics.checkNotNullExpressionValue((Object)gitCommand2, (String)"STATUS");
            gitCommand = gitCommand2;
        }
        return GitIndexStatusUtilKt.getFileStatus(project, virtualFile, list, bl, bl2, bl3, gitCommand);
    }

    @NotNull
    public static final LightFileStatus getFileStatus(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull GitExecutable executable) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        GitLineHandler h = new GitLineHandler(null, root.toNioPath(), executable, GitCommand.STATUS, CollectionsKt.emptyList());
        h.setSilent(true);
        GitVersion gitVersion2 = GitExecutableManager.getInstance().getVersion(executable);
        Intrinsics.checkNotNullExpressionValue((Object)gitVersion2, (String)"getVersion(...)");
        GitIndexStatusUtilKt.appendParameters(h, gitVersion2, false, true, true);
        h.endOptions();
        FilePath[] filePathArray = new FilePath[]{filePath};
        h.addRelativePaths(filePathArray);
        String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
        String output2 = string;
        if (!StringsKt.isBlank((CharSequence)output2)) {
            List<LightFileStatus.StatusRecord> gitStatusOutput = GitIndexStatusUtilKt.parseGitStatusOutput(output2);
            LightFileStatus.StatusRecord statusRecord = (LightFileStatus.StatusRecord)CollectionsKt.firstOrNull(gitStatusOutput);
            return statusRecord != null ? (LightFileStatus)statusRecord : (LightFileStatus)LightFileStatus.Blank.INSTANCE;
        }
        String string2 = GitIndexStatusUtilKt.getFilePath(root, filePath, executable);
        if (string2 == null) {
            return LightFileStatus.Blank.INSTANCE;
        }
        String repositoryPath = string2;
        return new LightFileStatus.NotChanged(repositoryPath);
    }

    private static final void appendParameters(GitLineHandler $this$appendParameters, GitVersion gitVersion2, boolean withRenames, boolean withUntracked, boolean withIgnored) {
        String[] stringArray = new String[]{"--porcelain", "-z"};
        $this$appendParameters.addParameters(stringArray);
        if (!withRenames && GitVersionSpecialty.STATUS_SUPPORTS_NO_RENAMES.existsIn(gitVersion2)) {
            stringArray = new String[]{"--no-renames"};
            $this$appendParameters.addParameters(stringArray);
        }
        stringArray = new String[]{"--untracked-files=" + (withUntracked ? "all" : "no")};
        $this$appendParameters.addParameters(stringArray);
        if (GitVersionSpecialty.STATUS_SUPPORTS_IGNORED_MODES.existsIn(gitVersion2)) {
            if (withIgnored) {
                stringArray = new String[]{"--ignored=matching"};
                $this$appendParameters.addParameters(stringArray);
            } else {
                stringArray = new String[]{"--ignored=no"};
                $this$appendParameters.addParameters(stringArray);
            }
        } else if (withIgnored) {
            stringArray = new String[]{"--ignored"};
            $this$appendParameters.addParameters(stringArray);
        }
    }

    static /* synthetic */ void appendParameters$default(GitLineHandler gitLineHandler, GitVersion gitVersion2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        GitIndexStatusUtilKt.appendParameters(gitLineHandler, gitVersion2, bl, bl2, bl3);
    }

    @Nullable
    public static final String getFilePath(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull GitExecutable executable) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        GitLineHandler handler = new GitLineHandler(null, root.toNioPath(), executable, GitCommand.LS_FILES, CollectionsKt.emptyList());
        String[] stringArray = new String[]{"--full-name"};
        handler.addParameters(stringArray);
        stringArray = new FilePath[]{filePath};
        handler.addRelativePaths((FilePath[])stringArray);
        handler.setSilent(true);
        String string = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
        return (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)string));
    }

    private static final List<LightFileStatus.StatusRecord> parseGitStatusOutput(String output2) throws VcsException {
        List result2 = new ArrayList();
        String[] stringArray = new String[]{NUL};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)output2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] split = thisCollection$iv.toArray(new String[0]);
        Iterator it = ArrayIteratorKt.iterator((Object[])split);
        while (it.hasNext()) {
            boolean bl;
            String pathPart;
            String line = (String)it.next();
            if (StringsKt.isBlank((CharSequence)line) || StringsKt.startsWith$default((String)line, (String)"starting fsmonitor-daemon in ", (boolean)false, (int)2, null)) continue;
            if (line.length() < 4 || line.charAt(2) != ' ') {
                String string = GitBundle.message((String)"status.exception.message.line.is.too.short", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                GitIndexStatusUtilKt.throwGFE(string, output2, line, '0', '0');
            }
            char xStatus = line.charAt(0);
            char yStatus = line.charAt(1);
            if (!GitIndexStatusUtilKt.isKnownStatus(xStatus) || !GitIndexStatusUtilKt.isKnownStatus(yStatus)) {
                String string = GitBundle.message((String)"status.exception.message.unexpected", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                GitIndexStatusUtilKt.throwGFE(string, output2, line, xStatus, yStatus);
            }
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(3), (String)"substring(...)");
            if (GitIndexStatusUtilKt.isRenamed(xStatus) || GitIndexStatusUtilKt.isRenamed(yStatus)) {
                if (!it.hasNext()) {
                    String string = GitBundle.message((String)"status.exception.message.missing.path", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    GitIndexStatusUtilKt.throwGFE(string, output2, line, xStatus, yStatus);
                    continue;
                }
                String origPath = (String)it.next();
                bl = result2.add(new LightFileStatus.StatusRecord(xStatus, yStatus, pathPart, origPath));
                continue;
            }
            bl = result2.add(new LightFileStatus.StatusRecord(xStatus, yStatus, pathPart, null, 8, null));
        }
        return result2;
    }

    private static final void throwGFE(@Nls String message, @NlsSafe String output2, @NlsSafe String line, @NlsSafe char xStatus, @NlsSafe char yStatus) {
        Object[] objectArray = new Object[]{message, Character.valueOf(xStatus), Character.valueOf(yStatus), line, output2};
        throw new VcsException(GitBundle.message((String)"status.exception.message.format.message.xstatus.ystatus.line.output", (Object[])objectArray));
    }

    private static final boolean isKnownStatus(char status) {
        return status == ' ' || status == 'M' || status == 'A' || status == 'D' || status == 'C' || status == 'R' || status == 'U' || status == 'T' || status == '!' || status == '?';
    }

    @Nullable
    public static final FileStatus getFileStatus(char status) throws VcsException {
        return switch (status) {
            case ' ' -> null;
            case 'C', 'M', 'R', 'T' -> FileStatus.MODIFIED;
            case 'A' -> FileStatus.ADDED;
            case 'D' -> FileStatus.DELETED;
            case 'U' -> FileStatus.MERGED_WITH_CONFLICTS;
            case '!' -> FileStatus.IGNORED;
            case '?' -> FileStatus.UNKNOWN;
            default -> {
                Object[] var1_1 = new Object[]{Character.valueOf(status)};
                throw new VcsException(GitBundle.message((String)"status.exception.message.unexpected.status", (Object[])var1_1));
            }
        };
    }

    public static final boolean isIgnored(char status) {
        return status == '!';
    }

    public static final boolean isUntracked(char status) {
        return status == '?';
    }

    public static final boolean isRenamed(char status) {
        return status == 'R' || status == 'C';
    }

    public static final boolean isAdded(char status) {
        return status == 'A';
    }

    public static final boolean isIntendedToBeAdded(char index, char workTree) {
        return index == ' ' && workTree == 'A';
    }

    public static final boolean isDeleted(char status) {
        return status == 'D';
    }

    public static final boolean isConflicted(char index, char workTree) {
        return index == 'D' && workTree == 'D' || index == 'A' && workTree == 'A' || index == 'T' && workTree == 'T' || index == 'U' || workTree == 'U';
    }

    public static final boolean isTracked(@NotNull LightFileStatus $this$isTracked) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isTracked, (String)"<this>");
        LightFileStatus lightFileStatus = $this$isTracked;
        if (Intrinsics.areEqual((Object)lightFileStatus, (Object)LightFileStatus.Blank.INSTANCE)) {
            bl = false;
        } else if (lightFileStatus instanceof LightFileStatus.NotChanged) {
            bl = true;
        } else if (lightFileStatus instanceof LightFileStatus.StatusRecord) {
            bl = !GitIndexStatusUtilKt.isIgnored(((LightFileStatus.StatusRecord)$this$isTracked).getIndex()) && !GitIndexStatusUtilKt.isUntracked(((LightFileStatus.StatusRecord)$this$isTracked).getIndex());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Nullable
    public static final String getRepositoryPath(@NotNull LightFileStatus $this$repositoryPath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$repositoryPath, (String)"<this>");
        LightFileStatus lightFileStatus = $this$repositoryPath;
        if (Intrinsics.areEqual((Object)lightFileStatus, (Object)LightFileStatus.Blank.INSTANCE)) {
            string = null;
        } else if (lightFileStatus instanceof LightFileStatus.NotChanged) {
            string = ((LightFileStatus.NotChanged)$this$repositoryPath).getPath();
        } else if (lightFileStatus instanceof LightFileStatus.StatusRecord) {
            if (!GitIndexStatusUtilKt.isTracked($this$repositoryPath) || ((LightFileStatus.StatusRecord)$this$repositoryPath).getIndex() == 'A' || ((LightFileStatus.StatusRecord)$this$repositoryPath).getWorkTree() == 'A') {
                string = null;
            } else {
                string = ((LightFileStatus.StatusRecord)$this$repositoryPath).getOrigPath();
                if (string == null) {
                    string = ((LightFileStatus.StatusRecord)$this$repositoryPath).getPath();
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final GitLineHandler getFileStatus$lambda$0(Project $project, VirtualFile $root, GitCommand $statusCommand, boolean $withRenames, boolean $withUntracked, boolean $withIgnored) {
        GitLineHandler h = new GitLineHandler($project, $root, $statusCommand);
        h.setSilent(true);
        GitVersion gitVersion2 = GitExecutableManager.getInstance().tryGetVersion($project);
        if (gitVersion2 == null) {
            gitVersion2 = GitVersion.NULL;
        }
        GitVersion gitVersion3 = gitVersion2;
        Intrinsics.checkNotNull((Object)gitVersion3);
        GitIndexStatusUtilKt.appendParameters(h, gitVersion3, $withRenames, $withUntracked, $withIgnored);
        return h;
    }
}

