/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.repo.GitCommitTemplate;
import git4idea.repo.GitCommitTemplateListener;
import git4idea.repo.GitCommitTemplateTrackerKt;
import git4idea.repo.GitConfigListener;
import git4idea.repo.GitRepository;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0001\u0018\u0000 :2\u00020\u00012\u00020\u00022\u00020\u0003:\u00029:B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0007J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u001c\u0010\u001f\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0096@\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u0012H\u0007J\u001c\u0010%\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0082@\u00a2\u0006\u0002\u0010#J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u001dH\u0002J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u001dH\u0002J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u001dH\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u00100\u001a\u00020\u001dH\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u001d2\u0006\u00102\u001a\u00020\u001dH\u0002J\u001a\u00103\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u00104\u001a\u00020\u001dH\u0002J\u0010\u00105\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\fH\u0003J\u001a\u00106\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\b\u00107\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u00108\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006;"}, d2={"Lgit4idea/repo/GitCommitTemplateTracker;", "Lgit4idea/repo/GitConfigListener;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "commitTemplates", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/repo/GitCommitTemplate;", "TEMPLATES_LOCK", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "_initPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "initPromise", "Lorg/jetbrains/concurrency/Promise;", "getInitPromise", "()Lorg/jetbrains/concurrency/Promise;", "templatesCount", "", "exists", "", "repository", "getTemplateContent", "", "notifyConfigChanged", "filesChanged", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "processEvents", "isEventToStopTracking", "event", "watchedTemplatePath", "isEventToReloadTemplateContent", "stopTrackCommitTemplate", "reloadCommitTemplateContent", "loadTemplateContent", "commitTemplateFilePath", "resolveCommitTemplatePath", "resolvePathAsAbsolute", "gitCommitTemplatePath", "resolvePathRelativeToUserHome", "fileNameOrPath", "resolvePathRelativeToRootDirs", "relativeFilePath", "trackCommitTemplate", "updateTemplatePath", "newTemplatePath", "dispose", "GitCommitTemplateTrackerStartupActivity", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCommitTemplateTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitTemplateTracker.kt\ngit4idea/repo/GitCommitTemplateTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n1#2:331\n1807#3,3:332\n1915#3,2:335\n1586#3:337\n1661#3,3:338\n*S KotlinDebug\n*F\n+ 1 GitCommitTemplateTracker.kt\ngit4idea/repo/GitCommitTemplateTracker\n*L\n73#1:332,3\n107#1:335,2\n280#1:337\n280#1:338,3\n*E\n"})
public final class GitCommitTemplateTracker
implements GitConfigListener,
AsyncVfsEventsListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<GitRepository, GitCommitTemplate> commitTemplates;
    @NotNull
    private final ReentrantReadWriteLock TEMPLATES_LOCK;
    @NotNull
    private final AsyncPromise<Unit> _initPromise;

    public GitCommitTemplateTracker(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.commitTemplates = new LinkedHashMap();
        this.TEMPLATES_LOCK = new ReentrantReadWriteLock();
        this._initPromise = new AsyncPromise();
        this.project.getMessageBus().connect(coroutineScope).subscribe(GitConfigListener.TOPIC, (Object)this);
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, coroutineScope);
    }

    @NotNull
    public final Promise<Unit> getInitPromise() {
        return (Promise)this._initPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int templatesCount() {
        int n;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.commitTemplates.values().size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final boolean exists(@Nullable GitRepository repository2) {
        boolean bl;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl2;
            block8: {
                boolean bl3 = false;
                if (repository2 != null) {
                    Object object = this.commitTemplates.get(repository2);
                    bl2 = object != null && (object = ((GitCommitTemplate)object).getContent()) != null ? !StringsKt.isBlank((CharSequence)((CharSequence)object)) : false;
                } else {
                    Iterable $this$any$iv = this.commitTemplates.values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            GitCommitTemplate it = (GitCommitTemplate)element$iv;
                            boolean bl4 = false;
                            boolean bl5 = !StringsKt.isBlank((CharSequence)it.getContent());
                            if (!bl5) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                }
            }
            bl = bl2;
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    public static /* synthetic */ boolean exists$default(GitCommitTemplateTracker gitCommitTemplateTracker, GitRepository gitRepository, int n, Object object) {
        if ((n & 1) != 0) {
            gitRepository = null;
        }
        return gitCommitTemplateTracker.exists(gitRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @Nullable
    public final String getTemplateContent(@Nullable GitRepository repository2) {
        String string;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            String string2;
            boolean bl = false;
            if (repository2 != null) {
                Object object = this.commitTemplates.get(repository2);
                if (object != null && (object = ((GitCommitTemplate)object).getContent()) != null) {
                    CharSequence charSequence;
                    CharSequence charSequence2 = (CharSequence)object;
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        boolean bl2 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    string2 = (String)charSequence;
                } else {
                    string2 = null;
                }
            } else {
                Object object = (GitCommitTemplate)CollectionsKt.firstOrNull((Iterable)this.commitTemplates.values());
                if (object != null && (object = ((GitCommitTemplate)object).getContent()) != null) {
                    CharSequence charSequence;
                    CharSequence charSequence3 = (CharSequence)object;
                    if (StringsKt.isBlank((CharSequence)charSequence3)) {
                        boolean bl3 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence3;
                    }
                    string2 = (String)charSequence;
                } else {
                    string2 = null;
                }
            }
            string = string2;
        }
        finally {
            readLock.unlock();
        }
        return string;
    }

    public static /* synthetic */ String getTemplateContent$default(GitCommitTemplateTracker gitCommitTemplateTracker, GitRepository gitRepository, int n, Object object) {
        if ((n & 1) != 0) {
            gitRepository = null;
        }
        return gitCommitTemplateTracker.getTemplateContent(gitRepository);
    }

    @Override
    public void notifyConfigChanged(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        this.trackCommitTemplate(repository2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object filesChanged(@NotNull List<? extends VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
        boolean bl;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            bl = this.commitTemplates.isEmpty();
        }
        finally {
            readLock.unlock();
        }
        if (bl) {
            return Unit.INSTANCE;
        }
        Object object = this.processEvents(events, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @RequiresBackgroundThread
    public final void start() {
        try {
            ((GitCommitTemplateListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitCommitTemplateListener.TOPIC)).loadingStarted();
            Collection<GitRepository> collection = GitUtil.getRepositories(this.project);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositories(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GitRepository p0 = (GitRepository)element$iv;
                boolean bl = false;
                this.trackCommitTemplate(p0);
            }
            ((GitCommitTemplateListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitCommitTemplateListener.TOPIC)).loadingFinished();
        }
        finally {
            this._initPromise.setResult(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object processEvents(List<? extends VFileEvent> events, Continuation<? super Unit> $completion) {
        Map map2;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            map2 = MapsKt.toMap(this.commitTemplates);
        }
        finally {
            readLock.unlock();
        }
        Map allTemplates = map2;
        if (allTemplates.isEmpty()) {
            return Unit.INSTANCE;
        }
        for (VFileEvent vFileEvent : events) {
            JobKt.ensureActive((CoroutineContext)$completion.getContext());
            for (Map.Entry entry : allTemplates.entrySet()) {
                String watchedTemplatePath;
                GitRepository repository2 = (GitRepository)entry.getKey();
                GitCommitTemplate template = (GitCommitTemplate)entry.getValue();
                JobKt.ensureActive((CoroutineContext)$completion.getContext());
                Intrinsics.checkNotNullExpressionValue((Object)template.getWatchedRoot().getRootPath(), (String)"getRootPath(...)");
                boolean templateChanged = false;
                if (this.isEventToStopTracking(vFileEvent, watchedTemplatePath)) {
                    var12_16 = this;
                    synchronized (var12_16) {
                        boolean $i$a$-synchronized-GitCommitTemplateTracker$processEvents$432 = false;
                        this.stopTrackCommitTemplate(repository2);
                        Unit $i$a$-synchronized-GitCommitTemplateTracker$processEvents$432 = Unit.INSTANCE;
                    }
                    templateChanged = true;
                } else if (this.isEventToReloadTemplateContent(vFileEvent, watchedTemplatePath)) {
                    var12_16 = this;
                    synchronized (var12_16) {
                        boolean bl = false;
                        this.reloadCommitTemplateContent(repository2);
                        Unit unit = Unit.INSTANCE;
                    }
                    templateChanged = true;
                }
                if (!templateChanged) continue;
                ((GitCommitTemplateListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitCommitTemplateListener.TOPIC)).notifyCommitTemplateChanged(repository2);
            }
        }
        return Unit.INSTANCE;
    }

    private final boolean isEventToStopTracking(VFileEvent event, String watchedTemplatePath) {
        return event instanceof VFileDeleteEvent ? Intrinsics.areEqual((Object)((VFileDeleteEvent)event).getPath(), (Object)watchedTemplatePath) : (event instanceof VFileMoveEvent ? Intrinsics.areEqual((Object)((VFileMoveEvent)event).getOldPath(), (Object)watchedTemplatePath) : (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename() ? Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)event).getOldPath(), (Object)watchedTemplatePath) : false));
    }

    private final boolean isEventToReloadTemplateContent(VFileEvent event, String watchedTemplatePath) {
        return event instanceof VFileContentChangeEvent && Intrinsics.areEqual((Object)((VFileContentChangeEvent)event).getPath(), (Object)watchedTemplatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopTrackCommitTemplate(GitRepository repository2) {
        GitCommitTemplate gitCommitTemplate;
        ReentrantReadWriteLock reentrantReadWriteLock = this.TEMPLATES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            GitCommitTemplate gitCommitTemplate2 = this.commitTemplates.remove(repository2);
            gitCommitTemplate = gitCommitTemplate2;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (gitCommitTemplate == null) {
            return;
        }
        GitCommitTemplate commitTemplate = gitCommitTemplate;
        LocalFileSystem.getInstance().removeWatchedRoot(commitTemplate.getWatchedRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reloadCommitTemplateContent(GitRepository repository2) {
        GitCommitTemplate gitCommitTemplate;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            GitCommitTemplate gitCommitTemplate2 = this.commitTemplates.get(repository2);
            gitCommitTemplate = gitCommitTemplate2;
        }
        finally {
            readLock.unlock();
        }
        Object object = gitCommitTemplate;
        if (gitCommitTemplate == null || (object = ((GitCommitTemplate)object).getWatchedRoot()) == null || (object = object.getRootPath()) == null) {
            return;
        }
        Object commitTemplateRootPath = object;
        String string = this.loadTemplateContent(repository2, (String)commitTemplateRootPath);
        if (string == null) {
            return;
        }
        String loadedContent = string;
        ReentrantReadWriteLock reentrantReadWriteLock = this.TEMPLATES_LOCK;
        readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Unit unit;
            boolean bl = false;
            GitCommitTemplate gitCommitTemplate3 = this.commitTemplates.get(repository2);
            if (gitCommitTemplate3 != null) {
                GitCommitTemplate commitTemplate = gitCommitTemplate3;
                boolean bl2 = false;
                commitTemplate.setContent(loadedContent);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final String loadTemplateContent(GitRepository repository2, String commitTemplateFilePath) {
        try {
            String string = FileUtil.loadFile((File)new File(commitTemplateFilePath), (Charset)GitConfigUtil.getCommitEncodingCharset(this.project, repository2.getRoot()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
            String fileContent = string;
            if (StringsKt.isBlank((CharSequence)fileContent)) {
                GitCommitTemplateTrackerKt.access$getLOG$p().warn("Empty or blank commit template detected for repository " + repository2 + " by path " + commitTemplateFilePath);
            }
            return fileContent;
        }
        catch (IOException e) {
            GitCommitTemplateTrackerKt.access$getLOG$p().warn("Cannot load commit template for repository " + repository2 + " by path " + commitTemplateFilePath, (Throwable)e);
            return null;
        }
    }

    private final String resolveCommitTemplatePath(GitRepository repository2) {
        String[] stringArray = new String[]{"commit.template"};
        String string = Git.getInstance().config(repository2, stringArray).getOutputAsJoinedString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputAsJoinedString(...)");
        String gitCommitTemplatePath = string;
        if (StringsKt.isBlank((CharSequence)gitCommitTemplatePath)) {
            return null;
        }
        if (StringsKt.endsWith$default((CharSequence)gitCommitTemplatePath, (char)'/', (boolean)false, (int)2, null)) {
            return null;
        }
        String string2 = this.resolvePathAsAbsolute(repository2, gitCommitTemplatePath);
        if (string2 == null && (string2 = this.resolvePathRelativeToUserHome(gitCommitTemplatePath)) == null) {
            string2 = this.resolvePathRelativeToRootDirs(repository2, gitCommitTemplatePath);
        }
        return string2;
    }

    private final String resolvePathAsAbsolute(GitRepository repository2, String gitCommitTemplatePath) {
        GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable(repository2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        GitExecutable executable = gitExecutable;
        String string = repository2.getRoot().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path localPath = executable.convertFilePathBack(gitCommitTemplatePath, path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(localPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return ((Object)localPath).toString();
        }
        return null;
    }

    private final String resolvePathRelativeToUserHome(String fileNameOrPath) {
        if (StringsKt.startsWith$default((CharSequence)fileNameOrPath, (char)'~', (boolean)false, (int)2, null)) {
            String string = SystemProperties.getUserHome();
            String string2 = fileNameOrPath.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            File fileAtUserHome = new File(string, string2);
            if (fileAtUserHome.exists()) {
                return fileAtUserHome.getPath();
            }
        }
        return null;
    }

    private final String resolvePathRelativeToRootDirs(GitRepository repository2, String relativeFilePath) {
        if (StringsKt.startsWith$default((CharSequence)relativeFilePath, (char)'/', (boolean)false, (int)2, null)) {
            return null;
        }
        for (VirtualFile rootDir : repository2.getRepositoryFiles().getRootDirs()) {
            Object rootDirParent;
            File templateFile;
            Object object = rootDir.getParent();
            if (object == null) continue;
            if ((object = object.getPath()) == null || !(templateFile = new File((String)(rootDirParent = object), relativeFilePath)).exists()) continue;
            return templateFile.getPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private final void trackCommitTemplate(GitRepository repository2) {
        boolean bl;
        String newTemplatePath = this.resolveCommitTemplatePath(repository2);
        GitCommitTemplateTracker gitCommitTemplateTracker = this;
        synchronized (gitCommitTemplateTracker) {
            boolean bl2 = false;
            bl = this.updateTemplatePath(repository2, newTemplatePath);
        }
        boolean templateChanged = bl;
        if (templateChanged) {
            ((GitCommitTemplateListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitCommitTemplateListener.TOPIC)).notifyCommitTemplateChanged(repository2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean updateTemplatePath(GitRepository repository2, String newTemplatePath) {
        LocalFileSystem.WatchRequest newWatchRoot;
        String oldTemplatePath;
        LocalFileSystem.WatchRequest oldWatchRoot;
        LocalFileSystem.WatchRequest $i$a$-read-GitCommitTemplateTracker$updateTemplatePath$oldWatchRoot$22;
        ReentrantReadWriteLock.ReadLock readLock = this.TEMPLATES_LOCK.readLock();
        readLock.lock();
        try {
            boolean $i$a$-read-GitCommitTemplateTracker$updateTemplatePath$oldWatchRoot$22 = false;
            GitCommitTemplate gitCommitTemplate = this.commitTemplates.get(repository2);
            $i$a$-read-GitCommitTemplateTracker$updateTemplatePath$oldWatchRoot$22 = gitCommitTemplate != null ? gitCommitTemplate.getWatchedRoot() : null;
        }
        finally {
            readLock.unlock();
        }
        LocalFileSystem.WatchRequest watchRequest = oldWatchRoot = $i$a$-read-GitCommitTemplateTracker$updateTemplatePath$oldWatchRoot$22;
        String string = oldTemplatePath = watchRequest != null ? watchRequest.getRootPath() : null;
        if (Intrinsics.areEqual((Object)oldTemplatePath, (Object)newTemplatePath)) {
            return false;
        }
        if (newTemplatePath == null) {
            this.stopTrackCommitTemplate(repository2);
            return true;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        lfs.refreshAndFindFileByPath(newTemplatePath);
        String templateContent = this.loadTemplateContent(repository2, newTemplatePath);
        if (templateContent == null) {
            this.stopTrackCommitTemplate(repository2);
            return true;
        }
        LocalFileSystem.WatchRequest watchRequest2 = oldWatchRoot;
        LocalFileSystem.WatchRequest watchRequest3 = newWatchRoot = watchRequest2 != null ? lfs.replaceWatchedRoot(watchRequest2, newTemplatePath, false) : lfs.addRootToWatch(newTemplatePath, false);
        if (newWatchRoot == null) {
            GitCommitTemplateTrackerKt.access$getLOG$p().error("Cannot add root to watch " + newTemplatePath);
            if (oldWatchRoot != null) {
                this.stopTrackCommitTemplate(repository2);
                return true;
            }
            return false;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.TEMPLATES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock2.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.commitTemplates.put(repository2, new GitCommitTemplate(newWatchRoot, templateContent));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock2.lock();
            }
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void dispose() {
        List $i$a$-read-GitCommitTemplateTracker$dispose$watchRootsToDispose$22;
        Object object = this.TEMPLATES_LOCK.readLock();
        ((ReentrantReadWriteLock.ReadLock)object).lock();
        try {
            void $this$mapTo$iv$iv;
            boolean $i$a$-read-GitCommitTemplateTracker$dispose$watchRootsToDispose$22 = false;
            Iterable $this$map$iv = this.commitTemplates.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                GitCommitTemplate gitCommitTemplate = (GitCommitTemplate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getWatchedRoot());
            }
            $i$a$-read-GitCommitTemplateTracker$dispose$watchRootsToDispose$22 = (List)destination$iv$iv;
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)object).unlock();
        }
        List watchRootsToDispose = $i$a$-read-GitCommitTemplateTracker$dispose$watchRootsToDispose$22;
        if (watchRootsToDispose.isEmpty()) {
            return;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        for (LocalFileSystem.WatchRequest watchedRoot : watchRootsToDispose) {
            lfs.removeWatchedRoot(watchedRoot);
        }
        object = this.TEMPLATES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.commitTemplates.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @JvmOverloads
    public final boolean exists() {
        return GitCommitTemplateTracker.exists$default(this, null, 1, null);
    }

    @JvmOverloads
    @Nullable
    public final String getTemplateContent() {
        return GitCommitTemplateTracker.getTemplateContent$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final GitCommitTemplateTracker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Object access$processEvents(GitCommitTemplateTracker $this, List events, Continuation $completion) {
        return $this.processEvents(events, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/repo/GitCommitTemplateTracker$Companion;", "", "<init>", "()V", "getInstance", "Lgit4idea/repo/GitCommitTemplateTracker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitCommitTemplateTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitTemplateTracker.kt\ngit4idea/repo/GitCommitTemplateTracker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,330:1\n30#2,2:331\n*S KotlinDebug\n*F\n+ 1 GitCommitTemplateTracker.kt\ngit4idea/repo/GitCommitTemplateTracker$Companion\n*L\n303#1:331,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitCommitTemplateTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitCommitTemplateTracker> serviceClass$iv = GitCommitTemplateTracker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GitCommitTemplateTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lgit4idea/repo/GitCommitTemplateTracker$GitCommitTemplateTrackerStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.git"})
    public static final class GitCommitTemplateTrackerStartupActivity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            ProjectLevelVcsManager.Companion.getInstance(project).runAfterInitialization(() -> GitCommitTemplateTrackerStartupActivity.execute$lambda$0(project));
            return Unit.INSTANCE;
        }

        private static final void execute$lambda$0(Project $project) {
            Companion.getInstance($project).start();
        }
    }
}

