/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.grammar;

import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.grammar.LanguageToolChecker;
import com.intellij.grazie.grammar.LanguageToolRule;
import com.intellij.grazie.ide.ui.components.utils.UtilsKt;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Interner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.html.ApiKt;
import kotlinx.html.BODY;
import kotlinx.html.CoreAttributeGroupFacade;
import kotlinx.html.FlowContent;
import kotlinx.html.Gen_attr_traitsKt;
import kotlinx.html.P;
import kotlinx.html.Tag;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.en.EnglishUnpairedQuotesRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010#\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0002\u001a \u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a \u0010)\u001a\u00020\u00192\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0010\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,H\u0003\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u001f\u001a\u00020\u0005*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "interner", "Lcom/intellij/util/containers/Interner;", "", "Lorg/jetbrains/annotations/NotNull;", "sentenceSeparationRules", "", "openClosedRangeStart", "Lkotlin/text/Regex;", "openClosedRangeEnd", "quotedLiteralPattern", "suggestionQuotePattern", "nextWordPattern", "an_vs_a_exclusions", "", "", "grammarRules", "Lcom/intellij/grazie/grammar/LanguageToolRule;", "tool", "Lorg/languagetool/JLanguageTool;", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "isGitCherryPickedFrom", "", "match", "Lorg/languagetool/rules/RuleMatch;", "text", "Lcom/intellij/grazie/text/TextContent;", "isKnownLTBug", "messageSanitized", "getMessageSanitized", "(Lorg/languagetool/rules/RuleMatch;)Ljava/lang/String;", "isPartOfQuotedLiteralText", "couldBeOpenClosedRange", "index", "", "isNumberRange", "startOffset", "endOffset", "isPathPart", "toTooltipTemplate", "problem", "Lcom/intellij/grazie/text/TextProblem;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLanguageToolChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageToolChecker.kt\ncom/intellij/grazie/grammar/LanguageToolCheckerKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 gen-tag-groups.kt\nkotlinx/html/Gen_tag_groupsKt\n+ 8 api.kt\nkotlinx/html/ApiKt\n+ 9 visit.kt\nkotlinx/html/VisitKt\n*L\n1#1,332:1\n1011#2:333\n1041#2,3:334\n1044#2,3:344\n1276#2,2:357\n383#3,7:337\n129#4:347\n158#4,3:348\n1123#5,3:351\n1807#6,3:354\n199#7,5:359\n204#7:369\n199#7,5:370\n204#7:380\n76#8:364\n76#8:375\n4#9,4:365\n4#9,4:376\n*S KotlinDebug\n*F\n+ 1 LanguageToolChecker.kt\ncom/intellij/grazie/grammar/LanguageToolCheckerKt\n*L\n215#1:333\n215#1:334,3\n215#1:344,3\n298#1:357,2\n215#1:337,7\n216#1:347\n216#1:348,3\n239#1:351,3\n281#1:354,3\n321#1:359,5\n321#1:369\n325#1:370,5\n325#1:380\n321#1:364\n325#1:375\n321#1:365,4\n325#1:376,4\n*E\n"})
public final class LanguageToolCheckerKt {
    private static final Logger logger = LoggerFactory.getLogger(LanguageToolChecker.class);
    @NotNull
    private static final Interner<String> interner;
    @NotNull
    private static final Set<String> sentenceSeparationRules;
    @NotNull
    private static final Regex openClosedRangeStart;
    @NotNull
    private static final Regex openClosedRangeEnd;
    @NotNull
    private static final Regex quotedLiteralPattern;
    @NotNull
    private static final Regex suggestionQuotePattern;
    @NotNull
    private static final Regex nextWordPattern;
    @NotNull
    private static final Map<String, List<Regex>> an_vs_a_exclusions;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LanguageToolRule> grammarRules(@NotNull JLanguageTool tool2, @NotNull Lang lang) {
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tool2, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        List list = tool2.getAllRules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllRules(...)");
        Sequence $this$groupBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), LanguageToolCheckerKt::grammarRules$lambda$0);
        boolean $i$f$groupBy = false;
        Sequence sequence2 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Object element$iv$iv = iterator.next();
            Rule it = (Rule)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getId();
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            List rules = (List)entry.getValue();
            Object object2 = CollectionsKt.first((List)rules);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first(...)");
            object.add(new LanguageToolRule(lang, (Rule)object2, rules, false, 8, null));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean isGitCherryPickedFrom(RuleMatch match, TextContent text) {
        return Intrinsics.areEqual((Object)match.getRule().getId(), (Object)"EN_COMPOUNDS_CHERRY_PICKED") && match.getFromPos() > 0 && StringsKt.startsWith$default((CharSequence)text, (CharSequence)"(cherry picked from", (int)(match.getFromPos() - 1), (boolean)false, (int)4, null) && (text.getDomain() == TextContent.TextDomain.LITERALS || text.getDomain() == TextContent.TextDomain.PLAIN_TEXT && (Boolean)ActionsKt.runReadAction(() -> LanguageToolCheckerKt.isGitCherryPickedFrom$lambda$0(text)) != false);
    }

    private static final boolean isKnownLTBug(RuleMatch match, TextContent text) {
        if (match.getRule() instanceof EnglishUnpairedQuotesRule) {
            if (match.getFromPos() > 0 && (StringsKt.startsWith$default((CharSequence)text, (CharSequence)"\")", (int)(match.getFromPos() - 1), (boolean)false, (int)4, null) || StringsKt.contains$default((CharSequence)text.subSequence(0, match.getFromPos()), (CharSequence)"(\"", (boolean)false, (int)2, null))) {
                return true;
            }
            if (StringsKt.startsWith$default((CharSequence)text, (CharSequence)"'", (int)match.getFromPos(), (boolean)false, (int)4, null) && StringsKt.contains$default((CharSequence)text.subSequence(match.getFromPos() + 1, text.length()), (CharSequence)"'", (boolean)false, (int)2, null)) {
                return true;
            }
            if (match.getFromPos() > 1 && StringsKt.startsWith$default((CharSequence)text, (CharSequence)"'", (int)match.getFromPos(), (boolean)false, (int)4, null)) {
                CharSequence $this$count$iv = text.subSequence(0, match.getFromPos());
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '\'')) continue;
                    ++count$iv;
                }
                if (count$iv == 1) {
                    return true;
                }
            }
            if (Intrinsics.areEqual((Object)((Object)((CharSequence)text).subSequence(match.getFromPos(), match.getToPos())).toString(), (Object)"\"") && StringsKt.contains$default((CharSequence)text.subSequence(0, match.getFromPos()), (CharSequence)"\"", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        if (match.getRule() instanceof GenericUnpairedBracketsRule) {
            if (LanguageToolCheckerKt.couldBeOpenClosedRange(text, match.getFromPos())) {
                return true;
            }
            if (LanguageToolCheckerKt.isPartOfQuotedLiteralText(match, text)) {
                return true;
            }
        }
        if (Intrinsics.areEqual((Object)match.getRule().getId(), (Object)"ARTICLE_ADJECTIVE_OF") && StringsKt.equals((String)((Object)((CharSequence)text).subSequence(match.getFromPos(), match.getToPos())).toString(), (String)"iterable", (boolean)true)) {
            return true;
        }
        String string = match.getRule().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        if (StringsKt.endsWith$default((String)string, (String)"DOUBLE_PUNCTUATION", (boolean)false, (int)2, null) && (LanguageToolCheckerKt.isNumberRange(match.getFromPos(), match.getToPos(), text) || LanguageToolCheckerKt.isPathPart(match.getFromPos(), match.getToPos(), text))) {
            return true;
        }
        if (Intrinsics.areEqual((Object)match.getRule().getId(), (Object)"A_RB_NN") && StringsKt.equals((String)((Object)((CharSequence)text).subSequence(match.getFromPos(), match.getToPos())).toString(), (String)"finally block", (boolean)true) && (text.getDomain() == TextContent.TextDomain.DOCUMENTATION || text.getDomain() == TextContent.TextDomain.COMMENTS)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)match.getRule().getFullId(), (Object)"UP_TO_DATE_HYPHEN[1]")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)match.getRule().getId(), (Object)"EN_A_VS_AN")) {
            boolean bl;
            block19: {
                String article = ((Object)((CharSequence)text).subSequence(match.getFromPos(), match.getToPos())).toString();
                MatchResult nextWordMatch = Regex.find$default((Regex)nextWordPattern, (CharSequence)text.subSequence(match.getToPos(), text.length()), (int)0, (int)2, null);
                Object object = nextWordMatch;
                if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                    return false;
                }
                Object nextWord = object;
                String string2 = article.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                List<Regex> list = an_vs_a_exclusions.get(string2);
                Intrinsics.checkNotNull(list);
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex regex = (Regex)element$iv;
                        boolean bl2 = false;
                        if (!regex.matches((CharSequence)nextWord)) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private static final String getMessageSanitized(RuleMatch $this$messageSanitized) {
        String string = $this$messageSanitized.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        String replacement = suggestionQuotePattern.containsMatchIn((CharSequence)string) ? "'" : "";
        String string2 = $this$messageSanitized.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"<suggestion>", (String)replacement, (boolean)false, (int)4, null), (String)"</suggestion>", (String)replacement, (boolean)false, (int)4, null);
    }

    private static final boolean isPartOfQuotedLiteralText(RuleMatch match, TextContent text) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.map((Sequence)Regex.findAll$default((Regex)quotedLiteralPattern, (CharSequence)((Object)text).toString(), (int)0, (int)2, null), LanguageToolCheckerKt::isPartOfQuotedLiteralText$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                TextRange it = (TextRange)element$iv;
                boolean bl2 = false;
                if (!it.intersectsStrict(match.getFromPos(), match.getToPos())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean couldBeOpenClosedRange(TextContent text, int index) {
        char unpaired = text.charAt(index);
        return StringsKt.contains$default((CharSequence)"([", (char)unpaired, (boolean)false, (int)2, null) && openClosedRangeStart.matchesAt((CharSequence)text, index) || StringsKt.contains$default((CharSequence)")]", (char)unpaired, (boolean)false, (int)2, null) && openClosedRangeEnd.matches(text.subSequence(0, index + 1));
    }

    private static final boolean isNumberRange(int startOffset, int endOffset, TextContent text) {
        return startOffset > 0 && endOffset < text.length() && Character.isDigit(text.charAt(startOffset - 1)) && Character.isDigit(text.charAt(endOffset));
    }

    private static final boolean isPathPart(int startOffset, int endOffset, TextContent text) {
        return StringsKt.endsWith$default((CharSequence)text.subSequence(0, startOffset), (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)text.subSequence(endOffset, text.length()), (char)'/', (boolean)false, (int)2, null);
    }

    @NlsSafe
    private static final String toTooltipTemplate(TextProblem problem) {
        String html = UtilsKt.html((Function1<? super BODY, Unit>)((Function1)arg_0 -> LanguageToolCheckerKt.toTooltipTemplate$lambda$0(problem, arg_0)));
        Object object = interner.intern((Object)html);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"intern(...)");
        return (String)object;
    }

    private static final boolean grammarRules$lambda$0(Rule it) {
        return !it.isDictionaryBasedSpellingRule();
    }

    private static final boolean isGitCherryPickedFrom$lambda$0(TextContent $text) {
        return CommitMessage.isCommitMessage((PsiElement)((PsiElement)$text.getContainingFile()));
    }

    private static final TextRange isPartOfQuotedLiteralText$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new TextRange(it.getRange().getFirst(), it.getRange().getLast());
    }

    private static final Unit toTooltipTemplate$lambda$0(TextProblem $problem, BODY $this$html) {
        Intrinsics.checkNotNullParameter((Object)$this$html, (String)"$this$html");
        FlowContent $this$p_u24default$iv = (FlowContent)$this$html;
        String classes$iv = null;
        boolean $i$f$p = false;
        Tag $this$visit$iv$iv = (Tag)new P(ApiKt.attributesMapOf((String)"class", classes$iv), $this$p_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl = false;
        P $this$toTooltipTemplate_u24lambda_u240_u240 = (P)$this$visit_u24lambda_u240$iv$iv;
        boolean bl2 = false;
        String string = $problem.getDescriptionTemplate(true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptionTemplate(...)");
        $this$toTooltipTemplate_u24lambda_u240_u240.unaryPlus(string);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        $this$p_u24default$iv = (FlowContent)$this$html;
        classes$iv = null;
        $i$f$p = false;
        $this$visit$iv$iv = (Tag)new P(ApiKt.attributesMapOf((String)"class", classes$iv), $this$p_u24default$iv.getConsumer());
        $i$f$visit = false;
        $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        bl = false;
        P $this$toTooltipTemplate_u24lambda_u240_u241 = (P)$this$visit_u24lambda_u240$iv$iv;
        boolean bl3 = false;
        Gen_attr_traitsKt.setStyle((CoreAttributeGroupFacade)((CoreAttributeGroupFacade)$this$toTooltipTemplate_u24lambda_u240_u241), (String)"text-align: left; font-size: x-small; color: gray; padding-top: 10px; padding-bottom: 0px;");
        $this$toTooltipTemplate_u24lambda_u240_u241.unaryPlus(" ");
        $this$toTooltipTemplate_u24lambda_u240_u241.unaryPlus(GrazieBundle.message("grazie.tooltip.powered-by-language-tool", new Object[0]));
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ String access$getMessageSanitized(RuleMatch $receiver) {
        return LanguageToolCheckerKt.getMessageSanitized($receiver);
    }

    public static final /* synthetic */ String access$toTooltipTemplate(TextProblem problem) {
        return LanguageToolCheckerKt.toTooltipTemplate(problem);
    }

    public static final /* synthetic */ Set access$getSentenceSeparationRules$p() {
        return sentenceSeparationRules;
    }

    public static final /* synthetic */ boolean access$isGitCherryPickedFrom(RuleMatch match, TextContent text) {
        return LanguageToolCheckerKt.isGitCherryPickedFrom(match, text);
    }

    public static final /* synthetic */ boolean access$isKnownLTBug(RuleMatch match, TextContent text) {
        return LanguageToolCheckerKt.isKnownLTBug(match, text);
    }

    static {
        Interner interner = Interner.createWeakInterner();
        Intrinsics.checkNotNullExpressionValue((Object)interner, (String)"createWeakInterner(...)");
        LanguageToolCheckerKt.interner = interner;
        Object[] objectArray = new String[]{"LC_AFTER_PERIOD", "PUNT_GEEN_HL", "KLEIN_NACH_PUNKT"};
        sentenceSeparationRules = SetsKt.setOf((Object[])objectArray);
        openClosedRangeStart = new Regex("[\\[(].+?(\\.\\.|:|,|;).+[])]");
        openClosedRangeEnd = new Regex(".*" + openClosedRangeStart.getPattern());
        quotedLiteralPattern = new Regex("['\"]\\S+['\"]");
        suggestionQuotePattern = new Regex("(?<![\"'])</?suggestion>(?![\"'])");
        nextWordPattern = new Regex("\\s+(\\w+)");
        objectArray = new Pair[2];
        Object[] objectArray2 = new Regex[]{new Regex("xlsx", RegexOption.IGNORE_CASE), new Regex("mp3", RegexOption.IGNORE_CASE), new Regex("url", RegexOption.IGNORE_CASE)};
        objectArray[0] = TuplesKt.to((Object)"an", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new Regex[]{new Regex("uint.*", RegexOption.IGNORE_CASE), new Regex("SCORM", RegexOption.IGNORE_CASE)};
        objectArray[1] = TuplesKt.to((Object)"a", (Object)CollectionsKt.listOf((Object[])objectArray2));
        an_vs_a_exclusions = MapsKt.mapOf((Pair[])objectArray);
    }
}

