/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.DataUrl;
import com.intellij.util.DataUrlImpl;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"DATA_URL_PREFIX", "", "DATA_URL_BASE64_PARAM", "DATA_URL_DEFAULT_MEDIA_TYPE", "parseDataUrl", "Lcom/intellij/util/DataUrl;", "url", "ASCII_CODE_OF_9", "", "ASCII_CODE_OF_A", "charToHex", "c", "", "decodeUrlEncoded", "", "dataUrl", "decodeBase64", "base64Str", "intellij.platform.util.base"})
@SourceDebugExtension(value={"SMAP\nDataUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataUrl.kt\ncom/intellij/util/DataUrlKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class DataUrlKt {
    @NotNull
    private static final String DATA_URL_PREFIX = "data:";
    @NotNull
    private static final String DATA_URL_BASE64_PARAM = "base64";
    @NotNull
    private static final String DATA_URL_DEFAULT_MEDIA_TYPE = "text/plain;charset=US-ASCII";
    private static final int ASCII_CODE_OF_9 = 57;
    private static final int ASCII_CODE_OF_A = 65;

    @NotNull
    public static final DataUrl parseDataUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        if (!StringsKt.startsWith$default(url, DATA_URL_PREFIX, false, 2, null)) {
            throw new IllegalArgumentException("Not a data url: '" + url + '\'');
        }
        Integer n = StringsKt.indexOf$default((CharSequence)url, ',', 0, false, 6, null);
        int it22 = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it22 >= 0 ? n : null;
        if (n2 == null) {
            throw new IllegalArgumentException("Invalid data url: '" + url + '\'');
        }
        int dataSeparatorIdx = n2;
        String string = url.substring(5, dataSeparatorIdx);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        Object it22 = string;
        String it = it22;
        boolean bl2 = false;
        Object object = !StringsKt.isBlank(it) ? it22 : null;
        if (object == null) {
            object = DATA_URL_DEFAULT_MEDIA_TYPE;
        }
        String mediaType = object;
        it22 = new char[1];
        it22[0] = 59;
        List rawParams = StringsKt.split$default((CharSequence)mediaType, (char[])it22, false, 0, 6, null);
        String contentType = (String)rawParams.get(0);
        boolean isBase64 = Intrinsics.areEqual(CollectionsKt.last(rawParams), DATA_URL_BASE64_PARAM);
        List<String> params = rawParams.subList(1, isBase64 ? rawParams.size() - 1 : rawParams.size());
        String string2 = url.substring(dataSeparatorIdx + 1);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String dataStr = string2;
        byte[] data = isBase64 ? DataUrlKt.decodeBase64(dataStr) : DataUrlKt.decodeUrlEncoded(dataStr);
        return new DataUrlImpl(data, contentType, params);
    }

    public static final int charToHex(char c) {
        int res = Character.toUpperCase(c) - 48;
        if (res > 9) {
            res -= 7;
        }
        if (!(0 <= res ? res < 16 : false)) {
            throw new IllegalArgumentException("Invalid hex char '" + c + '\'');
        }
        return res;
    }

    @NotNull
    public static final byte[] decodeUrlEncoded(@NotNull String dataUrl) {
        Intrinsics.checkNotNullParameter(dataUrl, "dataUrl");
        byte[] tmpRes = new byte[dataUrl.length()];
        int resPos = 0;
        int dataPos = 0;
        while (dataPos < dataUrl.length()) {
            char cc = dataUrl.charAt(dataPos);
            if (cc > '\u007f') {
                throw new IllegalArgumentException("Non-ASCII character in URL-encoded data at " + dataPos + ": '" + dataUrl + '\'');
            }
            if (cc == '%') {
                if (dataUrl.length() - dataPos < 2) {
                    throw new IllegalArgumentException("Incomplete '%xx' sequence at the end if data url '" + dataUrl + '\'');
                }
                tmpRes[resPos++] = (byte)(DataUrlKt.charToHex(dataUrl.charAt(dataPos + 1)) << 4 | DataUrlKt.charToHex(dataUrl.charAt(dataPos + 2)));
                dataPos += 3;
                continue;
            }
            tmpRes[resPos++] = (byte)cc;
            ++dataPos;
        }
        return resPos == tmpRes.length ? tmpRes : ArraysKt.copyOfRange(tmpRes, 0, resPos);
    }

    @NotNull
    public static final byte[] decodeBase64(@NotNull String base64Str) {
        Intrinsics.checkNotNullParameter(base64Str, "base64Str");
        byte[] byArray = Base64.getDecoder().decode(base64Str);
        Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
        return byArray;
    }
}

