/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.ConstructorCallHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.requests.CreateConstructorFromGroovyUsageRequest;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/GrConstructorInvocationHighlighter;", "Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/ConstructorCallHighlighter;", "invocation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrConstructorInvocation;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrConstructorInvocation;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "highlightElement", "Lcom/intellij/psi/PsiElement;", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "buildFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.groovy.psi"})
public final class GrConstructorInvocationHighlighter
extends ConstructorCallHighlighter {
    @NotNull
    private final GrConstructorInvocation invocation;

    public GrConstructorInvocationHighlighter(@NotNull GrConstructorInvocation invocation, @NotNull HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        GroovyConstructorReference groovyConstructorReference = invocation.getConstructorReference();
        Intrinsics.checkNotNullExpressionValue((Object)groovyConstructorReference, (String)"getConstructorReference(...)");
        super(groovyConstructorReference, sink);
        this.invocation = invocation;
    }

    @Override
    @NotNull
    protected PsiElement getHighlightElement() {
        GrArgumentList grArgumentList = this.invocation.getArgumentList();
        Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"getArgumentList(...)");
        return grArgumentList;
    }

    @Override
    @NotNull
    protected List<LocalQuickFix> buildFixes() {
        PsiClass psiClass = this.invocation.getDelegatedClass();
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass targetClass = psiClass;
        if (!targetClass.getManager().isInProject((PsiElement)targetClass)) {
            return CollectionsKt.emptyList();
        }
        CreateConstructorFromGroovyUsageRequest request = new CreateConstructorFromGroovyUsageRequest(this.invocation, (Collection<? extends JvmModifier>)CollectionsKt.emptyList());
        List createConstructorActions = JvmElementActionFactories.createConstructorActions((JvmClass)((JvmClass)targetClass), (CreateConstructorRequest)request);
        List list = IntentionWrapper.wrapToQuickFixes((List)createConstructorActions, (PsiFile)this.invocation.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wrapToQuickFixes(...)");
        return list;
    }
}

