/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ImplicationPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/control/FlipImplicationIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/GrPsiUpdateIntention;", "<init>", "()V", "processIntention", "", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "invertExpression", "", "parenthesizedExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "intellij.groovy"})
public final class FlipImplicationIntention
extends GrPsiUpdateIntention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!(element instanceof GrBinaryExpression)) {
            return;
        }
        String lhsText = this.invertExpression(((GrBinaryExpression)element).getLeftOperand());
        String rhsText = this.invertExpression(((GrBinaryExpression)element).getRightOperand());
        if (lhsText == null || rhsText == null) {
            return;
        }
        String newExpression = rhsText + " ==> " + lhsText;
        PsiImplUtil.replaceExpression(newExpression, (GrExpression)element);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ImplicationPredicate();
    }

    private final String invertExpression(GrExpression parenthesizedExpression) {
        if (parenthesizedExpression == null) {
            return null;
        }
        GrExpression grExpression = ParenthesesUtils.unparenthesize(parenthesizedExpression);
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"unparenthesize(...)");
        GrExpression expression = grExpression;
        if (expression instanceof GrUnaryExpression && Intrinsics.areEqual((Object)((GrUnaryExpression)expression).getOperationTokenType(), (Object)GroovyTokenTypes.mLNOT)) {
            GrExpression grExpression2 = ((GrUnaryExpression)expression).getOperand();
            if (grExpression2 == null) {
                return null;
            }
            GrExpression operand = grExpression2;
            GrExpression grExpression3 = ParenthesesUtils.unparenthesize(operand);
            Intrinsics.checkNotNullExpressionValue((Object)grExpression3, (String)"unparenthesize(...)");
            GrExpression unparenthesized = grExpression3;
            return ParenthesesUtils.checkPrecedence(ParenthesesUtils.IMPL_PRECEDENCE, ParenthesesUtils.getPrecedence(unparenthesized)) ? unparenthesized.getText() : operand.getText();
        }
        String expressionText = expression.getText();
        return ParenthesesUtils.checkPrecedence(ParenthesesUtils.getPrecedence(expression), ParenthesesUtils.TYPE_CAST_PRECEDENCE) ? "!(" + expressionText + ")" : "!" + expressionText;
    }
}

