/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0010\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\fJ\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/conversions/ClassNameDiffersFromFileNamePredicate;", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "searchForClassInMultiClassFile", "", "classConsumer", "Lcom/intellij/util/Consumer;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "fileNameConsumer", "", "<init>", "(ZLcom/intellij/util/Consumer;Lcom/intellij/util/Consumer;)V", "consumer", "(Lcom/intellij/util/Consumer;)V", "satisfiedBy", "element", "Lcom/intellij/psi/PsiElement;", "intellij.groovy"})
public final class ClassNameDiffersFromFileNamePredicate
implements PsiElementPredicate {
    private final boolean searchForClassInMultiClassFile;
    @Nullable
    private final Consumer<GrTypeDefinition> classConsumer;
    @Nullable
    private final Consumer<String> fileNameConsumer;

    @JvmOverloads
    public ClassNameDiffersFromFileNamePredicate(boolean searchForClassInMultiClassFile, @Nullable Consumer<GrTypeDefinition> classConsumer, @Nullable Consumer<String> fileNameConsumer) {
        this.searchForClassInMultiClassFile = searchForClassInMultiClassFile;
        this.classConsumer = classConsumer;
        this.fileNameConsumer = fileNameConsumer;
    }

    public /* synthetic */ ClassNameDiffersFromFileNamePredicate(boolean bl, Consumer consumer, Consumer consumer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            consumer = null;
        }
        if ((n & 4) != 0) {
            consumer2 = null;
        }
        this(bl, (Consumer<GrTypeDefinition>)consumer, (Consumer<String>)consumer2);
    }

    public ClassNameDiffersFromFileNamePredicate(@Nullable Consumer<GrTypeDefinition> consumer) {
        this(false, consumer, null, 5, null);
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        block10: {
            boolean result2;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element.getParent();
            GrTypeDefinition grTypeDefinition = psiElement instanceof GrTypeDefinition ? (GrTypeDefinition)psiElement : null;
            if (grTypeDefinition == null) {
                return false;
            }
            GrTypeDefinition clazz = grTypeDefinition;
            if (clazz.getNameIdentifierGroovy() != element) {
                return false;
            }
            String string = clazz.getName();
            if (string == null) {
                return false;
            }
            String className = string;
            if (((CharSequence)className).length() == 0) {
                return false;
            }
            PsiElement psiElement2 = clazz.getParent();
            GroovyFile groovyFile = psiElement2 instanceof GroovyFile ? (GroovyFile)psiElement2 : null;
            if (groovyFile == null) {
                return false;
            }
            GroovyFile file = groovyFile;
            if (!file.isPhysical()) {
                return false;
            }
            String string2 = FileUtil.getNameWithoutExtension((String)file.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
            String fileName = string2;
            if (((CharSequence)fileName).length() == 0) {
                return false;
            }
            if (Intrinsics.areEqual((Object)className, (Object)fileName)) {
                return false;
            }
            boolean bl = this.searchForClassInMultiClassFile ? file.getClasses().length > 1 : (result2 = !file.isScript());
            if (!result2) {
                return false;
            }
            Consumer<GrTypeDefinition> consumer = this.classConsumer;
            if (consumer != null) {
                consumer.consume((Object)clazz);
            }
            Consumer<String> consumer2 = this.fileNameConsumer;
            if (consumer2 == null) break block10;
            consumer2.consume((Object)fileName);
        }
        return true;
    }

    @JvmOverloads
    public ClassNameDiffersFromFileNamePredicate(boolean searchForClassInMultiClassFile, @Nullable Consumer<GrTypeDefinition> classConsumer) {
        this(searchForClassInMultiClassFile, classConsumer, null, 4, null);
    }

    @JvmOverloads
    public ClassNameDiffersFromFileNamePredicate(boolean searchForClassInMultiClassFile) {
        this(searchForClassInMultiClassFile, null, null, 6, null);
    }

    @JvmOverloads
    public ClassNameDiffersFromFileNamePredicate() {
        this(false, null, null, 7, null);
    }
}

