/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceOptionsKt;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n*\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u0004\u0018\u00010\u000b*\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceContext;", "", "ignored", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "<init>", "(Ljava/util/List;)V", "getIgnored", "()Ljava/util/List;", "getTypeArguments", "", "Lcom/intellij/psi/PsiType;", "Lcom/intellij/psi/PsiClassType;", "(Lcom/intellij/psi/PsiClassType;)[Lcom/intellij/psi/PsiType;", "filterType", "type", "context", "Lcom/intellij/psi/PsiElement;", "staticType", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "ignoreMethod", "method", "allowedToProcessReturnType", "", "getAllowedToProcessReturnType", "()Z", "allowedToResolveOperators", "getAllowedToResolveOperators", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nSignatureInferenceOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureInferenceOptions.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceContext\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,110:1\n12033#2,10:111\n14060#2:121\n14061#2:123\n12043#2:124\n1#3:122\n37#4,2:125\n*S KotlinDebug\n*F\n+ 1 SignatureInferenceOptions.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceContext\n*L\n57#1:111,10\n57#1:121\n57#1:123\n57#1:124\n57#1:122\n68#1:125,2\n*E\n"})
public class SignatureInferenceContext {
    @NotNull
    private final List<GrMethod> ignored;
    private final boolean allowedToProcessReturnType;
    private final boolean allowedToResolveOperators;

    public SignatureInferenceContext(@NotNull List<? extends GrMethod> ignored) {
        Intrinsics.checkNotNullParameter(ignored, (String)"ignored");
        this.ignored = ignored;
        this.allowedToProcessReturnType = true;
        this.allowedToResolveOperators = true;
    }

    @NotNull
    public final List<GrMethod> getIgnored() {
        return this.ignored;
    }

    @NotNull
    public PsiType[] getTypeArguments(@NotNull PsiClassType $this$getTypeArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$getTypeArguments, (String)"<this>");
        PsiType[] psiTypeArray = $this$getTypeArguments.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
        return psiTypeArray;
    }

    @NotNull
    public PsiType filterType(@NotNull PsiType type, @NotNull PsiElement context) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (type instanceof PsiPrimitiveType) {
            PsiClassType psiClassType = ((PsiPrimitiveType)type).getBoxedType(context);
            psiType = psiClassType != null ? (PsiType)psiClassType : type;
        } else {
            psiType = type;
        }
        return psiType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PsiType staticType(@NotNull GrExpression $this$staticType) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)$this$staticType, (String)"<this>");
        if ($this$staticType instanceof GrMethodCall) {
            void $this$mapNotNullTo$iv$iv;
            GroovyResolveResult[] resolveResults;
            GroovyResolveResult[] groovyResolveResultArray = ((GrMethodCall)$this$staticType).multiResolveGroovy(false);
            Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResultArray, (String)"multiResolveGroovy(...)");
            GroovyResolveResult[] $this$mapNotNull$iv = resolveResults = groovyResolveResultArray;
            boolean $i$f$mapNotNull = false;
            GroovyResolveResult[] groovyResolveResultArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                PsiType it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (SignatureInferenceOptionsKt.access$getStaticReturnType(it instanceof GroovyMethodResult ? (GroovyMethodResult)it : null, $this$staticType) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List types = (List)destination$iv$iv;
            if (types.isEmpty()) {
                return ((GrMethodCall)$this$staticType).getType();
            }
            psiType = TypesUtil.getLeastUpperBoundNullable(types, ((GrMethodCall)$this$staticType).getManager());
        } else {
            psiType = $this$staticType.getType();
        }
        return psiType;
    }

    @NotNull
    public SignatureInferenceContext ignoreMethod(@NotNull GrMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)method);
        Collection $this$toTypedArray$iv = this.ignored;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new GrMethod[0]));
        return new SignatureInferenceContext(CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new GrMethod[spreadBuilder.size()])));
    }

    public boolean getAllowedToProcessReturnType() {
        return this.allowedToProcessReturnType;
    }

    public boolean getAllowedToResolveOperators() {
        return this.allowedToResolveOperators;
    }
}

