/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH&J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH&R\u0014\u0010\n\u001a\u00020\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "", "<init>", "(Ljava/lang/String;I)V", "SINGLE_QUOTED", "TRIPLE_SINGLE_QUOTED", "DOUBLE_QUOTED", "TRIPLE_DOUBLE_QUOTED", "SLASHY", "DOLLAR_SLASHY", "lineBreaker", "", "getLineBreaker", "()Ljava/lang/String;", "escape", "unescaped", "unescape", "escaped", "TestsOnly", "intellij.groovy.psi"})
public abstract class StringKind
extends Enum<StringKind> {
    public static final /* enum */ StringKind SINGLE_QUOTED = new SINGLE_QUOTED("SINGLE_QUOTED", 0);
    public static final /* enum */ StringKind TRIPLE_SINGLE_QUOTED = new TRIPLE_SINGLE_QUOTED("TRIPLE_SINGLE_QUOTED", 1);
    public static final /* enum */ StringKind DOUBLE_QUOTED = new DOUBLE_QUOTED("DOUBLE_QUOTED", 2);
    public static final /* enum */ StringKind TRIPLE_DOUBLE_QUOTED = new TRIPLE_DOUBLE_QUOTED("TRIPLE_DOUBLE_QUOTED", 3);
    public static final /* enum */ StringKind SLASHY = new SLASHY("SLASHY", 4);
    public static final /* enum */ StringKind DOLLAR_SLASHY = new DOLLAR_SLASHY("DOLLAR_SLASHY", 5);
    private static final /* synthetic */ StringKind[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private StringKind() {
    }

    @NonNls
    @NotNull
    public String getLineBreaker() {
        return "\n";
    }

    @NotNull
    public abstract String escape(@NotNull String var1);

    @NotNull
    public abstract String unescape(@NotNull String var1);

    public static StringKind[] values() {
        return (StringKind[])$VALUES.clone();
    }

    public static StringKind valueOf(String value) {
        return Enum.valueOf(StringKind.class, value);
    }

    @NotNull
    public static EnumEntries<StringKind> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ StringKind(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        $VALUES = stringKindArray = new StringKind[]{StringKind.SINGLE_QUOTED, StringKind.TRIPLE_SINGLE_QUOTED, StringKind.DOUBLE_QUOTED, StringKind.TRIPLE_DOUBLE_QUOTED, StringKind.SLASHY, StringKind.DOLLAR_SLASHY};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"org/jetbrains/plugins/groovy/lang/psi/util/StringKind.DOLLAR_SLASHY", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "escape", "", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class DOLLAR_SLASHY
    extends StringKind {
        /*
         * WARNING - void declaration
         */
        DOLLAR_SLASHY() {
            void var1_1;
        }

        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            Intrinsics.checkNotNullParameter((Object)unescaped, (String)"unescaped");
            String string = GrStringUtil.escapeSymbolsForDollarSlashyStrings(unescaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeSymbolsForDollarSlashyStrings(...)");
            return string;
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            Intrinsics.checkNotNullParameter((Object)escaped, (String)"escaped");
            String string = GrStringUtil.unescapeDollarSlashyString(escaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeDollarSlashyString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"org/jetbrains/plugins/groovy/lang/psi/util/StringKind.DOUBLE_QUOTED", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "lineBreaker", "", "getLineBreaker", "()Ljava/lang/String;", "escape", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class DOUBLE_QUOTED
    extends StringKind {
        /*
         * WARNING - void declaration
         */
        DOUBLE_QUOTED() {
            void var1_1;
        }

        @Override
        @NotNull
        public String getLineBreaker() {
            return "\\n\" +\n\"";
        }

        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            Intrinsics.checkNotNullParameter((Object)unescaped, (String)"unescaped");
            String string = GrStringUtil.escapeSymbolsForGString(unescaped, true, false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeSymbolsForGString(...)");
            return string;
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            Intrinsics.checkNotNullParameter((Object)escaped, (String)"escaped");
            String string = GrStringUtil.unescapeString(escaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"org/jetbrains/plugins/groovy/lang/psi/util/StringKind.SINGLE_QUOTED", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "lineBreaker", "", "getLineBreaker", "()Ljava/lang/String;", "escape", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class SINGLE_QUOTED
    extends StringKind {
        /*
         * WARNING - void declaration
         */
        SINGLE_QUOTED() {
            void var1_1;
        }

        @Override
        @NotNull
        public String getLineBreaker() {
            return "\\n' +\n'";
        }

        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            Intrinsics.checkNotNullParameter((Object)unescaped, (String)"unescaped");
            String string = GrStringUtil.escapeSymbolsForString(unescaped, true, false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeSymbolsForString(...)");
            return string;
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            Intrinsics.checkNotNullParameter((Object)escaped, (String)"escaped");
            String string = GrStringUtil.unescapeString(escaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"org/jetbrains/plugins/groovy/lang/psi/util/StringKind.SLASHY", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "escape", "", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class SLASHY
    extends StringKind {
        /*
         * WARNING - void declaration
         */
        SLASHY() {
            void var1_1;
        }

        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            Intrinsics.checkNotNullParameter((Object)unescaped, (String)"unescaped");
            String string = GrStringUtil.escapeSymbolsForSlashyStrings(unescaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeSymbolsForSlashyStrings(...)");
            return string;
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            Intrinsics.checkNotNullParameter((Object)escaped, (String)"escaped");
            String string = GrStringUtil.unescapeSlashyString(escaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeSlashyString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"org/jetbrains/plugins/groovy/lang/psi/util/StringKind.TRIPLE_DOUBLE_QUOTED", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "escape", "", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class TRIPLE_DOUBLE_QUOTED
    extends StringKind {
        /*
         * WARNING - void declaration
         */
        TRIPLE_DOUBLE_QUOTED() {
            void var1_1;
        }

        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            Intrinsics.checkNotNullParameter((Object)unescaped, (String)"unescaped");
            String string = GrStringUtil.escapeSymbolsForGString(unescaped, false, false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeSymbolsForGString(...)");
            return string;
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            Intrinsics.checkNotNullParameter((Object)escaped, (String)"escaped");
            String string = GrStringUtil.unescapeString(escaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"org/jetbrains/plugins/groovy/lang/psi/util/StringKind.TRIPLE_SINGLE_QUOTED", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "escape", "", "unescaped", "unescape", "escaped", "intellij.groovy.psi"})
    static final class TRIPLE_SINGLE_QUOTED
    extends StringKind {
        /*
         * WARNING - void declaration
         */
        TRIPLE_SINGLE_QUOTED() {
            void var1_1;
        }

        @Override
        @NotNull
        public String escape(@NotNull String unescaped) {
            Intrinsics.checkNotNullParameter((Object)unescaped, (String)"unescaped");
            String string = GrStringUtil.escapeSymbolsForString(unescaped, false, false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeSymbolsForString(...)");
            return string;
        }

        @Override
        @NotNull
        public String unescape(@NotNull String escaped) {
            Intrinsics.checkNotNullParameter((Object)escaped, (String)"escaped");
            String string = GrStringUtil.unescapeString(escaped);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind$TestsOnly;", "", "<init>", "()V", "SINGLE_QUOTED", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "TRIPLE_SINGLE_QUOTED", "DOUBLE_QUOTED", "TRIPLE_DOUBLE_QUOTED", "SLASHY", "DOLLAR_SLASHY", "intellij.groovy.psi"})
    @ApiStatus.Internal
    @TestOnly
    public static final class TestsOnly {
        @NotNull
        public static final TestsOnly INSTANCE = new TestsOnly();
        @JvmField
        @NotNull
        public static final StringKind SINGLE_QUOTED = SINGLE_QUOTED;
        @JvmField
        @NotNull
        public static final StringKind TRIPLE_SINGLE_QUOTED = TRIPLE_SINGLE_QUOTED;
        @JvmField
        @NotNull
        public static final StringKind DOUBLE_QUOTED = DOUBLE_QUOTED;
        @JvmField
        @NotNull
        public static final StringKind TRIPLE_DOUBLE_QUOTED = TRIPLE_DOUBLE_QUOTED;
        @JvmField
        @NotNull
        public static final StringKind SLASHY = SLASHY;
        @JvmField
        @NotNull
        public static final StringKind DOLLAR_SLASHY = DOLLAR_SLASHY;

        private TestsOnly() {
        }
    }
}

