/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyPropertyWriteReference;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ConstructorsKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilderKt;
import org.jetbrains.plugins.groovy.lang.typing.TypeUtils;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018j\u0004\u0018\u0001`\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\"\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"getExpectedType", "Lcom/intellij/psi/PsiType;", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;", "cs", "", "getExpectedTypeFromAssignmentOrReturn", "getExpectedTypeFromNamedArgument", "getExpectedTypeFromCoercion", "resolvesToDGM", "safeCast", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrSafeCastExpression;", "safeCastFallsBackToCast", "classResult", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "ignoredFqnsInSafeCast", "", "", "fallsBackToConstructorCS", "clazz", "Lcom/intellij/psi/PsiClass;", "fallsBackToConstructor", "ignoredFqnsInTransformation", "getArguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGrLiteralConstructorReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrLiteralConstructorReference.kt\norg/jetbrains/plugins/groovy/lang/resolve/references/GrLiteralConstructorReferenceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1786#2,3:239\n1786#2,3:242\n*S KotlinDebug\n*F\n+ 1 GrLiteralConstructorReference.kt\norg/jetbrains/plugins/groovy/lang/resolve/references/GrLiteralConstructorReferenceKt\n*L\n148#1:239,3\n156#1:242,3\n*E\n"})
public final class GrLiteralConstructorReferenceKt {
    @NotNull
    private static final Set<String> ignoredFqnsInSafeCast;
    @NotNull
    private static final Set<String> ignoredFqnsInTransformation;

    private static final PsiType getExpectedType(GrListOrMap literal, boolean cs) {
        PsiType psiType = GrLiteralConstructorReferenceKt.getExpectedTypeFromAssignmentOrReturn(literal, cs);
        if (psiType == null && (psiType = GrLiteralConstructorReferenceKt.getExpectedTypeFromNamedArgument(literal)) == null) {
            psiType = GrLiteralConstructorReferenceKt.getExpectedTypeFromCoercion(literal);
        }
        return psiType;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final PsiType getExpectedTypeFromAssignmentOrReturn(GrListOrMap literal, boolean cs) {
        PsiType psiType;
        if (cs) {
            PsiType type = GroovyInferenceSessionBuilderKt.getAssignmentExpectedType(literal);
            if (literal.isMap() || !literal.isEmpty()) {
                PsiType psiType2 = type;
                if (psiType2 == null) return null;
                psiType = TypeUtils.box(psiType2, literal);
                return psiType;
            } else {
                void var2_2;
                if (type instanceof PsiClassType) {
                    boolean bl;
                    PsiClass psiClass = ((PsiClassType)type).resolve();
                    if (psiClass != null) {
                        if (psiClass.isInterface()) {
                            return null;
                        }
                        bl = false;
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        return null;
                    }
                }
                psiType = var2_2;
            }
            return psiType;
        } else {
            psiType = GroovyInferenceSessionBuilderKt.getAssignmentOrReturnExpectedType(literal);
        }
        return psiType;
    }

    private static final PsiType getExpectedTypeFromNamedArgument(GrListOrMap literal) {
        PsiElement psiElement = literal.getParent();
        GrNamedArgument grNamedArgument = psiElement instanceof GrNamedArgument ? (GrNamedArgument)psiElement : null;
        if (grNamedArgument == null) {
            return null;
        }
        GrNamedArgument namedArgument = grNamedArgument;
        GrArgumentLabel grArgumentLabel = namedArgument.getLabel();
        if (grArgumentLabel == null) {
            return null;
        }
        GrArgumentLabel label = grArgumentLabel;
        GroovyPropertyWriteReference groovyPropertyWriteReference = label.getConstructorPropertyReference();
        if (groovyPropertyWriteReference == null) {
            return null;
        }
        GroovyPropertyWriteReference propertyReference = groovyPropertyWriteReference;
        GroovyResolveResult groovyResolveResult = propertyReference.advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"advancedResolve(...)");
        return TypeUtils.getWritePropertyType(groovyResolveResult);
    }

    private static final PsiType getExpectedTypeFromCoercion(GrListOrMap literal) {
        PsiElement psiElement = literal.getParent();
        GrSafeCastExpression grSafeCastExpression = psiElement instanceof GrSafeCastExpression ? (GrSafeCastExpression)psiElement : null;
        if (grSafeCastExpression == null) {
            return null;
        }
        GrSafeCastExpression safeCast = grSafeCastExpression;
        if (!GrLiteralConstructorReferenceKt.resolvesToDGM(safeCast)) {
            return null;
        }
        GrTypeElement grTypeElement = safeCast.getCastTypeElement();
        GrClassTypeElement grClassTypeElement = grTypeElement instanceof GrClassTypeElement ? (GrClassTypeElement)grTypeElement : null;
        if (grClassTypeElement == null) {
            return null;
        }
        GrClassTypeElement typeElement = grClassTypeElement;
        Collection collection = typeElement.getReferenceElement().resolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolve(...)");
        GroovyResolveResult groovyResolveResult = (GroovyResolveResult)CollectionsKt.singleOrNull((Iterable)collection);
        if (groovyResolveResult == null) {
            return null;
        }
        GroovyResolveResult typeResult = groovyResolveResult;
        if (GrLiteralConstructorReferenceKt.safeCastFallsBackToCast(literal, typeResult)) {
            return typeElement.getType();
        }
        return null;
    }

    private static final boolean resolvesToDGM(GrSafeCastExpression safeCast) {
        PsiClass containingClass;
        PsiElement psiElement = safeCast.getReference().resolve();
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return false;
        }
        PsiMethod method = psiMethod;
        GrGdkMethod grGdkMethod = method instanceof GrGdkMethod ? (GrGdkMethod)method : null;
        PsiClass psiClass = containingClass = grGdkMethod != null && (grGdkMethod = grGdkMethod.getStaticMethod()) != null ? grGdkMethod.getContainingClass() : null;
        return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"org.codehaus.groovy.runtime.DefaultGroovyMethods");
    }

    private static final boolean safeCastFallsBackToCast(GrListOrMap literal, GroovyResolveResult classResult) {
        PsiElement psiElement = classResult.getElement();
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            return false;
        }
        PsiClass clazz = psiClass;
        if (literal.isMap()) {
            return !clazz.isInterface();
        }
        if (CollectionsKt.contains((Iterable)ignoredFqnsInSafeCast, (Object)clazz.getQualifiedName())) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"EMPTY");
        Collection<GroovyResolveResult> constructors = ConstructorsKt.resolveConstructor(clazz, psiSubstitutor, CollectionsKt.listOf((Object)new ExpressionArgument(literal)), literal);
        if (!constructors.isEmpty()) {
            boolean bl;
            block14: {
                Iterable $this$all$iv = constructors;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        GroovyResolveResult it = (GroovyResolveResult)element$iv;
                        boolean bl2 = false;
                        if (it.isApplicable()) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return false;
            }
        }
        if (InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.util.Collection")) {
            PsiSubstitutor psiSubstitutor2 = PsiSubstitutor.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor2, (String)"EMPTY");
            Collection<GroovyResolveResult> noArgConstructors = ConstructorsKt.resolveConstructor(clazz, psiSubstitutor2, CollectionsKt.emptyList(), literal);
            if (!noArgConstructors.isEmpty()) {
                boolean bl;
                block15: {
                    Iterable $this$all$iv = noArgConstructors;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            GroovyResolveResult it = (GroovyResolveResult)element$iv;
                            boolean bl3 = false;
                            if (it.isApplicable()) continue;
                            bl = false;
                            break block15;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return false;
                }
            }
        }
        return true;
    }

    private static final boolean fallsBackToConstructorCS(PsiClass clazz, GrListOrMap literal) {
        if (CollectionsKt.contains((Iterable)ignoredFqnsInTransformation, (Object)clazz.getQualifiedName()) && !Intrinsics.areEqual((Object)clazz.getQualifiedName(), (Object)"java.lang.Character")) {
            return false;
        }
        PsiType psiType = literal.getType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        PsiClass literalClass = psiClassType != null ? psiClassType.resolve() : null;
        return !InheritanceUtil.isInheritorOrSelf((PsiClass)literalClass, (PsiClass)clazz, (boolean)true);
    }

    private static final boolean fallsBackToConstructor(PsiClass clazz, GrListOrMap literal) {
        PsiClass literalClass;
        if (clazz.isEnum()) {
            return false;
        }
        String string = clazz.getQualifiedName();
        if (string == null) {
            return false;
        }
        String qualifiedName = string;
        if (ignoredFqnsInTransformation.contains(qualifiedName)) {
            return false;
        }
        if (InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.lang.Number")) {
            return false;
        }
        PsiType psiType = literal.getType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        Object object = literalClass = psiClassType != null ? psiClassType.resolve() : null;
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)literalClass, (PsiClass)clazz, (boolean)true)) {
            return false;
        }
        if (!literal.isMap()) {
            PsiClass lhs;
            if (Intrinsics.areEqual((Object)qualifiedName, (Object)"java.util.LinkedHashSet")) {
                return false;
            }
            if (clazz.hasModifier(JvmModifier.ABSTRACT) && InheritanceUtil.isInheritor((PsiClass)(lhs = JavaPsiFacade.getInstance((Project)literal.getProject()).findClass("java.util.LinkedHashSet", literal.getResolveScope())), (String)qualifiedName)) {
                return false;
            }
        }
        return true;
    }

    private static final List<Argument> getArguments(GrListOrMap literal) {
        if (literal.isMap()) {
            return CollectionsKt.listOf((Object)new ExpressionArgument(literal));
        }
        GrExpression[] grExpressionArray = literal.getInitializers();
        Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"getInitializers(...)");
        return ArgumentsKt.getExpressionArguments(grExpressionArray);
    }

    public static final /* synthetic */ PsiType access$getExpectedType(GrListOrMap literal, boolean cs) {
        return GrLiteralConstructorReferenceKt.getExpectedType(literal, cs);
    }

    public static final /* synthetic */ boolean access$fallsBackToConstructorCS(PsiClass clazz, GrListOrMap literal) {
        return GrLiteralConstructorReferenceKt.fallsBackToConstructorCS(clazz, literal);
    }

    public static final /* synthetic */ boolean access$fallsBackToConstructor(PsiClass clazz, GrListOrMap literal) {
        return GrLiteralConstructorReferenceKt.fallsBackToConstructor(clazz, literal);
    }

    public static final /* synthetic */ List access$getArguments(GrListOrMap literal) {
        return GrLiteralConstructorReferenceKt.getArguments(literal);
    }

    static {
        Object[] objectArray = new String[]{"java.util.List", "java.util.Set", "java.util.SortedSet", "java.util.Queue", "java.util.Stack", "java.util.LinkedList", "java.lang.String"};
        ignoredFqnsInSafeCast = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"java.lang.Object", "java.lang.Class", "java.lang.String", "java.lang.Boolean", "java.lang.Character"};
        ignoredFqnsInTransformation = SetsKt.setOf((Object[])objectArray);
    }
}

