/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrRegex;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GStringConcatenationUtil {
    private static final String END_BRACE = "}";
    private static final String START_BRACE = "${";

    @ApiStatus.Internal
    public static void convertToGString(GrBinaryExpression expr, StringBuilder builder, boolean multiline) {
        GrExpression left = (GrExpression)PsiUtil.skipParentheses(expr.getLeftOperand(), false);
        GrExpression right = (GrExpression)PsiUtil.skipParentheses(expr.getRightOperand(), false);
        GStringConcatenationUtil.appendOperandText(left, builder, multiline);
        GStringConcatenationUtil.appendOperandText(right, builder, multiline);
    }

    @ApiStatus.Internal
    public static void appendOperandText(@Nullable GrExpression operand, StringBuilder builder, boolean multiline) {
        if (operand instanceof GrRegex) {
            for (GroovyPsiElement element : ((GrRegex)operand).getAllContentParts()) {
                if (element instanceof GrStringInjection) {
                    builder.append(element.getText());
                    continue;
                }
                if (!(element instanceof GrStringContent)) continue;
                if (GrStringUtil.isDollarSlashyString((GrLiteral)operand)) {
                    GStringConcatenationUtil.processDollarSlashyContent(builder, multiline, element.getText());
                    continue;
                }
                GStringConcatenationUtil.processSlashyContent(builder, multiline, element.getText());
            }
        } else if (operand instanceof GrString) {
            boolean isMultiline = GrStringUtil.isMultilineStringLiteral((GrLiteral)operand);
            for (GroovyPsiElement element : ((GrString)operand).getAllContentParts()) {
                if (element instanceof GrStringInjection) {
                    builder.append(element.getText());
                    continue;
                }
                if (!(element instanceof GrStringContent)) continue;
                if (isMultiline) {
                    GStringConcatenationUtil.processMultilineGString(builder, element.getText());
                    continue;
                }
                GStringConcatenationUtil.processSinglelineGString(builder, element.getText());
            }
        } else if (operand instanceof GrLiteral) {
            GrLiteral literal = (GrLiteral)operand;
            String text = GrStringUtil.removeQuotes(operand.getText());
            if (GrStringUtil.isSingleQuoteString(literal)) {
                GStringConcatenationUtil.processSinglelineString(builder, text);
            } else if (GrStringUtil.isTripleQuoteString(literal)) {
                GStringConcatenationUtil.processMultilineString(builder, text);
            } else if (GrStringUtil.isDoubleQuoteString(literal)) {
                GStringConcatenationUtil.processSinglelineGString(builder, text);
            } else if (GrStringUtil.isTripleDoubleQuoteString(literal)) {
                GStringConcatenationUtil.processMultilineGString(builder, text);
            } else if (GrStringUtil.isSlashyString(literal)) {
                GStringConcatenationUtil.processSlashyContent(builder, multiline, text);
            } else if (GrStringUtil.isDollarSlashyString(literal)) {
                GStringConcatenationUtil.processDollarSlashyContent(builder, multiline, text);
            }
        } else if (ConvertibleToGStringPredicate.satisfied(operand)) {
            GStringConcatenationUtil.convertToGString((GrBinaryExpression)operand, builder, multiline);
        } else if (!GStringConcatenationUtil.isToStringMethod(operand, builder)) {
            builder.append(START_BRACE).append(operand == null ? "" : operand.getText()).append(END_BRACE);
        }
    }

    private static void processMultilineString(StringBuilder builder, String text) {
        int position = builder.length();
        GrStringUtil.escapeAndUnescapeSymbols(text, "$", "'\"", builder);
        GrStringUtil.fixAllTripleDoubleQuotes(builder, position);
    }

    private static void processSinglelineString(StringBuilder builder, String text) {
        GrStringUtil.escapeAndUnescapeSymbols(text, "$\"", "'", builder);
    }

    private static StringBuilder processSinglelineGString(StringBuilder builder, String text) {
        return builder.append(text);
    }

    private static void processMultilineGString(StringBuilder builder, String text) {
        StringBuilder raw = new StringBuilder(text);
        GrStringUtil.unescapeCharacters(raw, "\"", true);
        builder.append((CharSequence)raw);
    }

    private static void processDollarSlashyContent(StringBuilder builder, boolean multiline, String text) {
        GrStringUtil.escapeSymbolsForGString(text, !multiline, false, builder);
    }

    private static void processSlashyContent(StringBuilder builder, boolean multiline, String text) {
        String unescaped = GrStringUtil.unescapeSlashyString(text);
        GrStringUtil.escapeSymbolsForGString(unescaped, !multiline, false, builder);
    }

    private static boolean isToStringMethod(GrExpression operand, StringBuilder builder) {
        if (!(operand instanceof GrMethodCallExpression)) {
            return false;
        }
        GrExpression expression = ((GrMethodCallExpression)operand).getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)expression;
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        GroovyResolveResult[] results = refExpr.multiResolve(false);
        if (results.length != 1) {
            return false;
        }
        PsiElement element = results[0].getElement();
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiClass objectClass = JavaPsiFacade.getInstance((Project)operand.getProject()).findClass("java.lang.Object", operand.getResolveScope());
        if (objectClass == null) {
            return false;
        }
        PsiMethod[] toStringMethod = objectClass.findMethodsByName("toString", true);
        if (MethodSignatureUtil.isSubsignature((MethodSignature)toStringMethod[0].getHierarchicalMethodSignature(), (MethodSignature)method.getHierarchicalMethodSignature())) {
            builder.append(START_BRACE).append(qualifier.getText()).append(END_BRACE);
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static class ConvertibleToGStringPredicate
    implements PsiElementPredicate {
        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ConvertibleToGStringPredicate.$$$reportNull$$$0(0);
            }
            return ConvertibleToGStringPredicate.satisfied(element);
        }

        public static boolean satisfied(PsiElement element) {
            if (ConvertibleToGStringPredicate.isApplicableLiteral(element)) {
                return true;
            }
            if (!(element instanceof GrBinaryExpression)) {
                return false;
            }
            GrBinaryExpression binaryExpression = (GrBinaryExpression)element;
            if (!GroovyTokenTypes.mPLUS.equals(binaryExpression.getOperationTokenType())) {
                return false;
            }
            if (ErrorUtil.containsError(element)) {
                return false;
            }
            PsiType type = binaryExpression.getType();
            if (type == null) {
                return false;
            }
            PsiClassType stringType = TypesUtil.createType("java.lang.String", element);
            PsiClassType gstringType = TypesUtil.createType("groovy.lang.GString", element);
            return TypeConversionUtil.isAssignable((PsiType)stringType, (PsiType)type) || TypeConversionUtil.isAssignable((PsiType)gstringType, (PsiType)type);
        }

        private static boolean isApplicableLiteral(PsiElement element) {
            if (!(element instanceof GrLiteral)) {
                return false;
            }
            GrLiteral literal = (GrLiteral)element;
            if (!(literal.getValue() instanceof String)) {
                return false;
            }
            IElementType literalType = GrLiteralImpl.getLiteralType(literal);
            return literalType != GroovyElementTypes.STRING_DQ && literalType != GroovyElementTypes.STRING_TDQ;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/util/GStringConcatenationUtil$ConvertibleToGStringPredicate", "satisfiedBy"));
        }
    }
}

