/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.langs.alphabet;

import ai.grazie.nlp.langs.alphabet.NoneAlphabet;
import ai.grazie.nlp.langs.alphabet.RegexAlphabet;
import ai.grazie.nlp.langs.alphabet.SetBasedAlphabet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00132\u00020\u0001:\u0003\u0012\u0013\u0014B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lai/grazie/nlp/langs/alphabet/Alphabet;", "", "group", "Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "<init>", "(Lai/grazie/nlp/langs/alphabet/Alphabet$Group;)V", "getGroup", "()Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "matchChar", "", "ch", "", "matchEntire", "input", "", "matchAny", "matchAnySpecial", "matchAnyUnique", "Group", "Companion", "PredicateAlphabet", "Lai/grazie/nlp/langs/alphabet/Alphabet$PredicateAlphabet;", "Lai/grazie/nlp/langs/alphabet/NoneAlphabet;", "Lai/grazie/nlp/langs/alphabet/RegexAlphabet;", "Lai/grazie/nlp/langs/alphabet/SetBasedAlphabet;", "nlp-langs"})
@SourceDebugExtension(value={"SMAP\nAlphabet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Alphabet.kt\nai/grazie/nlp/langs/alphabet/Alphabet\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,133:1\n1069#2,2:134\n1088#2,2:136\n*S KotlinDebug\n*F\n+ 1 Alphabet.kt\nai/grazie/nlp/langs/alphabet/Alphabet\n*L\n18#1:134,2\n19#1:136,2\n*E\n"})
public abstract sealed class Alphabet
permits PredicateAlphabet, NoneAlphabet, RegexAlphabet, SetBasedAlphabet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Group group;
    @NotNull
    private static final Alphabet ENGLISH = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz", "", "");
    @NotNull
    private static final Alphabet FRENCH = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e2\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff", "\u00e0\u00e2\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff", "\u0152");
    @NotNull
    private static final Alphabet GERMAN = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df", "\u00e4\u00f6\u00fc\u00df", "\u00df");
    @NotNull
    private static final Alphabet DUTCH = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00eb\u00ef\u0133", "\u00e0\u00e9\u00eb\u00ef\u0133", "\u0133");
    @NotNull
    private static final Alphabet ITALIAN = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00e8\u00ec\u00f2\u00f9", "\u00e0\u00e9\u00e8\u00ec\u00f2\u00f9", "\u00ec");
    @NotNull
    private static final Alphabet POLISH = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u0105\u0142\u0144\u00f3\u017c\u0107\u0119\u015b\u017a", "\u0105\u0142\u0144\u00f3\u017c\u0107\u0119\u015b\u017a", "\u0105\u0142\u0144\u017c\u0107\u0119\u015b\u017a");
    @NotNull
    private static final Alphabet PORTUGUESE = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e3\u00f5\u00e7\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00f4\u00e0", "\u00e3\u00f5\u00e7\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00f4\u00e0", "\u00e3\u00f5");
    @NotNull
    private static final Alphabet ROMANIAN = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u0103\u00ee\u00e2\u015f\u0163", "\u0103\u00ee\u00e2\u015f\u0163", "\u0103\u015f\u0163");
    @NotNull
    private static final Alphabet SLOVAK = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u017e\u0161\u010d\u00e1\u00e4\u010f\u00e9\u00ed\u013e\u013a\u0148\u00f3\u00f4\u0155\u0165\u00fa\u00fd", "\u017e\u0161\u010d\u00e1\u00e4\u010f\u00e9\u00ed\u013e\u013a\u0148\u00f3\u00f4\u0155\u0165\u00fa\u00fd", "\u010f\u013e\u013a\u0148\u0155\u0165\u00fd");
    @NotNull
    private static final Alphabet SPANISH = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e1\u00e9\u00ed\u00f1\u00f3\u00fa\u00fc\u00a1\u00bf", "\u00e1\u00e9\u00ed\u00f1\u00f3\u00fa\u00fc\u00a1\u00bf", "\u00a1\u00bf");
    @NotNull
    private static final Alphabet ASTURIAN = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghilmn\u00f1oprstuvxyz", "\u00f1", "");
    @NotNull
    private static final Alphabet BRETON = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnoprstuvwyz\u00e2\u00ea\u00ee\u00f4\u00fb\u00f9\u00fc\u00f1", "\u00e2\u00ea\u00ee\u00f4\u00fb\u00f9\u00fc\u00f1", "");
    @NotNull
    private static final Alphabet CATALAN = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00e8\u00ed\u00ef\u00f3\u00f2\u00fa\u00fc\u00e7", "\u00e0\u00e9\u00e8\u00ed\u00ef\u00f3\u00f2\u00fa\u00fc\u00e7", "");
    @NotNull
    private static final Alphabet DANISH = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e6\u00f8\u00e5", "\u00e6\u00f8\u00e5", "\u00e6\u00f8");
    @NotNull
    private static final Alphabet ESPERANTO = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abc\u0109defg\u011dh\u0125ij\u0135klmnoprs\u015dtu\u016dvz", "\u0109\u011d\u0125\u0135\u015d\u016d", "\u0109\u011d\u0125\u0135\u015d\u016d");
    @NotNull
    private static final Alphabet GALICIAN = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghilmn\u00f1opqrstuvxz", "\u00f1", "");
    @NotNull
    private static final Alphabet IRISH = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghilmnoprstu\u00e1\u00e9\u00ed\u00f3\u00fa", "\u00e1\u00e9\u00ed\u00f3\u00fa", "");
    @NotNull
    private static final Alphabet SLOVENE = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abc\u010ddefghijklmnoprs\u0161tuvz\u017e", "\u010d\u0161\u017e", "");
    @NotNull
    private static final Alphabet SWEDISH = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e5\u00e4\u00f6", "\u00e5\u00e4\u00f6", "");
    @NotNull
    private static final Alphabet TAGALOG = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.LATIN, "abcdefghijklmn\u00f1opqrstuvwxyz", "\u00f1", "");
    @NotNull
    private static final Alphabet GREEK = new PredicateAlphabet(Group.GREEK, Alphabet::GREEK$lambda$2, null, null, 12, null);
    @NotNull
    private static final Alphabet KHMER = new PredicateAlphabet(Group.KHMER, Alphabet::KHMER$lambda$3, null, null, 12, null);
    @NotNull
    private static final Alphabet TAMIL = new PredicateAlphabet(Group.TAMIL, Alphabet::TAMIL$lambda$4, null, null, 12, null);
    @NotNull
    private static final Alphabet ARABIC = new PredicateAlphabet(Group.ARABIC, (Function1<? super Character, Boolean>)((Function1)Alphabet::ARABIC$lambda$5), null, null);
    @NotNull
    private static final Alphabet PERSIAN = new PredicateAlphabet(Group.ARABIC, (Function1<? super Character, Boolean>)((Function1)Alphabet::PERSIAN$lambda$6), (Function1<? super Character, Boolean>)((Function1)Alphabet::PERSIAN$lambda$7), (Function1<? super Character, Boolean>)((Function1)Alphabet::PERSIAN$lambda$8));
    @NotNull
    private static final Alphabet CHINESE = new PredicateAlphabet(Group.ASIAN, Alphabet::CHINESE$lambda$9, null, null, 12, null);
    @NotNull
    private static final Alphabet JAPANESE = new PredicateAlphabet(Group.ASIAN, Alphabet::JAPANESE$lambda$10, null, null, 12, null);
    @NotNull
    private static final Alphabet KOREAN = new PredicateAlphabet(Group.ASIAN, Alphabet::KOREAN$lambda$11, null, null, 12, null);
    @NotNull
    private static final Alphabet RUSSIAN = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", "\u0451\u0439\u044a\u044b\u044d", "\u044a");
    @NotNull
    private static final Alphabet UKRANIAN = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0491\u0434\u0435\u0454\u0436\u0437\u0438\u0456\u0457\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044c\u044e\u044f\u02bc'", "\u0454\u0456\u0457\u0491", "\u0457\u0491");
    @NotNull
    private static final Alphabet BELARUSIAN = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.access$setBased(Companion, Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0456\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u045e\u0444\u0445\u0446\u0447\u0448\u044b\u044c\u044d\u044e\u044f", "\u0451\u0439\u0454\u044b\u0456\u045e", "\u045e");
    @NotNull
    private static final Alphabet NONE = new PredicateAlphabet(Group.NONE, Alphabet::NONE$lambda$12, null, null, 12, null);
    @NotNull
    private static final LinkedHashSet<Alphabet> all;
    @NotNull
    private static final LinkedHashSet<Alphabet> latin;
    @NotNull
    private static final LinkedHashSet<Alphabet> greek;
    @NotNull
    private static final LinkedHashSet<Alphabet> khmer;
    @NotNull
    private static final LinkedHashSet<Alphabet> tamil;
    @NotNull
    private static final LinkedHashSet<Alphabet> arabic;
    @NotNull
    private static final LinkedHashSet<Alphabet> cyrillic;
    @NotNull
    private static final LinkedHashSet<Alphabet> asian;

    private Alphabet(Group group) {
        this.group = group;
    }

    @NotNull
    public final Group getGroup() {
        return this.group;
    }

    public abstract boolean matchChar(char var1);

    public boolean matchEntire(@NotNull CharSequence input) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            CharSequence $this$all$iv = input;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (this.matchChar(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public boolean matchAny(@NotNull CharSequence input) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            CharSequence $this$any$iv = input;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!this.matchChar(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public abstract boolean matchAnySpecial(@NotNull CharSequence var1);

    public abstract boolean matchAnyUnique(@NotNull CharSequence var1);

    private static final boolean GREEK$lambda$2(char it) {
        return '\u0370' <= it ? it < '\u0400' : false;
    }

    private static final boolean KHMER$lambda$3(char it) {
        return '\u1780' <= it ? it < '\u1800' : false;
    }

    private static final boolean TAMIL$lambda$4(char it) {
        return '\u0b80' <= it ? it < '\u0c00' : false;
    }

    private static final boolean ARABIC$lambda$5(char it) {
        return '\u0600' <= it ? it < '\u0700' : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean PERSIAN$lambda$6(char it) {
        if (it == '\u200c') return true;
        if ('\u0600' > it) return false;
        if (it >= '\u0700') return false;
        return true;
    }

    private static final boolean PERSIAN$lambda$7(char it) {
        return it == '\u200c';
    }

    private static final boolean PERSIAN$lambda$8(char it) {
        return it == '\u200c';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean CHINESE$lambda$9(char it) {
        boolean bl;
        if ('\u4e00' <= it) {
            if (it < '\ua000') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('\u3400' > it) return false;
        if (it >= '\u4dc0') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean JAPANESE$lambda$10(char it) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if ('\u3040' <= it) {
            if (it < '\u30a0') {
                return true;
            }
            bl4 = false;
        } else {
            bl4 = false;
        }
        if (bl4) return true;
        if ('\u30a0' <= it) {
            if (it < '\u3100') {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        if ('\u31f0' <= it) {
            if (it < '\u3200') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('\u4e00' <= it) {
            if (it < '\ua000') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('\u3400' > it) return false;
        if (it >= '\u4dc0') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean KOREAN$lambda$11(char it) {
        boolean bl;
        boolean bl2;
        if ('\uac00' <= it) {
            if (it < '\ud7a4') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('\u1100' <= it) {
            if (it < '\u1200') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('\u3130' > it) return false;
        if (it >= '\u3190') return false;
        return true;
    }

    private static final boolean NONE$lambda$12(char it) {
        return false;
    }

    public /* synthetic */ Alphabet(Group group, DefaultConstructorMarker $constructor_marker) {
        this(group);
    }

    static {
        Object[] objectArray = new Alphabet[]{ENGLISH, FRENCH, GERMAN, DUTCH, ITALIAN, POLISH, PORTUGUESE, ROMANIAN, SLOVAK, SLOVENE, SWEDISH, SPANISH, TAGALOG, ASTURIAN, BRETON, CATALAN, DANISH, ESPERANTO, GALICIAN, IRISH, GREEK, KHMER, TAMIL, ARABIC, PERSIAN, CHINESE, JAPANESE, RUSSIAN, UKRANIAN, BELARUSIAN};
        all = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{ENGLISH, FRENCH, GERMAN, DUTCH, ITALIAN, POLISH, PORTUGUESE, ROMANIAN, SLOVAK, SLOVENE, SWEDISH, SPANISH, TAGALOG, ASTURIAN, BRETON, CATALAN, DANISH, ESPERANTO, GALICIAN, IRISH};
        latin = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{GREEK};
        greek = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{KHMER};
        khmer = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{TAMIL};
        tamil = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{ARABIC, PERSIAN};
        arabic = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{RUSSIAN, UKRANIAN, BELARUSIAN};
        cyrillic = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new Alphabet[]{CHINESE, JAPANESE};
        asian = SetsKt.linkedSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\bA\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010Y\u001a\u0012\u0012\u0004\u0012\u00020\u00050Gj\b\u0012\u0004\u0012\u00020\u0005`H2\u0006\u0010Z\u001a\u00020[J(\u0010\\\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020[2\u0006\u0010F\u001a\u00020]2\u0006\u0010^\u001a\u00020]2\u0006\u0010_\u001a\u00020]H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007R\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0007R\u0011\u0010,\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0007R\u0011\u0010.\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0007R\u0011\u00100\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0007R\u0011\u00102\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0007R\u0011\u00104\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0007R\u0011\u00106\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0007R\u0011\u00108\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0007R\u0011\u0010:\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0007R\u0011\u0010<\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0007R\u0011\u0010>\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0007R\u0011\u0010@\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0007R\u0011\u0010B\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0007R\u0011\u0010D\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u0007R!\u0010F\u001a\u0012\u0012\u0004\u0012\u00020\u00050Gj\b\u0012\u0004\u0012\u00020\u0005`H\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR!\u0010K\u001a\u0012\u0012\u0004\u0012\u00020\u00050Gj\b\u0012\u0004\u0012\u00020\u0005`H\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010JR!\u0010M\u001a\u0012\u0012\u0004\u0012\u00020\u00050Gj\b\u0012\u0004\u0012\u00020\u0005`H\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010JR!\u0010O\u001a\u0012\u0012\u0004\u0012\u00020\u00050Gj\b\u0012\u0004\u0012\u00020\u0005`H\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010JR!\u0010Q\u001a\u0012\u0012\u0004\u0012\u00020\u00050Gj\b\u0012\u0004\u0012\u00020\u0005`H\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010JR!\u0010S\u001a\u0012\u0012\u0004\u0012\u00020\u00050Gj\b\u0012\u0004\u0012\u00020\u0005`H\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010JR!\u0010U\u001a\u0012\u0012\u0004\u0012\u00020\u00050Gj\b\u0012\u0004\u0012\u00020\u0005`H\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010JR!\u0010W\u001a\u0012\u0012\u0004\u0012\u00020\u00050Gj\b\u0012\u0004\u0012\u00020\u0005`H\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010J\u00a8\u0006`"}, d2={"Lai/grazie/nlp/langs/alphabet/Alphabet$Companion;", "", "<init>", "()V", "ENGLISH", "Lai/grazie/nlp/langs/alphabet/Alphabet;", "getENGLISH", "()Lai/grazie/nlp/langs/alphabet/Alphabet;", "FRENCH", "getFRENCH", "GERMAN", "getGERMAN", "DUTCH", "getDUTCH", "ITALIAN", "getITALIAN", "POLISH", "getPOLISH", "PORTUGUESE", "getPORTUGUESE", "ROMANIAN", "getROMANIAN", "SLOVAK", "getSLOVAK", "SPANISH", "getSPANISH", "ASTURIAN", "getASTURIAN", "BRETON", "getBRETON", "CATALAN", "getCATALAN", "DANISH", "getDANISH", "ESPERANTO", "getESPERANTO", "GALICIAN", "getGALICIAN", "IRISH", "getIRISH", "SLOVENE", "getSLOVENE", "SWEDISH", "getSWEDISH", "TAGALOG", "getTAGALOG", "GREEK", "getGREEK", "KHMER", "getKHMER", "TAMIL", "getTAMIL", "ARABIC", "getARABIC", "PERSIAN", "getPERSIAN", "CHINESE", "getCHINESE", "JAPANESE", "getJAPANESE", "KOREAN", "getKOREAN", "RUSSIAN", "getRUSSIAN", "UKRANIAN", "getUKRANIAN", "BELARUSIAN", "getBELARUSIAN", "NONE", "getNONE", "all", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getAll", "()Ljava/util/LinkedHashSet;", "latin", "getLatin", "greek", "getGreek", "khmer", "getKhmer", "tamil", "getTamil", "arabic", "getArabic", "cyrillic", "getCyrillic", "asian", "getAsian", "byGroup", "group", "Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "setBased", "", "special", "unique", "nlp-langs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Alphabet getENGLISH() {
            return ENGLISH;
        }

        @NotNull
        public final Alphabet getFRENCH() {
            return FRENCH;
        }

        @NotNull
        public final Alphabet getGERMAN() {
            return GERMAN;
        }

        @NotNull
        public final Alphabet getDUTCH() {
            return DUTCH;
        }

        @NotNull
        public final Alphabet getITALIAN() {
            return ITALIAN;
        }

        @NotNull
        public final Alphabet getPOLISH() {
            return POLISH;
        }

        @NotNull
        public final Alphabet getPORTUGUESE() {
            return PORTUGUESE;
        }

        @NotNull
        public final Alphabet getROMANIAN() {
            return ROMANIAN;
        }

        @NotNull
        public final Alphabet getSLOVAK() {
            return SLOVAK;
        }

        @NotNull
        public final Alphabet getSPANISH() {
            return SPANISH;
        }

        @NotNull
        public final Alphabet getASTURIAN() {
            return ASTURIAN;
        }

        @NotNull
        public final Alphabet getBRETON() {
            return BRETON;
        }

        @NotNull
        public final Alphabet getCATALAN() {
            return CATALAN;
        }

        @NotNull
        public final Alphabet getDANISH() {
            return DANISH;
        }

        @NotNull
        public final Alphabet getESPERANTO() {
            return ESPERANTO;
        }

        @NotNull
        public final Alphabet getGALICIAN() {
            return GALICIAN;
        }

        @NotNull
        public final Alphabet getIRISH() {
            return IRISH;
        }

        @NotNull
        public final Alphabet getSLOVENE() {
            return SLOVENE;
        }

        @NotNull
        public final Alphabet getSWEDISH() {
            return SWEDISH;
        }

        @NotNull
        public final Alphabet getTAGALOG() {
            return TAGALOG;
        }

        @NotNull
        public final Alphabet getGREEK() {
            return GREEK;
        }

        @NotNull
        public final Alphabet getKHMER() {
            return KHMER;
        }

        @NotNull
        public final Alphabet getTAMIL() {
            return TAMIL;
        }

        @NotNull
        public final Alphabet getARABIC() {
            return ARABIC;
        }

        @NotNull
        public final Alphabet getPERSIAN() {
            return PERSIAN;
        }

        @NotNull
        public final Alphabet getCHINESE() {
            return CHINESE;
        }

        @NotNull
        public final Alphabet getJAPANESE() {
            return JAPANESE;
        }

        @NotNull
        public final Alphabet getKOREAN() {
            return KOREAN;
        }

        @NotNull
        public final Alphabet getRUSSIAN() {
            return RUSSIAN;
        }

        @NotNull
        public final Alphabet getUKRANIAN() {
            return UKRANIAN;
        }

        @NotNull
        public final Alphabet getBELARUSIAN() {
            return BELARUSIAN;
        }

        @NotNull
        public final Alphabet getNONE() {
            return NONE;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getAll() {
            return all;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getLatin() {
            return latin;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getGreek() {
            return greek;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getKhmer() {
            return khmer;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getTamil() {
            return tamil;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getArabic() {
            return arabic;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getCyrillic() {
            return cyrillic;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> getAsian() {
            return asian;
        }

        @NotNull
        public final LinkedHashSet<Alphabet> byGroup(@NotNull Group group) {
            Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
            return switch (WhenMappings.$EnumSwitchMapping$0[group.ordinal()]) {
                case 1 -> this.getLatin();
                case 2 -> this.getGreek();
                case 3 -> this.getKhmer();
                case 4 -> this.getTamil();
                case 5 -> this.getArabic();
                case 6 -> this.getAsian();
                case 7 -> this.getCyrillic();
                case 8 -> {
                    Object[] var2_2 = new Alphabet[]{this.getNONE()};
                    yield SetsKt.linkedSetOf((Object[])var2_2);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final Alphabet setBased(Group group, String all, String special, String unique) {
            String string = all.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            Set all2 = StringsKt.toSet((CharSequence)(all + string));
            String string2 = special.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            Function1<Character, Boolean> special2 = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.setBased$asPredicate(StringsKt.toSet((CharSequence)(special + string2)));
            String string3 = unique.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            Function1<Character, Boolean> unique2 = ai.grazie.nlp.langs.alphabet.Alphabet$Companion.setBased$asPredicate(StringsKt.toSet((CharSequence)(unique + string3)));
            return new PredicateAlphabet(group, (Function1<? super Character, Boolean>)((Function1)arg_0 -> Companion.setBased$lambda$1(all2, arg_0)), special2, unique2);
        }

        private static final boolean setBased$asPredicate$lambda$0(Set $this_asPredicate, char c) {
            return $this_asPredicate.contains(Character.valueOf(c));
        }

        private static final Function1<Character, Boolean> setBased$asPredicate(Set<Character> $this$setBased_u24asPredicate) {
            return $this$setBased_u24asPredicate.isEmpty() ? null : arg_0 -> Companion.setBased$asPredicate$lambda$0($this$setBased_u24asPredicate, arg_0);
        }

        private static final boolean setBased$lambda$1(Set $all, char it) {
            return $all.contains(Character.valueOf(it));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Alphabet access$setBased(Companion $this, Group group, String all, String special, String unique) {
            return $this.setBased(group, all, special, unique);
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Group.values().length];
                try {
                    nArray[Group.LATIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.GREEK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.KHMER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.TAMIL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.ARABIC.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.ASIAN.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.CYRILLIC.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Group.NONE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\r\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u001d\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0017"}, d2={"Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "", "acceptableChar", "Lkotlin/Function1;", "", "", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "getAcceptableChar", "()Lkotlin/jvm/functions/Function1;", "LATIN", "GREEK", "KHMER", "TAMIL", "ARABIC", "ASIAN", "CYRILLIC", "NONE", "matchAny", "input", "", "matchEntire", "Companion", "nlp-langs"})
    @SourceDebugExtension(value={"SMAP\nAlphabet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Alphabet.kt\nai/grazie/nlp/langs/alphabet/Alphabet$Group\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,133:1\n1088#2,2:134\n1069#2,2:136\n*S KotlinDebug\n*F\n+ 1 Alphabet.kt\nai/grazie/nlp/langs/alphabet/Alphabet$Group\n*L\n34#1:134,2\n35#1:136,2\n*E\n"})
    public static final class Group
    extends Enum<Group> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final Function1<Character, Boolean> acceptableChar;
        @NotNull
        private static final List<Group> all;
        @NotNull
        private static final List<Group> withSpaces;
        public static final /* enum */ Group LATIN;
        public static final /* enum */ Group GREEK;
        public static final /* enum */ Group KHMER;
        public static final /* enum */ Group TAMIL;
        public static final /* enum */ Group ARABIC;
        public static final /* enum */ Group ASIAN;
        public static final /* enum */ Group CYRILLIC;
        public static final /* enum */ Group NONE;
        private static final /* synthetic */ Group[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Group(Function1<? super Character, Boolean> acceptableChar) {
            this.acceptableChar = acceptableChar;
        }

        @NotNull
        public final Function1<Character, Boolean> getAcceptableChar() {
            return this.acceptableChar;
        }

        public final boolean matchAny(@NotNull CharSequence input) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                CharSequence $this$any$iv = input;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!((Boolean)this.acceptableChar.invoke((Object)Character.valueOf(it))).booleanValue()) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public final boolean matchEntire(@NotNull CharSequence input) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                CharSequence $this$all$iv = input;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (((Boolean)this.acceptableChar.invoke((Object)Character.valueOf(it))).booleanValue()) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        public static Group[] values() {
            return (Group[])$VALUES.clone();
        }

        public static Group valueOf(String value) {
            return Enum.valueOf(Group.class, value);
        }

        @NotNull
        public static EnumEntries<Group> getEntries() {
            return $ENTRIES;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean _init_$lambda$0(char it) {
            boolean bl;
            boolean bl2;
            if ('\u0000' <= it) {
                if (it < '\u0080') {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ('\u0080' <= it) {
                if (it < '\u0100') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if ('\u0100' > it) return false;
            if (it >= '\u0180') return false;
            return true;
        }

        private static final boolean _init_$lambda$1(char it) {
            return '\u0370' <= it ? it < '\u0400' : false;
        }

        private static final boolean _init_$lambda$2(char it) {
            return '\u1780' <= it ? it < '\u1800' : false;
        }

        private static final boolean _init_$lambda$3(char it) {
            return '\u0b80' <= it ? it < '\u0c00' : false;
        }

        private static final boolean _init_$lambda$4(char it) {
            return ('\u0600' <= it ? it < '\u0700' : false) || it == '\u200c';
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean _init_$lambda$5(char it) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            boolean bl7;
            if ('\uac00' <= it) {
                if (it < '\ud7a4') {
                    return true;
                }
                bl7 = false;
            } else {
                bl7 = false;
            }
            if (bl7) return true;
            if ('\u1100' <= it) {
                if (it < '\u1200') {
                    return true;
                }
                bl6 = false;
            } else {
                bl6 = false;
            }
            if (bl6) return true;
            if ('\u3130' <= it) {
                if (it < '\u3190') {
                    return true;
                }
                bl5 = false;
            } else {
                bl5 = false;
            }
            if (bl5) return true;
            if ('\u3040' <= it) {
                if (it < '\u30a0') {
                    return true;
                }
                bl4 = false;
            } else {
                bl4 = false;
            }
            if (bl4) return true;
            if ('\u30a0' <= it) {
                if (it < '\u3100') {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if ('\u31f0' <= it) {
                if (it < '\u3200') {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ('\u4e00' <= it) {
                if (it < '\ua000') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if ('\u3400' > it) return false;
            if (it >= '\u4dc0') return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean _init_$lambda$6(char it) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            if ('\u0400' <= it) {
                if (it < '\u0500') {
                    return true;
                }
                bl4 = false;
            } else {
                bl4 = false;
            }
            if (bl4) return true;
            if ('\u0500' <= it) {
                if (it < '\u0530') {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if ('\u2de0' <= it) {
                if (it < '\u2e00') {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ('\ua640' <= it) {
                if (it < '\ua6a0') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (it == '\u02bc') return true;
            if (it != '\'') return false;
            return true;
        }

        private static final boolean _init_$lambda$7(char it) {
            return false;
        }

        static {
            LATIN = new Group((Function1<? super Character, Boolean>)((Function1)Group::_init_$lambda$0));
            GREEK = new Group((Function1<? super Character, Boolean>)((Function1)Group::_init_$lambda$1));
            KHMER = new Group((Function1<? super Character, Boolean>)((Function1)Group::_init_$lambda$2));
            TAMIL = new Group((Function1<? super Character, Boolean>)((Function1)Group::_init_$lambda$3));
            ARABIC = new Group((Function1<? super Character, Boolean>)((Function1)Group::_init_$lambda$4));
            ASIAN = new Group((Function1<? super Character, Boolean>)((Function1)Group::_init_$lambda$5));
            CYRILLIC = new Group((Function1<? super Character, Boolean>)((Function1)Group::_init_$lambda$6));
            NONE = new Group((Function1<? super Character, Boolean>)((Function1)Group::_init_$lambda$7));
            $VALUES = groupArray = new Group[]{Group.LATIN, Group.GREEK, Group.KHMER, Group.TAMIL, Group.ARABIC, Group.ASIAN, Group.CYRILLIC, Group.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Group[] groupArray = new Group[]{LATIN, GREEK, KHMER, TAMIL, ARABIC, ASIAN, CYRILLIC};
            all = CollectionsKt.listOf((Object[])groupArray);
            groupArray = new Group[]{LATIN, GREEK, CYRILLIC};
            withSpaces = CollectionsKt.listOf((Object[])groupArray);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lai/grazie/nlp/langs/alphabet/Alphabet$Group$Companion;", "", "<init>", "()V", "all", "", "Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "getAll", "()Ljava/util/List;", "withSpaces", "getWithSpaces", "nlp-langs"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<Group> getAll() {
                return all;
            }

            @NotNull
            public final List<Group> getWithSpaces() {
                return withSpaces;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lai/grazie/nlp/langs/alphabet/Alphabet$PredicateAlphabet;", "Lai/grazie/nlp/langs/alphabet/Alphabet;", "group", "Lai/grazie/nlp/langs/alphabet/Alphabet$Group;", "all", "Lkotlin/Function1;", "", "", "special", "unique", "<init>", "(Lai/grazie/nlp/langs/alphabet/Alphabet$Group;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "matchChar", "ch", "matchAnyUnique", "input", "", "matchAnySpecial", "nlp-langs"})
    @SourceDebugExtension(value={"SMAP\nAlphabet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Alphabet.kt\nai/grazie/nlp/langs/alphabet/Alphabet$PredicateAlphabet\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,133:1\n1088#2,2:134\n1088#2,2:136\n*S KotlinDebug\n*F\n+ 1 Alphabet.kt\nai/grazie/nlp/langs/alphabet/Alphabet$PredicateAlphabet\n*L\n129#1:134,2\n130#1:136,2\n*E\n"})
    private static final class PredicateAlphabet
    extends Alphabet {
        @NotNull
        private final Function1<Character, Boolean> all;
        @Nullable
        private final Function1<Character, Boolean> special;
        @Nullable
        private final Function1<Character, Boolean> unique;

        public PredicateAlphabet(@NotNull Group group, @NotNull Function1<? super Character, Boolean> all, @Nullable Function1<? super Character, Boolean> special, @Nullable Function1<? super Character, Boolean> unique) {
            Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
            Intrinsics.checkNotNullParameter(all, (String)"all");
            super(group, null);
            this.all = all;
            this.special = special;
            this.unique = unique;
        }

        public /* synthetic */ PredicateAlphabet(Group group, Function1 function1, Function1 function12, Function1 function13, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                function12 = function1;
            }
            if ((n & 8) != 0) {
                function13 = function1;
            }
            this(group, (Function1<? super Character, Boolean>)function1, (Function1<? super Character, Boolean>)function12, (Function1<? super Character, Boolean>)function13);
        }

        @Override
        public boolean matchChar(char ch) {
            return (Boolean)this.all.invoke((Object)Character.valueOf(ch));
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matchAnyUnique(@NotNull CharSequence input) {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (this.unique == null) return false;
            CharSequence charSequence = input;
            Function1<Character, Boolean> predicate$iv = this.unique;
            boolean $i$f$any = false;
            int n = 0;
            while (n < $this$any$iv.length()) {
                char element$iv = $this$any$iv.charAt(n);
                if (((Boolean)predicate$iv.invoke((Object)Character.valueOf(element$iv))).booleanValue()) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matchAnySpecial(@NotNull CharSequence input) {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (this.special == null) return false;
            CharSequence charSequence = input;
            Function1<Character, Boolean> predicate$iv = this.special;
            boolean $i$f$any = false;
            int n = 0;
            while (n < $this$any$iv.length()) {
                char element$iv = $this$any$iv.charAt(n);
                if (((Boolean)predicate$iv.invoke((Object)Character.valueOf(element$iv))).booleanValue()) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

