/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow;

import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.SqlDfaMemoryState;
import com.intellij.sql.inspections.dataflow.sql.SqlFlowAnalyser;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011J\u0006\u0010\u001e\u001a\u00020\u001cJ(\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00112\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!H\u0002J\u0018\u0010#\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J&\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Lcom/intellij/sql/inspections/dataflow/SqlDataFlowRunner;", "", "project", "Lcom/intellij/openapi/project/Project;", "valueFactory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;)V", "interpreter", "Lcom/intellij/codeInspection/dataFlow/interpreter/StandardDataFlowInterpreter;", "getInterpreter", "()Lcom/intellij/codeInspection/dataFlow/interpreter/StandardDataFlowInterpreter;", "setInterpreter", "(Lcom/intellij/codeInspection/dataFlow/interpreter/StandardDataFlowInterpreter;)V", "cancel", "", "buildFlow", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ControlFlow;", "element", "Lcom/intellij/psi/PsiElement;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "analyzeFlow", "Lcom/intellij/codeInspection/dataFlow/interpreter/RunnerResult;", "listener", "Lcom/intellij/codeInspection/dataFlow/lang/DfaListener;", "initialStates", "", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "flow", "createMemoryState", "interpret", "startingStates", "", "Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "createInterpreter", "createInitialInstructionStates", "memStates", "Companion", "intellij.database.sql.core.impl"})
public final class SqlDataFlowRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DfaValueFactory valueFactory;
    public StandardDataFlowInterpreter interpreter;
    @NotNull
    private static final Logger LOG;

    public SqlDataFlowRunner(@NotNull Project project, @NotNull DfaValueFactory valueFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)valueFactory, (String)"valueFactory");
        this.valueFactory = valueFactory;
    }

    public /* synthetic */ SqlDataFlowRunner(Project project, DfaValueFactory dfaValueFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dfaValueFactory = new DfaValueFactory(project);
        }
        this(project, dfaValueFactory);
    }

    @NotNull
    public final StandardDataFlowInterpreter getInterpreter() {
        StandardDataFlowInterpreter standardDataFlowInterpreter = this.interpreter;
        if (standardDataFlowInterpreter != null) {
            return standardDataFlowInterpreter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"interpreter");
        return null;
    }

    public final void setInterpreter(@NotNull StandardDataFlowInterpreter standardDataFlowInterpreter) {
        Intrinsics.checkNotNullParameter((Object)standardDataFlowInterpreter, (String)"<set-?>");
        this.interpreter = standardDataFlowInterpreter;
    }

    public final void cancel() {
        this.getInterpreter().cancel();
    }

    @Nullable
    public final ControlFlow buildFlow(@NotNull PsiElement element, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        try {
            return SqlFlowAnalyser.Companion.buildFlow(element, this.valueFactory, dialect);
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof ProcessCanceledException) {
                throw e;
            }
            if (!(throwable instanceof RuntimeException) && !(throwable instanceof AssertionError)) {
                throw e;
            }
            Attachment[] attachmentArray = new Attachment[]{new Attachment("select_statement.txt", element.getText())};
            LOG.error("Error building control flow", e, attachmentArray);
            return null;
        }
    }

    @NotNull
    public final RunnerResult analyzeFlow(@NotNull DfaListener listener, @NotNull Collection<? extends DfaMemoryState> initialStates, @Nullable ControlFlow flow) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter(initialStates, (String)"initialStates");
        ControlFlow controlFlow = flow;
        Intrinsics.checkNotNull((Object)controlFlow);
        List<DfaInstructionState> startingStates = this.createInitialInstructionStates(initialStates, controlFlow);
        return startingStates.isEmpty() ? RunnerResult.ABORTED : this.interpret(listener, flow, startingStates);
    }

    @NotNull
    public final DfaMemoryState createMemoryState() {
        return (DfaMemoryState)new SqlDfaMemoryState(this.valueFactory);
    }

    private final RunnerResult interpret(DfaListener listener, ControlFlow flow, List<? extends DfaInstructionState> startingStates) {
        this.setInterpreter(this.createInterpreter(listener, flow));
        RunnerResult runnerResult = this.getInterpreter().interpret(startingStates);
        Intrinsics.checkNotNullExpressionValue((Object)runnerResult, (String)"interpret(...)");
        return runnerResult;
    }

    private final StandardDataFlowInterpreter createInterpreter(DfaListener listener, ControlFlow flow) {
        return new StandardDataFlowInterpreter(flow, listener);
    }

    private final List<DfaInstructionState> createInitialInstructionStates(Collection<? extends DfaMemoryState> memStates, ControlFlow flow) {
        List list = ContainerUtil.map(memStates, arg_0 -> SqlDataFlowRunner.createInitialInstructionStates$lambda$1(arg_0 -> SqlDataFlowRunner.createInitialInstructionStates$lambda$0(flow, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"map(...)");
        return list;
    }

    private static final DfaInstructionState createInitialInstructionStates$lambda$0(ControlFlow $flow, DfaMemoryState s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return new DfaInstructionState($flow.getInstruction(0), s);
    }

    private static final DfaInstructionState createInitialInstructionStates$lambda$1(Function1 $tmp0, Object p0) {
        return (DfaInstructionState)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(SqlDataFlowRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/inspections/dataflow/SqlDataFlowRunner$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

