/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs.serializers;

import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.psi.SqlElementType;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.stubs.elementStubs.SqlTableStub;
import com.intellij.sql.psi.stubs.serializers.SqlDefinitionExStubSerializer;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTableStubSerializer<S extends SqlTableStub>
extends SqlDefinitionExStubSerializer<S, SqlTableDefinition> {
    public SqlTableStubSerializer(@NotNull SqlElementType elementType) {
        if (elementType == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void serialize(@NotNull S stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(1);
        }
        if (dataStream == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(2);
        }
        super.serialize(stub, dataStream);
        dataStream.writeName(((SqlTableStub)((Object)stub)).getExpressionText());
        SqlTableStubSerializer.writeStringsArray(dataStream, ((SqlTableStub)((Object)stub)).getAncestorTextRefs());
    }

    @Override
    @NotNull
    public S deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(3);
        }
        return (S)((Object)new SqlTableStub(parentStub, this.elementType, dataStream.readName(), SqlTableStubSerializer.loadProperties(parentStub, dataStream), dataStream.readName(), SqlTableStubSerializer.readStringsArray(dataStream)));
    }

    private static void writeStringsArray(@NotNull StubOutputStream dataStream, StringRef[] @Nullable [] refs) throws IOException {
        if (dataStream == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(4);
        }
        if (refs == null) {
            dataStream.writeVarInt(0);
        } else {
            dataStream.writeVarInt(refs.length);
            for (StringRef[] ref : refs) {
                SqlTableStubSerializer.writeStrings(dataStream, ref);
            }
        }
    }

    private static void writeStrings(@NotNull StubOutputStream dataStream, StringRef @NotNull [] refs) throws IOException {
        if (dataStream == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(5);
        }
        if (refs == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(6);
        }
        dataStream.writeVarInt(refs.length);
        for (StringRef ref : refs) {
            dataStream.writeName(ref.getString());
        }
    }

    private static StringRef @NotNull [] readStrings(@NotNull StubInputStream dataStream) throws IOException {
        int len;
        if (dataStream == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(7);
        }
        if ((len = dataStream.readVarInt()) == 0) {
            if (StringRef.EMPTY_ARRAY == null) {
                SqlTableStubSerializer.$$$reportNull$$$0(8);
            }
            return StringRef.EMPTY_ARRAY;
        }
        StringRef[] res = new StringRef[len];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = dataStream.readName();
        }
        if (res == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(9);
        }
        return res;
    }

    protected static StringRef[] @Nullable [] readStringsArray(@NotNull StubInputStream dataStream) throws IOException {
        int len;
        if (dataStream == null) {
            SqlTableStubSerializer.$$$reportNull$$$0(10);
        }
        if ((len = dataStream.readVarInt()) == 0) {
            return null;
        }
        StringRef[][] res = new StringRef[len][];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = SqlTableStubSerializer.readStrings(dataStream);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/serializers/SqlTableStubSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/serializers/SqlTableStubSerializer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeStringsArray";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeStrings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readStrings";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readStringsArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

