/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.py.debugger.JupyterCellSourcePosition;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"getCellPositionForJupyterCell", "Lcom/intellij/jupyter/py/debugger/JupyterCellSourcePosition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "cell", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "intellij.jupyter.py"})
public final class JupyterDebuggerUtilsKt {
    @Nullable
    public static final JupyterCellSourcePosition getCellPositionForJupyterCell(@NotNull VirtualFile file, @NotNull NotebookIntervalPointer cell) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        NotebookCellLines.Interval interval = cell.get();
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        return JupyterDebuggerUtilsKt.getCellPositionForJupyterCell(file, interval2);
    }

    @Nullable
    public static final JupyterCellSourcePosition getCellPositionForJupyterCell(@NotNull VirtualFile file, @NotNull NotebookCellLines.Interval cell) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPosition(file, cell.getLines().getFirst());
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition startSourcePosition = xSourcePosition;
        return new JupyterCellSourcePosition(startSourcePosition);
    }
}

