/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.py.editor.completion.JupyterRemoteCompletionRequests;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.completion.RuntimeLookupElement;
import com.jetbrains.python.codeInsight.completion.runtime.patProvider.RemoteFilePathRetrievalService;
import com.jetbrains.python.psi.PyStringElement;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/py/editor/completion/JupyterRemoteFilePathRetrievalService;", "Lcom/jetbrains/python/codeInsight/completion/runtime/patProvider/RemoteFilePathRetrievalService;", "<init>", "()V", "retrieveRemoteFileLookupElements", "", "", "Lcom/jetbrains/python/codeInsight/completion/RuntimeLookupElement;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "extractPossibleParentPath", "Lkotlin/Pair;", "content", "getIcon", "Ljavax/swing/Icon;", "completion", "isFile", "", "canComplete", "project", "Lcom/intellij/openapi/project/Project;", "originalFile", "Lcom/intellij/psi/PsiFile;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getContent", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteFilePathRetrievalService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteFilePathRetrievalService.kt\ncom/intellij/jupyter/py/editor/completion/JupyterRemoteFilePathRetrievalService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class JupyterRemoteFilePathRetrievalService
implements RemoteFilePathRetrievalService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final char SEPARATOR = '/';

    @NotNull
    public Map<String, RuntimeLookupElement> retrieveRemoteFileLookupElements(@NotNull CompletionParameters parameters) {
        VirtualFile virtualFile;
        PsiFile originalFile;
        Project project;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Project project2 = parameters.getEditor().getProject();
                if (project2 == null) {
                    return MapsKt.emptyMap();
                }
                project = project2;
                PsiFile psiFile2 = parameters.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
                originalFile = psiFile2;
                virtualFile = originalFile.getVirtualFile();
                if (virtualFile == null) break block6;
                VirtualFile virtualFile2 = virtualFile;
                BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
                VirtualFile p0 = virtualFile2;
                boolean bl = false;
                BackedNotebookVirtualFile backedNotebookVirtualFile = companion.takeIfBacked(p0);
                virtualFile = backedNotebookVirtualFile;
                if (backedNotebookVirtualFile != null) break block7;
            }
            return MapsKt.emptyMap();
        }
        VirtualFile notebookVirtualFile = virtualFile;
        if (!this.canComplete(project, originalFile, (BackedNotebookVirtualFile)notebookVirtualFile)) {
            return MapsKt.emptyMap();
        }
        String string = this.getContent(parameters);
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String content = string;
        Pair<String, String> pair = this.extractPossibleParentPath(content);
        String parentPath = (String)pair.component1();
        String prefix = (String)pair.component2();
        Map remoteFiles2 = (Map)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends Boolean>>, Object>(project, (BackedNotebookVirtualFile)notebookVirtualFile, parentPath, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ BackedNotebookVirtualFile $notebookVirtualFile;
            final /* synthetic */ String $parentPath;
            {
                this.$project = $project;
                this.$notebookVirtualFile = $notebookVirtualFile;
                this.$parentPath = $parentPath;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = JupyterRemoteCompletionRequests.INSTANCE.getFilesFromRemoteServer(this.$project, this.$notebookVirtualFile, this.$parentPath, (Continuation<? super Map<String, Boolean>>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, Boolean>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return (Map)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends RuntimeLookupElement>>, Object>((Map<String, Boolean>)remoteFiles2, this, prefix, null){
            int label;
            final /* synthetic */ Map<String, Boolean> $remoteFiles;
            final /* synthetic */ JupyterRemoteFilePathRetrievalService this$0;
            final /* synthetic */ String $prefix;
            {
                this.$remoteFiles = $remoteFiles;
                this.this$0 = $receiver;
                this.$prefix = $prefix;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$associateByTo$iv$iv$iv;
                        void $this$mapValuesTo$iv$iv;
                        void $this$mapValues$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Map<String, Boolean> map = this.$remoteFiles;
                        JupyterRemoteFilePathRetrievalService jupyterRemoteFilePathRetrievalService = this.this$0;
                        String string = this.$prefix;
                        boolean $i$f$mapValues = false;
                        void var6_6 = $this$mapValues$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                        boolean $i$f$mapValuesTo = false;
                        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
                        Map destination$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            LookupElementBuilder lookupElement;
                            void it$iv$iv;
                            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                            Map map2 = destination$iv$iv$iv;
                            boolean bl = false;
                            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                            K k = it$iv$iv.getKey();
                            Map map3 = map2;
                            boolean bl2 = false;
                            String completion = (String)entry2.getKey();
                            boolean isFile = (Boolean)entry2.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)completion).withTypeText("Remote path").withIcon(JupyterRemoteFilePathRetrievalService.access$getIcon(jupyterRemoteFilePathRetrievalService, completion, isFile)), (String)"withIcon(...)");
                            RuntimeLookupElement runtimeLookupElement = new RuntimeLookupElement((LookupElement)lookupElement, (PrefixMatcher)new PlainPrefixMatcher(string));
                            map3.put(k, runtimeLookupElement);
                        }
                        return destination$iv$iv$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, RuntimeLookupElement>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Pair<String, String> extractPossibleParentPath(String content) {
        String string = FileUtil.normalize((String)content);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
        String independentPath = string;
        int index = StringsKt.lastIndexOf$default((CharSequence)independentPath, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            return new Pair((Object)"", (Object)content);
        }
        return new Pair((Object)StringsKt.substring((String)independentPath, (IntRange)new IntRange(0, index)), (Object)StringsKt.substring((String)independentPath, (IntRange)RangesKt.until((int)(index + 1), (int)independentPath.length())));
    }

    private final Icon getIcon(String completion, boolean isFile) {
        if (isFile) {
            Icon icon = FileTypeManager.getInstance().getFileTypeByExtension(StringsKt.substringAfterLast((String)completion, (String)".", (String)"")).getIcon();
            if (icon == null) {
                Icon icon2 = AllIcons.FileTypes.Unknown;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Unknown");
            }
            return icon;
        }
        Icon icon = PlatformIcons.FOLDER_ICON;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FOLDER_ICON");
        return icon;
    }

    private final boolean canComplete(Project project, PsiFile originalFile, BackedNotebookVirtualFile notebookVirtualFile) {
        JupyterExecutionManager executionManager = JupyterExecutionManager.Companion.getInstance(project, notebookVirtualFile);
        JupyterNotebookSession jupyterNotebookSession = executionManager.getSession();
        if (jupyterNotebookSession == null) {
            return false;
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        JupyterServerConfig jupyterServerConfig = session.getConnectionParameters().getConfig();
        if (jupyterServerConfig == null) {
            return false;
        }
        JupyterServerConfig serverConfig = jupyterServerConfig;
        if (serverConfig.isLocal()) {
            return false;
        }
        return !PythonRuntimeService.getInstance().isInPydevConsole((PsiElement)originalFile);
    }

    private final String getContent(CompletionParameters parameters) {
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement currentElement = psiElement;
        if (!(currentElement instanceof PyStringElement)) {
            return null;
        }
        String string = ((PyStringElement)currentElement).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = ((PyStringElement)currentElement).getContentRange().getStartOffset();
        int n2 = parameters.getOffset() - ((PyStringElement)currentElement).getTextRange().getStartOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }

    public static final /* synthetic */ Icon access$getIcon(JupyterRemoteFilePathRetrievalService $this, String completion, boolean isFile) {
        return $this.getIcon(completion, isFile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/py/editor/completion/JupyterRemoteFilePathRetrievalService$Companion;", "", "<init>", "()V", "SEPARATOR", "", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

