/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.micronaut.config.MnParametrizedConfigKeyInsertHandler;
import com.intellij.microservices.jvm.config.ConfigKeyParts;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.properties.AutoPopupTailTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertyKeyMetaConfigKeyReference;", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyReference;", "Lcom/intellij/psi/PsiElement;", "element", "property", "Lcom/intellij/lang/properties/psi/Property;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/properties/psi/Property;)V", "calculateDefaultRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getReferenceDisplayText", "", "getVariants", "", "", "()[Ljava/lang/Object;", "intellij.micronaut"})
public final class MnPropertyKeyMetaConfigKeyReference
extends MetaConfigKeyReference<PsiElement> {
    @NotNull
    private final Property property;

    public MnPropertyKeyMetaConfigKeyReference(@Nullable PsiElement element, @NotNull Property property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super((MetaConfigKeyManager)MnMetaConfigKeyManager.Companion.getInstance(), element, property.getName());
        this.property = property;
    }

    @NotNull
    protected TextRange calculateDefaultRangeInElement() {
        TextRange defaultRange = super.calculateDefaultRangeInElement();
        MetaConfigKey configKey = this.getResolvedKey();
        if (configKey != null) {
            MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
            if (!configKey.isAccessType(accessTypeArray)) {
                PsiElement psiElement = this.myElement;
                Intrinsics.checkNotNull((Object)psiElement);
                String string = defaultRange.substring(psiElement.getText());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String keyText = string;
                ConfigKeyParts parts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)keyText, (boolean)false);
                if (parts != null) {
                    TextRange textRange = TextRange.allOf((String)parts.getConfigKey());
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"allOf(...)");
                    return textRange;
                }
            }
        }
        Intrinsics.checkNotNull((Object)defaultRange);
        return defaultRange;
    }

    @NotNull
    public String getReferenceDisplayText() {
        String string = this.property.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public Object[] getVariants() {
        Set set = ContainerUtil.map2Set((Collection)this.property.getPropertiesFile().getProperties(), arg_0 -> MnPropertyKeyMetaConfigKeyReference.getVariants$lambda$1(MnPropertyKeyMetaConfigKeyReference::getVariants$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"map2Set(...)");
        Set existingKeys = set;
        PsiElement psiElement = this.myElement;
        Intrinsics.checkNotNull((Object)psiElement);
        char delimiterChar = PropertiesCodeStyleSettings.getInstance((Project)psiElement.getProject()).getDelimiter();
        TailType defaultDelimiterType = AutoPopupTailTypes.charType((char)delimiterChar);
        List configKeys = this.getConfigKeyManager().getAllMetaConfigKeys(this.getElement());
        List result = new ArrayList(configKeys.size());
        for (MetaConfigKey configKey : configKeys) {
            LookupElementDecorator lookupElementDecorator;
            String name;
            Intrinsics.checkNotNullExpressionValue((Object)configKey.getName(), (String)"getName(...)");
            if (existingKeys.contains(name)) continue;
            LookupElementBuilder builder = configKey.getPresentation().getLookupElement();
            MetaConfigKey.AccessType[] accessTypeArray = MetaConfigKey.AccessType.MAP_GROUP;
            TailType tailType = configKey.isAccessType(Arrays.copyOf(accessTypeArray, accessTypeArray.length)) ? AutoPopupTailTypes.dotType() : defaultDelimiterType;
            Ref lookupElementRef = new Ref();
            String string = configKey.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)".*.", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)tailType);
                String string2 = configKey.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                MnParametrizedConfigKeyInsertHandler insertHandler = new MnParametrizedConfigKeyInsertHandler(tailType, string2);
                lookupElementDecorator = LookupElementDecorator.withInsertHandler((LookupElement)((LookupElement)builder), (InsertHandler)insertHandler);
            } else {
                lookupElementDecorator = (LookupElementDecorator)TailTypeDecorator.withTail((LookupElement)((LookupElement)builder), (TailType)tailType);
            }
            LookupElementDecorator tailTypeDecorator = lookupElementDecorator;
            LookupElement lookupElement = configKey.getPresentation().tuneLookupElement((LookupElement)tailTypeDecorator);
            lookupElementRef.set((Object)lookupElement);
            Intrinsics.checkNotNull((Object)lookupElement);
            result.add(lookupElement);
        }
        Collection collection = result;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        return UtilKt.toArray((Collection)collection, (Object[])ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    private static final String getVariants$lambda$0(IProperty obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getKey();
    }

    private static final String getVariants$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

