/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.oas.converters;

import com.intellij.jam.JamService;
import com.intellij.micronaut.jam.http.MnController;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.jam.http.mapping.MnHttpMethodMapping;
import com.intellij.micronaut.oas.converters.MnControllerOasConverter;
import com.intellij.micronaut.oas.converters.MnOasParametersProviderKt;
import com.intellij.micronaut.oas.converters.MnOasRequestBodyProviderKt;
import com.intellij.micronaut.oas.converters.MnOasResponseProviderKt;
import com.intellij.micronaut.provider.http.MnHttpServerFramework;
import com.intellij.micronaut.provider.http.MnHttpUrlTargetInfo;
import com.intellij.microservices.jvm.oas.JvmSwaggerUtilsKt;
import com.intellij.microservices.jvm.oas.v3.SwOperation;
import com.intellij.microservices.jvm.oas.v3.SwUtilsKt;
import com.intellij.microservices.oas.OasComponents;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasExportUtilsKt;
import com.intellij.microservices.oas.OasModelUtils;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasTag;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001aB\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00132\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a8\u0006 "}, d2={"getMethodOpenApiSpecification", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "getMethodSpecification", "mappingInfo", "Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;", "mnController", "Lcom/intellij/micronaut/jam/http/MnController;", "getClassOpenApiSpecifications", "", "uClass", "Lorg/jetbrains/uast/UClass;", "getMethodMapping", "Lcom/intellij/micronaut/jam/http/mapping/MnHttpMethodMapping;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "getMnOpenApiSpecification", "info", "Lcom/intellij/micronaut/provider/http/MnHttpUrlTargetInfo;", "getMnOpenSpecification", "urlTargetInfo", "buildOasOperation", "Lcom/intellij/microservices/oas/OasOperation;", "method", "", "schemas", "", "Lcom/intellij/microservices/oas/OasSchema;", "allTags", "", "Lcom/intellij/microservices/oas/OasTag;", "intellij.micronaut.oas"})
@SourceDebugExtension(value={"SMAP\nMnOasConverters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnOasConverters.kt\ncom/intellij/micronaut/oas/converters/MnOasConvertersKt\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n24#2:103\n1586#3:104\n1661#3,3:105\n1586#3:109\n1661#3,3:110\n1#4:108\n*S KotlinDebug\n*F\n+ 1 MnOasConverters.kt\ncom/intellij/micronaut/oas/converters/MnOasConvertersKt\n*L\n23#1:103\n70#1:104\n70#1:105,3\n99#1:109\n99#1:110,3\n*E\n"})
public final class MnOasConvertersKt {
    @Nullable
    public static final OpenApiSpecification getMethodOpenApiSpecification(@NotNull UMethod uMethod) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        UElement $this$getParentOfType_u24default$iv = (UElement)uMethod;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UClass uClass = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        if (uClass == null || (uClass = uClass.getJavaPsi()) == null) {
            return null;
        }
        UClass containingClass = uClass;
        MnController mnController = (MnController)MnController.META.getJamElement((PsiModifierListOwner)containingClass);
        if (mnController == null) {
            return null;
        }
        MnController controller = mnController;
        MnHttpMethodMapping mnHttpMethodMapping = MnOasConvertersKt.getMethodMapping(uMethod.getJavaPsi());
        if (mnHttpMethodMapping == null) {
            return null;
        }
        MnHttpMethodMapping methodMapping = mnHttpMethodMapping;
        MnHttpMappingInfo mappingInfo = new MnHttpMappingInfo(methodMapping, (PsiClass)containingClass);
        return MnOasConvertersKt.getMethodSpecification(mappingInfo, controller);
    }

    @Nullable
    public static final OpenApiSpecification getMethodSpecification(@NotNull MnHttpMappingInfo mappingInfo, @NotNull MnController mnController) {
        Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
        Intrinsics.checkNotNullParameter((Object)mnController, (String)"mnController");
        Object object = CollectionsKt.firstOrNull(new MnHttpServerFramework().getUrlTargetInfo(mnController, mappingInfo));
        MnHttpUrlTargetInfo mnHttpUrlTargetInfo = object instanceof MnHttpUrlTargetInfo ? (MnHttpUrlTargetInfo)object : null;
        if (mnHttpUrlTargetInfo == null) {
            return null;
        }
        MnHttpUrlTargetInfo info = mnHttpUrlTargetInfo;
        return MnOasConvertersKt.getMnOpenApiSpecification(info);
    }

    @NotNull
    public static final List<OpenApiSpecification> getClassOpenApiSpecifications(@NotNull UClass uClass) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        PsiClass psiClass = uClass.getJavaPsi();
        MnController mnController = (MnController)MnController.META.getJamElement((PsiModifierListOwner)psiClass);
        if (mnController == null) {
            return CollectionsKt.emptyList();
        }
        MnController mnController2 = mnController;
        return new MnControllerOasConverter(psiClass, mnController2).getSpecifications();
    }

    @Nullable
    public static final MnHttpMethodMapping getMethodMapping(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        JamService jamService = JamService.getJamService((Project)psiMethod.getProject());
        MnHttpMethodMapping mapping = (MnHttpMethodMapping)jamService.getJamElement(MnHttpMethodMapping.HTTP_METHOD_JAM_KEY, (PsiElement)psiMethod);
        return mapping;
    }

    private static final OpenApiSpecification getMnOpenApiSpecification(MnHttpUrlTargetInfo info) {
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)info.getDocumentationPsiElement(), UMethod.class);
        if (uMethod == null) {
            return null;
        }
        UMethod uMethod2 = uMethod;
        if (JvmSwaggerUtilsKt.isMappingHidden((UDeclaration)((UDeclaration)uMethod2)) || JvmSwaggerUtilsKt.isMappingHidden((UDeclaration)((UDeclaration)UastUtils.getParentOfType$default((UElement)((UElement)uMethod2), UClass.class, (boolean)false, (int)2, null)))) {
            return OasExportUtilsKt.getEMPTY_OPENAPI_SPECIFICATION();
        }
        return MnOasConvertersKt.getMnOpenSpecification(info, uMethod2);
    }

    /*
     * WARNING - void declaration
     */
    private static final OpenApiSpecification getMnOpenSpecification(MnHttpUrlTargetInfo urlTargetInfo, UMethod uMethod) {
        void $this$mapTo$iv$iv;
        Map schemas = new LinkedHashMap();
        Set<String> httpMethods = urlTargetInfo.getMethods();
        UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)uMethod), UClass.class, (boolean)false, (int)2, null);
        if (uClass == null) {
            return OasExportUtilsKt.getEMPTY_OPENAPI_SPECIFICATION();
        }
        UClass uClass2 = uClass;
        List allTags = new ArrayList();
        CollectionsKt.addAll((Collection)allTags, (Iterable)SwUtilsKt.getOasTags((UDeclaration)((UDeclaration)uClass2)));
        Iterable $this$map$iv = httpMethods;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void method;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MnOasConvertersKt.buildOasOperation((String)method, uMethod, urlTargetInfo, schemas, allTags));
        }
        List operations = (List)destination$iv$iv;
        OasEndpointPath path = new OasEndpointPath(urlTargetInfo.getPath().getPresentation(OasModelUtils.getOPEN_API_PRESENTATION()), null, (Collection)operations);
        return new OpenApiSpecification((Collection)CollectionsKt.listOf((Object)path), new OasComponents(schemas), allTags);
    }

    private static final OasOperation buildOasOperation(String method, UMethod uMethod, MnHttpUrlTargetInfo urlTargetInfo, Map<String, OasSchema> schemas, List<OasTag> allTags) {
        SwOperation oasOperation = (SwOperation)SwOperation.META.getJamElement((PsiModifierListOwner)uMethod.getJavaPsi());
        return new OasOperation.Builder(method).build(arg_0 -> MnOasConvertersKt.buildOasOperation$lambda$0(oasOperation, uMethod, urlTargetInfo, method, schemas, allTags, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit buildOasOperation$lambda$0(SwOperation $oasOperation, UMethod $uMethod, MnHttpUrlTargetInfo $urlTargetInfo, String $method, Map $schemas, List $allTags, OasOperation.Builder $this$build) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void it;
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        SwOperation swOperation = $oasOperation;
        Object object = swOperation != null ? swOperation.getOperationId() : null;
        String string = object;
        OasOperation.Builder builder = $this$build;
        boolean $i$a$-takeIf-MnOasConvertersKt$buildOasOperation$1$22 = false;
        CharSequence charSequence = (CharSequence)it;
        boolean bl = !(charSequence == null || charSequence.length() == 0);
        Object object2 = bl ? object : null;
        if (object2 == null) {
            object2 = $uMethod.getName();
        }
        builder.setOperationId((String)object2);
        SwOperation swOperation2 = $oasOperation;
        $this$build.setDeprecated(swOperation2 != null ? swOperation2.getDeprecated() : $urlTargetInfo.isDeprecated());
        Object object3 = $oasOperation;
        if (object3 == null || (object3 = object3.getSummary()) == null) {
            object = $method;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = ((String)object).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            object3 = string2 + " " + $urlTargetInfo.getPath().getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION);
        }
        $this$build.setSummary((String)object3);
        SwOperation swOperation3 = $oasOperation;
        $this$build.setDescription(swOperation3 != null ? swOperation3.getDescription() : null);
        $this$build.setRequestBody(MnOasRequestBodyProviderKt.getOasRequestBody($uMethod, $schemas, $method));
        $this$build.setResponses(MnOasResponseProviderKt.getOasResponses($uMethod, $schemas));
        $this$build.setParameters(MnOasParametersProviderKt.getOasParameters($urlTargetInfo, $uMethod, $schemas));
        List operationTags = SwUtilsKt.getOasTags((UDeclaration)((UDeclaration)$uMethod));
        object = operationTags;
        builder = $this$build;
        boolean $i$f$map = false;
        void $i$a$-takeIf-MnOasConvertersKt$buildOasOperation$1$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            OasTag oasTag = (OasTag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it2.getName());
        }
        Collection collection = (List)destination$iv$iv;
        SwOperation swOperation4 = $oasOperation;
        List list = swOperation4 != null ? swOperation4.getTags() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        builder.setTags(CollectionsKt.plus((Collection)collection, (Iterable)list));
        CollectionsKt.addAll((Collection)$allTags, (Iterable)operationTags);
        return Unit.INSTANCE;
    }
}

