/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.jam.websocket.MnWebSocketUrlPathSpecification;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.microservices.jvm.pathvars.PathVariableConsumerInfo;
import com.intellij.microservices.jvm.pathvars.PathVariableContext;
import com.intellij.microservices.url.parameters.PathVariableSem;
import com.intellij.microservices.url.parameters.PathVariableSemElementSupportKt;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.semantic.SemService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/micronaut/provider/http/MnPathVariableContext;", "Lcom/intellij/microservices/jvm/pathvars/PathVariableContext;", "<init>", "()V", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "getUrlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "extractPathVariableUsageFromParameter", "Lcom/intellij/microservices/jvm/pathvars/PathVariableConsumerInfo;", "uParameter", "Lorg/jetbrains/uast/UParameter;", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnUnresolvedPathVariableInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnUnresolvedPathVariableInspection.kt\ncom/intellij/micronaut/provider/http/MnPathVariableContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
final class MnPathVariableContext
extends PathVariableContext {
    @NotNull
    public static final MnPathVariableContext INSTANCE = new MnPathVariableContext();

    private MnPathVariableContext() {
        super("io.micronaut.http.annotation.PathVariable");
    }

    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MnHttpUtils.hasMicronautHttpApiJar(module);
    }

    @NotNull
    public UrlPathContext getUrlPathContext(@NotNull UMethod uMethod) {
        UrlPathContext urlPathContext;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        UrlPathContext it = urlPathContext = MnHttpUrlPathSpecification.INSTANCE.getUrlPathContext((PsiElement)uMethod.getJavaPsi());
        boolean bl = false;
        Object object = !it.isEmpty() ? urlPathContext : null;
        if (object == null) {
            object = MnWebSocketUrlPathSpecification.INSTANCE.getUrlPathContext((PsiElement)uMethod.getJavaPsi());
        }
        return object;
    }

    @Nullable
    public PathVariableConsumerInfo extractPathVariableUsageFromParameter(@NotNull UParameter uParameter) {
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        PathVariableConsumerInfo pathVariableConsumerInfo = super.extractPathVariableUsageFromParameter(uParameter);
        if (pathVariableConsumerInfo != null) {
            PathVariableConsumerInfo it = pathVariableConsumerInfo;
            boolean bl = false;
            return it;
        }
        PsiElement psiElement = uParameter.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourcePsi = psiElement;
        PathVariableSem pathVariableSem = (PathVariableSem)SemService.getSemService((Project)sourcePsi.getProject()).getSemElement(PathVariableSemElementSupportKt.PATH_VARIABLE_SEM_KEY, sourcePsi);
        if (pathVariableSem == null) {
            return null;
        }
        PathVariableSem pathVariableSem2 = pathVariableSem;
        String string = pathVariableSem2.getName();
        UElement uElement = uParameter.getUastAnchor();
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            uElement = sourcePsi;
        }
        return new PathVariableConsumerInfo(string, (PsiElement)uElement, false);
    }
}

