/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.micronaut.jam.http.MnHttpConstants;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.microservices.jvm.pathvars.PathVariableRegexInjector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0014J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0014J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0014J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/micronaut/provider/http/MnPathVariableRegexInjector;", "Lcom/intellij/microservices/jvm/pathvars/PathVariableRegexInjector;", "<init>", "()V", "getPattern", "Lcom/intellij/patterns/uast/UExpressionPattern;", "validateRangeValue", "", "rangeValue", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isSupportedProject", "project", "Lcom/intellij/openapi/project/Project;", "getIgnoredRanges", "", "Lcom/intellij/openapi/util/TextRange;", "text", "", "Holder", "intellij.micronaut"})
public final class MnPathVariableRegexInjector
extends PathVariableRegexInjector {
    @NotNull
    protected UExpressionPattern<?, ?> getPattern() {
        return Holder.INSTANCE.getPATTERN();
    }

    protected boolean validateRangeValue(@NotNull StringBuilder rangeValue) {
        Intrinsics.checkNotNullParameter((Object)rangeValue, (String)"rangeValue");
        Regex regex = Holder.INSTANCE.getDIGITS_CONSTRAINT_REGEX();
        String string = rangeValue.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return !regex.matches((CharSequence)string);
    }

    protected boolean isSupportedProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MnHttpUtils.hasMicronautHttpApiJar(project);
    }

    @NotNull
    protected Collection<TextRange> getIgnoredRanges(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)"${", (String)"}");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        return set;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/micronaut/provider/http/MnPathVariableRegexInjector$Holder;", "", "<init>", "()V", "PATTERN", "Lcom/intellij/patterns/uast/UExpressionPattern;", "getPATTERN", "()Lcom/intellij/patterns/uast/UExpressionPattern;", "DIGITS_CONSTRAINT_REGEX", "Lkotlin/text/Regex;", "getDIGITS_CONSTRAINT_REGEX", "()Lkotlin/text/Regex;", "intellij.micronaut"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final UExpressionPattern<?, ?> PATTERN;
        @NotNull
        private static final Regex DIGITS_CONSTRAINT_REGEX;

        private Holder() {
        }

        @NotNull
        public final UExpressionPattern<?, ?> getPATTERN() {
            return PATTERN;
        }

        @NotNull
        public final Regex getDIGITS_CONSTRAINT_REGEX() {
            return DIGITS_CONSTRAINT_REGEX;
        }

        static {
            ObjectPattern objectPattern = UastPatterns.uExpression().with((PatternCondition)new PatternCondition<UExpression>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean accepts(UExpression uElement, ProcessingContext context) {
                    Intrinsics.checkNotNullParameter((Object)uElement, (String)"uElement");
                    Pair pair = UAnnotationUtils.getContainingUAnnotationEntry((UElement)((UElement)uElement));
                    if (pair == null) {
                        return false;
                    }
                    Pair pair2 = pair;
                    UAnnotation uAnnotation = (UAnnotation)pair2.component1();
                    String uParamName = (String)pair2.component2();
                    String string = uParamName;
                    if (string == null) {
                        string = "value";
                    }
                    String paramName = string;
                    String qualifiedName = uAnnotation.getQualifiedName();
                    if (CollectionsKt.contains((Iterable)MnHttpConstants.getMN_HTTP_MAPPING_METHODS(), (Object)qualifiedName)) {
                        if (Intrinsics.areEqual((Object)paramName, (Object)"value")) return true;
                        if (!Intrinsics.areEqual((Object)paramName, (Object)"uri")) return false;
                        return true;
                    }
                    if (qualifiedName == null) return false;
                    switch (qualifiedName.hashCode()) {
                        case -1666945436: {
                            if (qualifiedName.equals("io.micronaut.websocket.annotation.ClientWebSocket")) return Intrinsics.areEqual((Object)paramName, (Object)"value");
                            return false;
                        }
                        case -151583915: {
                            if (qualifiedName.equals("io.micronaut.http.annotation.Controller")) return Intrinsics.areEqual((Object)paramName, (Object)"value");
                            return false;
                        }
                        case 116097836: {
                            if (qualifiedName.equals("io.micronaut.http.annotation.HttpMethodMapping")) return Intrinsics.areEqual((Object)paramName, (Object)"value");
                            return false;
                        }
                        case -837510676: {
                            if (qualifiedName.equals("io.micronaut.websocket.annotation.ServerWebSocket")) return Intrinsics.areEqual((Object)paramName, (Object)"value");
                            return false;
                        }
                        case -1383933573: {
                            if (!qualifiedName.equals("io.micronaut.http.annotation.UriMapping")) return false;
                            return Intrinsics.areEqual((Object)paramName, (Object)"value");
                        }
                    }
                    return false;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
            PATTERN = (UExpressionPattern)objectPattern;
            DIGITS_CONSTRAINT_REGEX = new Regex("\\s*[0-9]+\\s*");
        }
    }
}

