/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.run.MnRunConfiguration;
import com.intellij.micronaut.run.MnRunConfigurationOptions;
import com.intellij.micronaut.run.MnRunConfigurationType;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/micronaut/run/MnRunConfigurationType;", "Lcom/intellij/execution/configurations/ConfigurationType;", "<init>", "()V", "factory", "com/intellij/micronaut/run/MnRunConfigurationType$factory$1", "Lcom/intellij/micronaut/run/MnRunConfigurationType$factory$1;", "getDisplayName", "", "getConfigurationTypeDescription", "getIcon", "Ljavax/swing/Icon;", "getId", "getConfigurationFactories", "", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "()[Lcom/intellij/execution/configurations/ConfigurationFactory;", "isDumbAware", "", "intellij.micronaut"})
public final class MnRunConfigurationType
implements ConfigurationType {
    @NotNull
    private final factory.1 factory = new ConfigurationFactory(this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (RunConfiguration)new MnRunConfiguration("", project, this);
        }

        public boolean isApplicable(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return MicronautUtils.hasMicronautLibrary(project);
        }

        public String getId() {
            return "Micronaut";
        }

        public boolean isEditableInDumbMode() {
            return true;
        }

        public Class<? extends BaseState> getOptionsClass() {
            return MnRunConfigurationOptions.class;
        }
    };

    @NotNull
    public String getDisplayName() {
        return MicronautBundle.message("micronaut.run.configuration.name", new Object[0]);
    }

    @NotNull
    public String getConfigurationTypeDescription() {
        return MicronautBundle.message("micronaut.run.configuration.description", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = MicronautIcons.MicronautLogo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MicronautLogo");
        return icon;
    }

    @NotNull
    public String getId() {
        return "MicronautRunConfigurationType";
    }

    @NotNull
    public ConfigurationFactory[] getConfigurationFactories() {
        ConfigurationFactory[] configurationFactoryArray = new ConfigurationFactory[]{this.factory};
        return configurationFactoryArray;
    }

    public boolean isDumbAware() {
        return true;
    }
}

