/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.model;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.model.SwSpecificationSchemaStorage;
import com.intellij.swagger.core.providers.SwJsonSchemaPatchUtils;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.text.NameUtilCore;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.io.InputStream;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\bJ\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000Ri\u0010\u0006\u001a]\u0012*\u0012( \f*\u0013\u0018\u00010\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012(\u0012&\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f \f*\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\r0\r0\u0007\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/swagger/core/model/SwSpecificationSchemaStorage;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "schemasBySpecificationType", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/swagger/core/SwSpecificationType;", "Lkotlin/ParameterName;", "name", "specificationType", "kotlin.jvm.PlatformType", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "Lorg/jetbrains/annotations/NotNull;", "getSchemaFor", "computeSchema", "computeSchemaObject", "schemaFile", "getSchemaFile", "getRootSchemaResourcePath", "", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwSpecificationSchemaStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwSpecificationSchemaStorage.kt\ncom/intellij/swagger/core/model/SwSpecificationSchemaStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n23#2:72\n*S KotlinDebug\n*F\n+ 1 SwSpecificationSchemaStorage.kt\ncom/intellij/swagger/core/model/SwSpecificationSchemaStorage\n*L\n39#1:72\n*E\n"})
public final class SwSpecificationSchemaStorage {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<SwSpecificationType, Pair<VirtualFile, JsonSchemaObject>> schemasBySpecificationType;

    public SwSpecificationSchemaStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> SwSpecificationSchemaStorage.schemasBySpecificationType$lambda$0((Function1)new Function1<SwSpecificationType, Pair<? extends VirtualFile, ? extends JsonSchemaObject>>((Object)this){

            public final Pair<VirtualFile, JsonSchemaObject> invoke(SwSpecificationType p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SwSpecificationSchemaStorage.access$computeSchema((SwSpecificationSchemaStorage)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.schemasBySpecificationType = concurrentMap;
    }

    @Nullable
    public final Pair<VirtualFile, JsonSchemaObject> getSchemaFor(@NotNull SwSpecificationType specificationType) {
        Intrinsics.checkNotNullParameter((Object)specificationType, (String)"specificationType");
        return specificationType instanceof SwSpecificationType.NONE ? null : (Pair)this.schemasBySpecificationType.get(specificationType);
    }

    private final Pair<VirtualFile, JsonSchemaObject> computeSchema(SwSpecificationType specificationType) {
        VirtualFile schemaFile = this.getSchemaFile(specificationType);
        JsonSchemaObject schemaObject = this.computeSchemaObject(schemaFile, this.project);
        return TuplesKt.to((Object)schemaFile, (Object)schemaObject);
    }

    private final JsonSchemaObject computeSchemaObject(VirtualFile schemaFile, Project project) {
        JsonSchemaObject bundledSchemaObject = JsonSchemaReader.getOrComputeSchemaObjectForSchemaFile((VirtualFile)schemaFile, (Project)project);
        if (bundledSchemaObject == null) {
            SwSpecificationSchemaStorage $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwSpecificationSchemaStorage.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Json schema object was not created for a bundled schema file. Schema file: " + schemaFile.getName());
        }
        return bundledSchemaObject;
    }

    private final VirtualFile getSchemaFile(SwSpecificationType specificationType) {
        StringBuilder stringBuilder;
        String resourcePath = this.getRootSchemaResourcePath(specificationType);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new RuntimeException("No bundled json schema found in resources folder: '" + resourcePath + "'");
        }
        InputStream bundledSchemaAsStream = inputStream;
        String string = FileUtil.loadTextAndClose((InputStream)bundledSchemaAsStream);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadTextAndClose(...)");
        String defaultSchemaContent = string;
        String patchedSchemaContent = SwJsonSchemaPatchUtils.INSTANCE.applySuitablePatches(defaultSchemaContent, specificationType);
        StringBuilder $this$getSchemaFile_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getSchemaFile_u24lambda_u240.append(specificationType.getPresentableName());
        if (specificationType instanceof SwSpecificationType.SecondarySpecificationPart && !StringsKt.isBlank((CharSequence)((SwSpecificationType.SecondarySpecificationPart)((Object)specificationType)).getPartSchemaId())) {
            String shortPartId = StringsKt.substringAfterLast$default((String)((SwSpecificationType.SecondarySpecificationPart)((Object)specificationType)).getPartSchemaId(), (String)"/", null, (int)2, null);
            String prettyName2 = CollectionsKt.joinToString$default((Iterable)NameUtilCore.nameToWordList((String)shortPartId), (CharSequence)" ", null, null, (int)0, null, (Function1)getSchemaFile.schemaName.1.prettyName.1.INSTANCE, (int)30, null);
            $this$getSchemaFile_u24lambda_u240.append(" [" + prettyName2 + "]");
        }
        String schemaName2 = stringBuilder.toString();
        LanguageFileType jsonFileType = FileTypeManager.getInstance().findFileTypeByLanguage((Language)JsonLanguage.INSTANCE);
        return (VirtualFile)new LightVirtualFile(schemaName2 + ".json", (FileType)jsonFileType, (CharSequence)patchedSchemaContent);
    }

    private final String getRootSchemaResourcePath(SwSpecificationType specificationType) {
        String string;
        SwSpecificationType swSpecificationType = specificationType;
        if (swSpecificationType instanceof SwSpecificationType.Swagger2Family) {
            string = "schema/swagger_2_0.json";
        } else if (swSpecificationType instanceof SwSpecificationType.OpenAPI30Family) {
            string = "schema/openapi_3_0_0.json";
        } else if (swSpecificationType instanceof SwSpecificationType.OpenAPI31Family) {
            string = "schema/openapi_3_1_0.json";
        } else if (swSpecificationType instanceof SwSpecificationType.ASYNCAPI_2_6) {
            string = "schema/asyncapi_2_6_0.json";
        } else if (swSpecificationType instanceof SwSpecificationType.ASYNCAPI_3_0) {
            string = "schema/asyncapi_3_0_0.json";
        } else {
            throw new RuntimeException("No schema file exist for specification type: " + specificationType);
        }
        return string;
    }

    private static final Pair schemasBySpecificationType$lambda$0(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Pair access$computeSchema(SwSpecificationSchemaStorage $this, SwSpecificationType specificationType) {
        return $this.computeSchema(specificationType);
    }
}

