/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.lineProfiler.LineProfilerState;
import com.intellij.profiler.lineProfiler.data.LinesGroup;
import com.intellij.profiler.lineProfiler.lineMapping.LineMapping;
import com.intellij.profiler.lineProfiler.lineMapping.LinesMapper;
import com.intellij.profiler.lineProfiler.ui.LineHighlighter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0013J,\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u0010\u0010'\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u0010(\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u0013J\u0006\u0010)\u001a\u00020*J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\u0001H\u00c6\u0003J\t\u0010.\u001a\u00020\bH\u00c2\u0003J1\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0014\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u00103\u001a\u000204H\u00d6\u0081\u0004J\n\u00105\u001a\u000206H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00170\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0017`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u001a0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00067"}, d2={"Lcom/intellij/profiler/lineProfiler/Dump;", "", "state", "Lcom/intellij/profiler/lineProfiler/LineProfilerState;", "project", "Lcom/intellij/openapi/project/Project;", "key", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/profiler/lineProfiler/LineProfilerState;Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Lkotlinx/coroutines/CoroutineScope;)V", "getState", "()Lcom/intellij/profiler/lineProfiler/LineProfilerState;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getKey", "()Ljava/lang/Object;", "editors", "Ljava/util/HashMap;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/profiler/lineProfiler/ui/LineHighlighter;", "Lkotlin/collections/HashMap;", "mappers", "Lcom/intellij/profiler/lineProfiler/lineMapping/LinesMapper;", "openEditors", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getOpenEditors", "()Ljava/util/List;", "getOrCreateMapper", "editor", "getOrCreateHighlighter", "lines", "Lcom/intellij/profiler/lineProfiler/data/LinesGroup;", "mapping", "Lcom/intellij/profiler/lineProfiler/lineMapping/LineMapping;", "createListener", "Lkotlin/Function0;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "getHighlighter", "closeEditor", "clearMappings", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.profiler.lineProfiler"})
@SourceDebugExtension(value={"SMAP\nLineProfilerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineProfilerService.kt\ncom/intellij/profiler/lineProfiler/Dump\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,306:1\n383#2,7:307\n383#2,7:314\n*S KotlinDebug\n*F\n+ 1 LineProfilerService.kt\ncom/intellij/profiler/lineProfiler/Dump\n*L\n64#1:307,7\n70#1:314,7\n*E\n"})
public final class Dump {
    @NotNull
    private final LineProfilerState state;
    @NotNull
    private final Project project;
    @NotNull
    private final Object key;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final HashMap<Editor, LineHighlighter> editors;
    @NotNull
    private final HashMap<Editor, LinesMapper> mappers;

    public Dump(@NotNull LineProfilerState state, @NotNull Project project, @NotNull Object key, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.state = state;
        this.project = project;
        this.key = key;
        this.coroutineScope = coroutineScope;
        this.editors = new HashMap();
        this.mappers = new HashMap();
    }

    @NotNull
    public final LineProfilerState getState() {
        return this.state;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Object getKey() {
        return this.key;
    }

    @NotNull
    public final synchronized List<Editor> getOpenEditors() {
        Set<Editor> set = this.editors.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized LinesMapper getOrCreateMapper(@NotNull Editor editor) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Map map = this.mappers;
        Editor key$iv = editor;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            VirtualFile virtualFile = editor.getVirtualFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            LinesMapper answer$iv = new LinesMapper(this.project, virtualFile, document, this.state.getTimeStamp());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (LinesMapper)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized LineHighlighter getOrCreateHighlighter(@NotNull Editor editor, @NotNull LinesGroup lines, @NotNull LineMapping mapping, @NotNull Function0<? extends DocumentListener> createListener) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(createListener, (String)"createListener");
        Map map = this.editors;
        Editor key$iv = editor;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            LineHighlighter lineHighlighter;
            boolean bl = false;
            LineHighlighter it = lineHighlighter = new LineHighlighter(editor, lines, mapping, this.coroutineScope);
            boolean bl2 = false;
            editor.getDocument().addDocumentListener((DocumentListener)createListener.invoke(), (Disposable)it);
            LineHighlighter answer$iv = lineHighlighter;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (LineHighlighter)object;
    }

    @Nullable
    public final synchronized LineHighlighter getHighlighter(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.editors.get(editor);
    }

    @Nullable
    public final synchronized LineHighlighter closeEditor(@NotNull Editor editor) {
        LineHighlighter lineHighlighter;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        LineHighlighter lineHighlighter2 = this.editors.remove(editor);
        if (lineHighlighter2 != null) {
            LineHighlighter lineHighlighter3;
            LineHighlighter highlighter2 = lineHighlighter3 = lineHighlighter2;
            boolean bl = false;
            ActionsKt.runInEdt$default(null, () -> Dump.closeEditor$lambda$0$0(highlighter2), (int)1, null);
            lineHighlighter = lineHighlighter3;
        } else {
            lineHighlighter = null;
        }
        return lineHighlighter;
    }

    public final void clearMappings() {
        Iterator<LinesMapper> iterator = this.mappers.values().iterator();
        while (iterator.hasNext()) {
            LinesMapper map;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            map.clear();
        }
    }

    @NotNull
    public final LineProfilerState component1() {
        return this.state;
    }

    @NotNull
    public final Project component2() {
        return this.project;
    }

    @NotNull
    public final Object component3() {
        return this.key;
    }

    private final CoroutineScope component4() {
        return this.coroutineScope;
    }

    @NotNull
    public final Dump copy(@NotNull LineProfilerState state, @NotNull Project project, @NotNull Object key, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        return new Dump(state, project, key, coroutineScope);
    }

    public static /* synthetic */ Dump copy$default(Dump dump, LineProfilerState lineProfilerState, Project project, Object object, CoroutineScope coroutineScope, int n, Object object2) {
        if ((n & 1) != 0) {
            lineProfilerState = dump.state;
        }
        if ((n & 2) != 0) {
            project = dump.project;
        }
        if ((n & 4) != 0) {
            object = dump.key;
        }
        if ((n & 8) != 0) {
            coroutineScope = dump.coroutineScope;
        }
        return dump.copy(lineProfilerState, project, object, coroutineScope);
    }

    @NotNull
    public String toString() {
        return "Dump(state=" + this.state + ", project=" + this.project + ", key=" + this.key + ", coroutineScope=" + this.coroutineScope + ")";
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = result * 31 + this.project.hashCode();
        result = result * 31 + this.key.hashCode();
        result = result * 31 + this.coroutineScope.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Dump)) {
            return false;
        }
        Dump dump = (Dump)other;
        if (!Intrinsics.areEqual((Object)this.state, (Object)dump.state)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)dump.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)dump.key)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.coroutineScope, (Object)dump.coroutineScope);
    }

    private static final Unit closeEditor$lambda$0$0(LineHighlighter $highlighter) {
        Disposer.dispose((Disposable)$highlighter);
        return Unit.INSTANCE;
    }
}

