/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.lineProfiler.Dump;
import com.intellij.profiler.lineProfiler.LineProfilerService;
import com.intellij.profiler.lineProfiler.ui.LineHighlighter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/lineProfiler/ui/EditorSelectionListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.profiler.lineProfiler"})
final class EditorSelectionListener
implements FileEditorManagerListener {
    @NotNull
    private final Project project;

    public EditorSelectionListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileEditor fileEditor = event.getOldEditor();
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null) {
            return;
        }
        TextEditor fileEditor2 = textEditor;
        LineProfilerService lineProfilerService = LineProfilerService.Companion.getInstanceOrNull(this.project);
        if (lineProfilerService == null) {
            return;
        }
        LineProfilerService service = lineProfilerService;
        Dump dump = service.getCurrentDump$intellij_profiler_lineProfiler();
        if (dump == null) {
            return;
        }
        Dump dump2 = dump;
        Editor editor = fileEditor2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        LineHighlighter lineHighlighter = dump2.getHighlighter(editor);
        if (lineHighlighter == null) {
            return;
        }
        LineHighlighter highlighter2 = lineHighlighter;
        highlighter2.onEditorSelectionChanged$intellij_profiler_lineProfiler();
    }
}

