/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.history;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.history.DataSourceFromHistory;
import com.intellij.database.dataSource.history.DataSourceHistoryImplKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u00020\f2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0015J\u0006\u0010\u001b\u001a\u00020\u0019J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\u0011J\u0006\u0010 \u001a\u00020\fJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/dataSource/history/DataSourceHistoryImpl;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "history", "Ljava/util/LinkedHashMap;", "", "Lcom/intellij/database/dataSource/history/DataSourceFromHistory;", "Lkotlin/collections/LinkedHashMap;", "loadState", "", "stateFile", "Ljava/nio/file/Path;", "backupFile", "state", "Lorg/jdom/Element;", "bindExistingDataSources", "existingDataSourcesProvider", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/LocalDataSource;", "addDataSourceFromProject", "dataSource", "maxHistorySize", "", "removeDataSourceFromProject", "getNumberOfProjectDataSources", "fitCapacity", "maxSize", "addDataSource", "getState", "clear", "getProjectDataSources", "", "getDataSources", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDataSourceHistoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceHistoryImpl.kt\ncom/intellij/database/dataSource/history/DataSourceHistoryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1915#2,2:120\n1915#2,2:122\n1834#2,4:124\n1915#2,2:129\n777#2:131\n873#2,2:132\n1#3:128\n*S KotlinDebug\n*F\n+ 1 DataSourceHistoryImpl.kt\ncom/intellij/database/dataSource/history/DataSourceHistoryImpl\n*L\n49#1:120,2\n53#1:122,2\n76#1:124,4\n94#1:129,2\n115#1:131\n115#1:132,2\n*E\n"})
public final class DataSourceHistoryImpl {
    @NotNull
    private final Project project;
    @NotNull
    private final LinkedHashMap<String, DataSourceFromHistory> history;

    public DataSourceHistoryImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.history = new LinkedHashMap();
    }

    public final void loadState(@Nullable Path stateFile, @NotNull Path backupFile) {
        Intrinsics.checkNotNullParameter((Object)backupFile, (String)"backupFile");
        if (stateFile == null) {
            return;
        }
        Path stateFile2 = stateFile;
        Element state = null;
        try {
            if (Files.notExists(stateFile2, new LinkOption[0])) {
                if (Files.notExists(backupFile, new LinkOption[0])) {
                    DataSourceHistoryImplKt.access$getLog$p().info("History backup file does not exist: " + backupFile);
                    return;
                }
                stateFile2 = backupFile;
                DataSourceHistoryImplKt.access$getLog$p().info("History state file does not exist: " + stateFile2 + ", using backup file");
            }
            Element element = JDOMUtil.load((Path)stateFile2);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            state = element;
        }
        catch (CancellationException c) {
            throw c;
        }
        catch (Throwable e) {
            DataSourceHistoryImplKt.access$getLog$p().error("Failed to load history state", e);
            return;
        }
        this.loadState(state);
    }

    public final void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Iterable $this$forEach$iv = DataSourceFromHistory.Companion.splitOnDataSourcesState(this.project, state);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSourceFromHistory it = (DataSourceFromHistory)element$iv;
            boolean bl = false;
            this.addDataSource(it);
        }
    }

    public final void bindExistingDataSources(@NotNull Function1<? super String, ? extends LocalDataSource> existingDataSourcesProvider) {
        Intrinsics.checkNotNullParameter(existingDataSourcesProvider, (String)"existingDataSourcesProvider");
        Collection<DataSourceFromHistory> collection = this.history.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSourceFromHistory it = (DataSourceFromHistory)element$iv;
            boolean bl = false;
            LocalDataSource existing = (LocalDataSource)existingDataSourcesProvider.invoke((Object)it.getUniqueId());
            if (existing == null) continue;
            it.bindProjectDataSource(existing);
        }
    }

    public final void addDataSourceFromProject(@NotNull LocalDataSource dataSource, int maxHistorySize) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        DataSourceFromHistory existing = ((Map)this.history).getOrDefault(dataSource.getUniqueId(), null);
        if (existing != null) {
            existing.bindProjectDataSource(dataSource);
            return;
        }
        this.fitCapacity(maxHistorySize);
        this.addDataSource(new DataSourceFromHistory(this.project, dataSource));
    }

    public final void removeDataSourceFromProject(@NotNull LocalDataSource dataSource) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            DataSourceFromHistory dataSourceFromHistory = this.history.get(dataSource.getUniqueId());
            if (dataSourceFromHistory == null) break block0;
            dataSourceFromHistory.unbindProjectDataSource();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getNumberOfProjectDataSources() {
        int n;
        Collection<DataSourceFromHistory> collection = this.history.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                DataSourceFromHistory it = (DataSourceFromHistory)element$iv;
                boolean bl = false;
                if (!(!it.isRemovedFromProject()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    private final void fitCapacity(int maxSize) {
        int currentSize = this.history.size();
        if (currentSize >= maxSize) {
            int toDelete = currentSize - maxSize + 1;
            int n = 0;
            while (n < toDelete) {
                int it = n++;
                boolean bl = false;
                this.history.remove(this.history.firstEntry().getKey());
            }
        }
    }

    public final void addDataSource(@NotNull DataSourceFromHistory dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (this.history.put(dataSource.getUniqueId(), dataSource) != null) {
            DataSourceHistoryImplKt.access$getLog$p().warn("Duplicate data source id: " + dataSource.getUniqueId());
        }
    }

    @NotNull
    public final Element getState() {
        Element element = new Element("DataSourcesHistory");
        Collection<DataSourceFromHistory> collection = this.history.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSourceFromHistory it = (DataSourceFromHistory)element$iv;
            boolean bl = false;
            try {
                element.addContent(it.getState());
            }
            catch (Throwable e) {
                DataSourceHistoryImplKt.access$getLog$p().error("Failed to save data source", e);
            }
        }
        if (element.getChildren().isEmpty()) {
            DataSourceHistoryImplKt.access$getLog$p().info("No data sources in history");
        }
        return element;
    }

    public final void clear() {
        this.history.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DataSourceFromHistory> getProjectDataSources() {
        void $this$filterTo$iv$iv;
        Collection<DataSourceFromHistory> collection = this.history.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataSourceFromHistory it = (DataSourceFromHistory)element$iv$iv;
            boolean bl = false;
            if (!(!it.isRemovedFromProject())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final List<DataSourceFromHistory> getDataSources() {
        Collection<DataSourceFromHistory> collection = this.history.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }
}

