/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.history;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.dataSource.history.ReferencedStateHolderKt;
import com.intellij.database.dataSource.history.StateHolder;
import com.intellij.openapi.project.Project;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/history/ReferencedStateHolder;", "Lcom/intellij/database/dataSource/history/StateHolder;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;)V", "writeStateTo", "", "container", "Lorg/jdom/Element;", "resolveDataSource", "intellij.database.connectivity"})
public final class ReferencedStateHolder
extends StateHolder {
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource dataSource;

    public ReferencedStateHolder(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.project = project;
        this.dataSource = dataSource;
    }

    @Override
    public void writeStateTo(@NotNull Element container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        try {
            JDomWriter serializer = new JDomWriter(container);
            LocalDataSourceSerialization.serialize((Project)this.project, (LocalDataSource)this.dataSource, (HierarchicalStreamWriter)((HierarchicalStreamWriter)serializer), (LocalDataSourceSerialization.SaveMode)LocalDataSourceSerialization.SaveMode.WITHOUT_SCHEMA);
        }
        catch (Throwable e) {
            ReferencedStateHolderKt.access$getLog$p().error("Failed to serialize data source", e);
            throw e;
        }
    }

    @Override
    @NotNull
    public LocalDataSource resolveDataSource() {
        return this.dataSource;
    }
}

