/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.components;

import com.intellij.application.Topics;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.diagram.LazyPsiElementHolder;
import com.intellij.diagram.components.DiagramContainerUi;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DiagramContainerUiImpl
extends DiagramContainerUi {
    @NotNull
    private static final Key<DiagramContainerUi.QuickDocHintHandler> HINT_HANDLER_KEY = Key.create((String)"com.intellij.diagram.components.DiagramContainerUiImpl.HINT_HANDLER_KEY");

    @Override
    public void paintNoBackground(@NotNull JComponent component) {
        if (component == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(0);
        }
        ComponentUtil.putClientProperty((JComponent)component, (Key)IdeBackgroundUtil.NO_BACKGROUND, (Object)true);
    }

    @Override
    public int getShowQuickDocHintDelay() {
        return EditorSettingsExternalizable.getInstance().getTooltipsDelay();
    }

    @Override
    public @NotNull Promise<@Nullable JBPopup> createQuickDocHintFor(@Nullable Object element, @Nullable Consumer<ComponentPopupBuilder> popupCustomizer) {
        PsiElement psiElement = DiagramContainerUiImpl.toReferringPsiElementOrNull(element);
        if (psiElement == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                DiagramContainerUiImpl.$$$reportNull$$$0(1);
            }
            return promise;
        }
        DocumentationManager docManager = DocumentationManager.getInstance((Project)psiElement.getProject());
        MyDocComponent docComponent = new MyDocComponent(docManager);
        AsyncPromise result = new AsyncPromise();
        docManager.queueFetchDocInfo(psiElement, (DocumentationComponent)docComponent).doWhenProcessed(() -> {
            try {
                JBPopup popup = DiagramContainerUiImpl.createDocHintPopup((JComponent)((Object)docComponent), popupCustomizer);
                docComponent.setHint(popup);
                Disposer.register((Disposable)popup, (Disposable)docComponent);
                DiagramContainerUiImpl.setPreferredHintSize(docComponent, popup);
                result.setResult((Object)popup);
            }
            catch (Throwable e) {
                result.setError(e);
            }
        });
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    @Nullable
    private static PsiElement toReferringPsiElementOrNull(@Nullable Object element) {
        if (element instanceof PsiElement) {
            return (PsiElement)element;
        }
        if (element instanceof LazyPsiElementHolder) {
            return ((LazyPsiElementHolder)element).calculatePsiElement();
        }
        return null;
    }

    @NotNull
    private static JBPopup createDocHintPopup(@NotNull JComponent content, @Nullable Consumer<ComponentPopupBuilder> popupCustomizer) {
        if (content == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(3);
        }
        ComponentPopupBuilder popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(content, content).setResizable(true).setMovable(true).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true);
        if (popupCustomizer != null) {
            popupCustomizer.accept(popupBuilder);
        }
        JBPopup jBPopup = popupBuilder.createPopup();
        if (jBPopup == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(4);
        }
        return jBPopup;
    }

    @Override
    public @NotNull Promise<@Nullable JBPopup> createSimpleHtmlTextHint(@Nullable String htmlText, @Nullable Consumer<ComponentPopupBuilder> popupCustomizer) {
        if (htmlText == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                DiagramContainerUiImpl.$$$reportNull$$$0(5);
            }
            return promise;
        }
        JComponent content = DiagramContainerUiImpl.createPopupContentLikeIdeTooltip(htmlText);
        Consumer<ComponentPopupBuilder> popupBuilder = builder -> {
            builder.setResizable(false);
            builder.setBorderColor(JBUI.CurrentTheme.Tooltip.borderColor());
            if (popupCustomizer != null) {
                popupCustomizer.accept((ComponentPopupBuilder)builder);
            }
        };
        JBPopup popup = DiagramContainerUiImpl.createDocHintPopup(content, popupBuilder);
        popup.setSize(content.getPreferredSize());
        Promise promise = Promises.resolvedPromise((Object)popup);
        if (promise == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @NotNull
    private static JComponent createPopupContentLikeIdeTooltip(@NotNull String htmlText) {
        if (htmlText == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(7);
        }
        Color toolTipForegroundColor = UIUtil.getToolTipForeground();
        Color toolTipBackgroundColor = UIUtil.getToolTipBackground();
        JEditorPane text = IdeTooltipManager.initPane((String)htmlText, (HintHint)new HintHint().setAwtTooltip(false), null);
        text.setEditable(false);
        text.setBorder(null);
        JScrollPane scrolledText = ScrollPaneFactory.createScrollPane((Component)text, (boolean)true);
        scrolledText.setForeground(toolTipForegroundColor);
        scrolledText.setBackground(toolTipBackgroundColor);
        scrolledText.getViewport().setBackground(toolTipBackgroundColor);
        JLabel label = new JLabel();
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label.getIconTextGap() * 1.5), (int)((double)label.getIconTextGap() * 1.5)));
        content.add((Component)scrolledText, (Object)"Center");
        content.setBorder(JBUI.Borders.customLine((Color)toolTipBackgroundColor, (int)4));
        content.setBackground(toolTipBackgroundColor);
        NonOpaquePanel nonOpaquePanel = content;
        if (nonOpaquePanel == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(8);
        }
        return nonOpaquePanel;
    }

    private static void setPreferredHintSize(@NotNull MyDocComponent docComponent, @NotNull JBPopup popup) {
        if (docComponent == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(9);
        }
        if (popup == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(10);
        }
        int preferredWidth = docComponent.getPreferredWidth();
        int preferredHeight = docComponent.getPreferredHeight(preferredWidth);
        popup.setSize(new Dimension(preferredWidth - 4, preferredHeight));
    }

    @Override
    public void onQuickDocHintShown(final @NotNull DiagramContainerUi.QuickDocHintHandler hintHandler) {
        if (hintHandler == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(11);
        }
        JBPopup hintPopup = hintHandler.getPopup();
        ComponentUtil.putClientProperty((JComponent)hintPopup.getContent(), HINT_HANDLER_KEY, (Object)hintHandler);
        hintPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                hintHandler.closeHint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/uml/components/DiagramContainerUiImpl$1", "onClosed"));
            }
        });
        Topics.subscribe((Topic)ApplicationActivationListener.TOPIC, (Disposable)hintPopup, (Object)new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    2.$$$reportNull$$$0(0);
                }
                hintHandler.closeHint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/uml/components/DiagramContainerUiImpl$2", "applicationDeactivated"));
            }
        });
        if (!(hintPopup instanceof AbstractPopup)) {
            return;
        }
        Window window = ((AbstractPopup)hintPopup).getPopupWindow();
        if (window == null) {
            return;
        }
        window.setFocusableWindowState(true);
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e.getID() == 501 && e.getSource() == window) {
                hintHandler.onClickInsidePopup();
            } else if (e.getID() == 200 && !DiagramContainerUiImpl.isParentWindow(window, e.getSource())) {
                hintHandler.closeHint();
            }
            return false;
        }, (Disposable)hintPopup);
    }

    private static boolean isParentWindow(@NotNull Window parent, Object potentialChild) {
        if (parent == null) {
            DiagramContainerUiImpl.$$$reportNull$$$0(12);
        }
        return parent == potentialChild || potentialChild instanceof Component && DiagramContainerUiImpl.isParentWindow(parent, ((Component)potentialChild).getParent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/components/DiagramContainerUiImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComponent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/components/DiagramContainerUiImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuickDocHintFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocHintPopup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleHtmlTextHint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupContentLikeIdeTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintNoBackground";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDocHintPopup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPopupContentLikeIdeTooltip";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredHintSize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onQuickDocHintShown";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isParentWindow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }

    private static final class MyDocComponent
    extends DocumentationComponent {
        MyDocComponent(@NotNull DocumentationManager manager) {
            if (manager == null) {
                MyDocComponent.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        protected void showHint() {
            JBPopup popup = this.getHint();
            if (popup != null) {
                DiagramContainerUiImpl.setPreferredHintSize(this, popup);
                DiagramContainerUi.QuickDocHintHandler handler = (DiagramContainerUi.QuickDocHintHandler)ComponentUtil.getClientProperty((JComponent)popup.getContent(), HINT_HANDLER_KEY);
                if (handler != null) {
                    popup.setLocation(handler.getBestLocation());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/uml/components/DiagramContainerUiImpl$MyDocComponent", "<init>"));
        }
    }
}

