/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.rpc.split;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.platform.rpc.split.FleetRdTransportBridge;
import com.intellij.platform.rpc.split.FleetRdTransportBridgeKt;
import com.jetbrains.rd.framework.IdKind;
import com.jetbrains.rd.ide.model.FleetRpcModel;
import com.jetbrains.rd.ide.model.FleetTransportMessage;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ%\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0010R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/rpc/split/FleetRdTransportBridgeManager;", "", "<init>", "()V", "modelBridges", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/rd/ide/model/FleetRpcModel;", "Lcom/intellij/platform/rpc/split/FleetRdTransportBridge;", "startTransportBridging", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "kind", "Lcom/jetbrains/rd/framework/IdKind;", "getOrCreateTransportBridge", "getOrCreateTransportBridge$intellij_platform_rpc_split", "Companion", "intellij.platform.rpc.split"})
@ApiStatus.Internal
public final class FleetRdTransportBridgeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<FleetRpcModel, FleetRdTransportBridge> modelBridges = new ConcurrentHashMap();

    public final void startTransportBridging(@NotNull Lifetime lifetime, @NotNull FleetRpcModel model, @NotNull IdKind kind) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.getOrCreateTransportBridge$intellij_platform_rpc_split(lifetime, model, kind);
    }

    @NotNull
    public final FleetRdTransportBridge getOrCreateTransportBridge$intellij_platform_rpc_split(@NotNull Lifetime lifetime, @NotNull FleetRpcModel model, @NotNull IdKind kind) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        FleetRdTransportBridge bridge = this.modelBridges.get(model);
        if (bridge != null) {
            FleetRdTransportBridgeKt.access$getLOG$p().debug("Transport bridge for model: " + model + " already exists (" + bridge + ")");
            return bridge;
        }
        FleetRdTransportBridgeKt.access$getLOG$p().info("Creating transport bridge for " + model);
        lifetime.onTermination(() -> FleetRdTransportBridgeManager.getOrCreateTransportBridge$lambda$0(this, model));
        Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1 -> TuplesKt.to((Object)model.getIncoming(), (Object)model.getOutgoing());
            case 2 -> TuplesKt.to((Object)model.getOutgoing(), (Object)model.getIncoming());
            default -> throw new NoWhenBranchMatchedException();
        };
        IAsyncSignal incoming = (IAsyncSignal)pair.component1();
        IAsyncSignal outgoing = (IAsyncSignal)pair.component2();
        FleetRdTransportBridge fleetRdTransportBridge = this.modelBridges.computeIfAbsent(model, arg_0 -> FleetRdTransportBridgeManager.getOrCreateTransportBridge$lambda$2(arg_0 -> FleetRdTransportBridgeManager.getOrCreateTransportBridge$lambda$1(lifetime, incoming, outgoing, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fleetRdTransportBridge, (String)"computeIfAbsent(...)");
        FleetRdTransportBridge newBridge = fleetRdTransportBridge;
        return newBridge;
    }

    private static final Unit getOrCreateTransportBridge$lambda$0(FleetRdTransportBridgeManager this$0, FleetRpcModel $model) {
        this$0.modelBridges.remove($model);
        return Unit.INSTANCE;
    }

    private static final FleetRdTransportBridge getOrCreateTransportBridge$lambda$1(Lifetime $lifetime, IAsyncSignal $incoming, IAsyncSignal $outgoing, FleetRpcModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new FleetRdTransportBridge($lifetime, (IAsyncSignal<FleetTransportMessage>)$incoming, (IAsyncSignal<FleetTransportMessage>)$outgoing);
    }

    private static final FleetRdTransportBridge getOrCreateTransportBridge$lambda$2(Function1 $tmp0, Object p0) {
        return (FleetRdTransportBridge)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final FleetRdTransportBridgeManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/rpc/split/FleetRdTransportBridgeManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/rpc/split/FleetRdTransportBridgeManager;", "intellij.platform.rpc.split"})
    @SourceDebugExtension(value={"SMAP\nFleetRdTransportBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetRdTransportBridge.kt\ncom/intellij/platform/rpc/split/FleetRdTransportBridgeManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,106:1\n42#2,3:107\n*S KotlinDebug\n*F\n+ 1 FleetRdTransportBridge.kt\ncom/intellij/platform/rpc/split/FleetRdTransportBridgeManager$Companion\n*L\n67#1:107,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FleetRdTransportBridgeManager getInstance() {
            boolean $i$f$service = false;
            Class<FleetRdTransportBridgeManager> serviceClass$iv = FleetRdTransportBridgeManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (FleetRdTransportBridgeManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IdKind.values().length];
            try {
                nArray[IdKind.Client.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdKind.Server.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

