/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.JoinConditionInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlConvertJoinUsingToOnIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertJoinUsingToOnIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertJoinUsingToOnIntention.kt\ncom/intellij/sql/intentions/SqlConvertJoinUsingToOnIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1924#2,3:46\n*S KotlinDebug\n*F\n+ 1 SqlConvertJoinUsingToOnIntention.kt\ncom/intellij/sql/intentions/SqlConvertJoinUsingToOnIntention\n*L\n31#1:46,3\n*E\n"})
public final class SqlConvertJoinUsingToOnIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.using.with.on", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return JoinUtilsKt.getJoinUsingInfo((PsiElement)element) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JoinConditionInfo joinConditionInfo = JoinUtilsKt.getJoinUsingInfo((PsiElement)element);
        if (joinConditionInfo == null) {
            return;
        }
        JoinConditionInfo info = joinConditionInfo;
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)info.getClause()));
        String joinOp = dialect.getDbms().isClickHouse() ? "all inner join" : "join";
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, (SqlLanguageDialect)dialect).withDialect(dialect.getDatabaseDialect());
        builder.plain("select * from foo " + joinOp + " bar ").keyword("on ");
        Iterable $this$forEachIndexed$iv = info.getColumnRefs();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object object;
            Object columnName;
            void columnRef;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv;
            int i = n;
            boolean bl = false;
            Object object2 = columnRef.getIdentifier();
            if (object2 == null || (object2 = object2.getText()) == null) {
                object2 = columnName = "?";
            }
            if (i > 0) {
                builder.keyword(" and ");
            }
            if ((object = info.getLeftTableRef().getIdentifier()) == null || (object = object.getText()) == null) {
                object = "?";
            }
            builder.plain((String)object + "." + (String)columnName);
            builder.symbol(" = ");
            Object object3 = info.getRightTableRef().getIdentifier();
            if (object3 == null || (object3 = object3.getText()) == null) {
                object3 = "?";
            }
            builder.plain((String)object3 + "." + (String)columnName);
        }
        String string = builder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String queryText = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText((String)queryText, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (Project)project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        SqlQueryExpression queryExpr = sqlQueryExpression;
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)queryExpr), SqlJoinConditionClause.class);
        Intrinsics.checkNotNull((Object)psiElement);
        SqlJoinConditionClause onClause = (SqlJoinConditionClause)psiElement;
        ((SqlUsingClause)info.getClause()).replace((PsiElement)onClause);
    }
}

