/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.GotoFrameSourceAction;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerAction
extends AnAction {
    @Nullable
    public static DebuggerTree getTree(DataContext dataContext) {
        return (DebuggerTree)((Object)DebuggerTree.DATA_KEY.getData(dataContext));
    }

    @Nullable
    public static DebuggerTreePanel getPanel(DataContext dataContext) {
        return (DebuggerTreePanel)DebuggerTreePanel.DATA_KEY.getData(dataContext);
    }

    @Nullable
    public static DebuggerTreeNodeImpl getSelectedNode(DataContext dataContext) {
        DebuggerTree tree = DebuggerAction.getTree(dataContext);
        if (tree == null) {
            return null;
        }
        if (tree.getSelectionCount() != 1) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object component = path.getLastPathComponent();
        if (!(component instanceof DebuggerTreeNodeImpl)) {
            return null;
        }
        return (DebuggerTreeNodeImpl)component;
    }

    public static DebuggerTreeNodeImpl @Nullable [] getSelectedNodes(DataContext dataContext) {
        DebuggerTree tree = DebuggerAction.getTree(dataContext);
        if (tree == null) {
            return null;
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return Holder.EMPTY_TREE_NODE_ARRAY;
        }
        ArrayList<DebuggerTreeNodeImpl> nodes = new ArrayList<DebuggerTreeNodeImpl>(paths.length);
        for (TreePath path : paths) {
            Object component = path.getLastPathComponent();
            if (!(component instanceof DebuggerTreeNodeImpl)) continue;
            nodes.add((DebuggerTreeNodeImpl)component);
        }
        return nodes.toArray(new DebuggerTreeNodeImpl[0]);
    }

    @NotNull
    public static DebuggerContextImpl getDebuggerContext(DataContext dataContext) {
        DebuggerTreePanel panel = DebuggerAction.getPanel(dataContext);
        if (panel != null) {
            DebuggerContextImpl debuggerContextImpl = panel.getContext();
            if (debuggerContextImpl == null) {
                DebuggerAction.$$$reportNull$$$0(0);
            }
            return debuggerContextImpl;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        DebuggerContextImpl debuggerContextImpl = project != null ? DebuggerManagerEx.getInstanceEx(project).getContext() : DebuggerContextImpl.EMPTY_CONTEXT;
        if (debuggerContextImpl == null) {
            DebuggerAction.$$$reportNull$$$0(1);
        }
        return debuggerContextImpl;
    }

    public static Disposable installEditAction(final JTree tree, String actionName) {
        DoubleClickListener listener2 = new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (tree.getPathForLocation(e.getX(), e.getY()) == null) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)tree);
                GotoFrameSourceAction.doAction(dataContext);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/actions/DebuggerAction$1", "onDoubleClick"));
            }
        };
        listener2.installOn((Component)tree);
        Disposable disposable = () -> listener2.uninstall((Component)tree);
        DebuggerUIUtil.registerActionOnComponent((String)actionName, (JComponent)tree, (Disposable)disposable);
        return disposable;
    }

    public static void refreshViews(AnActionEvent e) {
        DebuggerAction.refreshViews(DebuggerUIUtil.getSession((AnActionEvent)e));
    }

    public static void refreshViews(@Nullable XDebugSession session) {
        if (session != null) {
            XDebugProcess process = session.getDebugProcess();
            if (process instanceof JavaDebugProcess) {
                ((JavaDebugProcess)process).saveNodeHistory();
            }
            session.rebuildViews();
        }
    }

    public static boolean isInJavaSession(AnActionEvent e) {
        XDebugSession session = DebuggerUIUtil.getSession((AnActionEvent)e);
        return session != null && session.getDebugProcess() instanceof JavaDebugProcess;
    }

    static JavaStackFrame getStackFrame(AnActionEvent e) {
        StackFrameDescriptorImpl descriptor = DebuggerAction.getSelectedStackFrameDescriptor(e);
        if (descriptor != null) {
            return new JavaStackFrame(descriptor, false);
        }
        return DebuggerAction.getSelectedStackFrame(e);
    }

    static StackFrameProxyImpl getStackFrameProxy(AnActionEvent e) {
        DebuggerTreeNodeImpl node = DebuggerAction.getSelectedNode(e.getDataContext());
        if (node != null) {
            NodeDescriptorImpl descriptor = node.getDescriptor();
            if (descriptor instanceof StackFrameDescriptorImpl) {
                return ((StackFrameDescriptorImpl)descriptor).getFrameProxy();
            }
        } else {
            JavaStackFrame stackFrame = DebuggerAction.getSelectedStackFrame(e);
            if (stackFrame != null) {
                return stackFrame.getStackFrameProxy();
            }
        }
        return null;
    }

    @Nullable
    private static StackFrameDescriptorImpl getSelectedStackFrameDescriptor(AnActionEvent e) {
        NodeDescriptorImpl descriptor;
        DebuggerTreeNodeImpl selectedNode = DebuggerAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null && (descriptor = selectedNode.getDescriptor()) instanceof StackFrameDescriptorImpl) {
            return (StackFrameDescriptorImpl)descriptor;
        }
        return null;
    }

    @Nullable
    private static JavaStackFrame getSelectedStackFrame(AnActionEvent e) {
        XStackFrame frame;
        XDebugSession session;
        Project project = e.getProject();
        if (project != null && (session = DebuggerUIUtil.getSession((AnActionEvent)e)) != null && (frame = session.getCurrentStackFrame()) instanceof JavaStackFrame) {
            return (JavaStackFrame)frame;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/DebuggerAction", "getDebuggerContext"));
    }

    private static class Holder {
        private static final DebuggerTreeNodeImpl[] EMPTY_TREE_NODE_ARRAY = new DebuggerTreeNodeImpl[0];

        private Holder() {
        }
    }
}

