/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.AnonymousClassMethodFilter;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.ClassInstanceMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LambdaAsyncMethodFilter;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class JvmSmartStepIntoHandler {
    public static final ExtensionPointName<JvmSmartStepIntoHandler> EP_NAME = ExtensionPointName.create((String)"com.intellij.debugger.jvmSmartStepIntoHandler");

    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(SourcePosition position) {
        throw new AbstractMethodError();
    }

    @NotNull
    public Promise<List<SmartStepTarget>> findSmartStepTargetsAsync(SourcePosition position, DebuggerSession session) {
        Promise promise = Promises.resolvedPromise(this.findSmartStepTargets(position));
        if (promise == null) {
            JvmSmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        return promise;
    }

    @NotNull
    public Promise<List<SmartStepTarget>> findStepIntoTargets(SourcePosition position, DebuggerSession session) {
        Promise promise = Promises.rejectedPromise();
        if (promise == null) {
            JvmSmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        return promise;
    }

    public abstract boolean isAvailable(SourcePosition var1);

    @Nullable
    protected MethodFilter createMethodFilter(SmartStepTarget stepTarget) {
        return (MethodFilter)ReadAction.compute(() -> JvmSmartStepIntoHandler.createMethodFilterInReadAction(stepTarget));
    }

    @Nullable
    private static MethodFilter createMethodFilterInReadAction(SmartStepTarget stepTarget) {
        if (stepTarget instanceof MethodSmartStepTarget) {
            MethodSmartStepTarget methodSmartStepTarget = (MethodSmartStepTarget)stepTarget;
            PsiMethod method = methodSmartStepTarget.getMethod();
            if (stepTarget.needsBreakpointRequest()) {
                return Registry.is((String)"debugger.async.smart.step.into") && method.getContainingClass() instanceof PsiAnonymousClass ? new ClassInstanceMethodFilter(method, stepTarget.getCallingExpressionLines()) : new AnonymousClassMethodFilter(method, stepTarget.getCallingExpressionLines());
            }
            return new BasicStepMethodFilter(method, methodSmartStepTarget.getOrdinal(), stepTarget.getCallingExpressionLines());
        }
        if (stepTarget instanceof LambdaSmartStepTarget) {
            PsiElement method;
            PsiLambdaExpression lambda;
            PsiElement expressionList;
            LambdaSmartStepTarget lambdaTarget = (LambdaSmartStepTarget)stepTarget;
            LambdaMethodFilter lambdaMethodFilter = new LambdaMethodFilter(lambdaTarget.getLambda(), lambdaTarget.getOrdinal(), stepTarget.getCallingExpressionLines());
            if (Registry.is((String)"debugger.async.smart.step.into") && lambdaTarget.isAsync() && (expressionList = (lambda = ((LambdaSmartStepTarget)stepTarget).getLambda()).getParent()) instanceof PsiExpressionList && (method = expressionList.getParent()) instanceof PsiMethodCallExpression) {
                return new LambdaAsyncMethodFilter(((PsiMethodCallExpression)method).resolveMethod(), LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)expressionList), (PsiElement)lambda), lambdaMethodFilter);
            }
            return lambdaMethodFilter;
        }
        return null;
    }

    protected static List<SmartStepTarget> reorderWithSteppingFilters(List<SmartStepTarget> targets) {
        int firstGood;
        if (targets.size() > 1 && (firstGood = ContainerUtil.indexOf(targets, elem -> !DebugProcessImpl.isClassFiltered(elem.getClassName()))) > 0) {
            targets = ContainerUtil.concat(targets.subList(firstGood, targets.size()), targets.subList(0, firstGood));
        }
        return targets;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/actions/JvmSmartStepIntoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findSmartStepTargetsAsync";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findStepIntoTargets";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    @ApiStatus.Internal
    public static enum SmartStepIntoDetectionStatus {
        SUCCESS,
        NO_TARGETS,
        TARGETS_MISMATCH,
        INTERNAL_ERROR,
        INVALID_POSITION,
        BYTECODE_NOT_AVAILABLE;

    }
}

