/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Range;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaSmartStepTarget
extends SmartStepTarget {
    private final PsiLambdaExpression myLambda;
    private final int myOrdinal;
    private final boolean myAsync;

    public LambdaSmartStepTarget(@NotNull PsiLambdaExpression lambda, @Nullable String label, @Nullable PsiElement highlightElement, int ordinal, Range<Integer> lines, boolean async) {
        if (lambda == null) {
            LambdaSmartStepTarget.$$$reportNull$$$0(0);
        }
        super(label, highlightElement, true, lines);
        this.myLambda = lambda;
        this.myOrdinal = ordinal;
        this.myAsync = async;
    }

    public PsiLambdaExpression getLambda() {
        return this.myLambda;
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    public boolean isAsync() {
        return this.myAsync;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myLambda.getIcon(0);
    }

    @Override
    @NotNull
    public String getPresentation() {
        String typeText = PsiFormatUtil.formatType((PsiType)this.myLambda.getType(), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        String label = this.getLabel();
        Object object = label != null ? label + typeText : typeText;
        if (object == null) {
            LambdaSmartStepTarget.$$$reportNull$$$0(1);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/LambdaSmartStepTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/LambdaSmartStepTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

