/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.Location;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class StepOutOfBlockActionUtils {
    private static void doStepOutOfBlock(@NotNull XDebugSession xSession) {
        XDebugProcess process;
        if (xSession == null) {
            StepOutOfBlockActionUtils.$$$reportNull$$$0(0);
        }
        if ((process = xSession.getDebugProcess()) instanceof JavaDebugProcess) {
            PsiElement parent;
            PsiElement element;
            PsiElement block;
            DebuggerContextImpl debuggerContext = ((JavaDebugProcess)process).getDebuggerSession().getContextManager().getContext();
            DebuggerSession session = debuggerContext.getDebuggerSession();
            SourcePosition position = debuggerContext.getSourcePosition();
            if (position != null && session != null && (block = PsiTreeUtil.getParentOfType((PsiElement)(element = position.getElementAt()), (Class[])new Class[]{PsiCodeBlock.class, PsiLambdaExpression.class})) instanceof PsiCodeBlock && !((parent = block.getParent()) instanceof PsiMethod) && !(parent instanceof PsiLambdaExpression)) {
                TextRange textRange = block.getTextRange();
                Document document = FileDocumentManager.getInstance().getDocument(position.getFile().getVirtualFile());
                if (document != null) {
                    int startLine = document.getLineNumber(textRange.getStartOffset());
                    int endLine = document.getLineNumber(textRange.getEndOffset());
                    session.sessionResumed();
                    session.stepOver(false, new BlockFilter(startLine, endLine), -2);
                    return;
                }
            }
        }
        xSession.stepOut();
    }

    @ApiStatus.Internal
    public static void stepOutOfBlock(@NotNull XDebugSession xSession) {
        if (xSession == null) {
            StepOutOfBlockActionUtils.$$$reportNull$$$0(1);
        }
        StepOutOfBlockActionUtils.doStepOutOfBlock(xSession);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "xSession";
        objectArray2[1] = "com/intellij/debugger/actions/StepOutOfBlockActionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doStepOutOfBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "stepOutOfBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class BlockFilter
    implements MethodFilter {
        private final Range<Integer> myLines;

        private BlockFilter(int startLine, int endLine) {
            this.myLines = new Range((Comparable)Integer.valueOf(startLine), (Comparable)Integer.valueOf(endLine));
        }

        @Override
        public boolean locationMatches(DebugProcessImpl process, Location location) {
            return false;
        }

        @Override
        @NotNull
        public Range<Integer> getCallingExpressionLines() {
            Range<Integer> range = this.myLines;
            if (range == null) {
                BlockFilter.$$$reportNull$$$0(0);
            }
            return range;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/StepOutOfBlockActionUtils$BlockFilter", "getCallingExpressionLines"));
        }
    }
}

