/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.PlaceInDocument;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleMethodBreakpointAction
extends AnAction
implements ActionRemoteBehaviorSpecification.Disabled {
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ToggleMethodBreakpointAction.$$$reportNull$$$0(0);
        }
        boolean toEnable = ToggleMethodBreakpointAction.getPlace(event) != null;
        event.getPresentation().setEnabled(toEnable);
        if (event.isFromContextMenu()) {
            event.getPresentation().setVisible(toEnable);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleMethodBreakpointAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleMethodBreakpointAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        DebuggerManagerEx debugManager = DebuggerManagerEx.getInstanceEx(project);
        BreakpointManager manager = debugManager.getBreakpointManager();
        PlaceInDocument place2 = ToggleMethodBreakpointAction.getPlace(e);
        if (place2 != null && DocumentUtil.isValidOffset((int)place2.getOffset(), (Document)place2.getDocument())) {
            MethodBreakpoint breakpoint = manager.findBreakpoint(place2.getDocument(), place2.getOffset(), MethodBreakpoint.CATEGORY);
            if (breakpoint == null) {
                manager.addMethodBreakpoint(place2.getDocument(), place2.getDocument().getLineNumber(place2.getOffset()));
            } else {
                manager.removeBreakpoint(breakpoint);
            }
        }
    }

    @Nullable
    private static PlaceInDocument getPlace(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        PsiElement method = null;
        Document document = null;
        if ("ProjectViewPopup".equals(event.getPlace()) || "StructureViewPopup".equals(event.getPlace()) || "BookmarksPopup".equals(event.getPlace()) || "NavBar".equals(event.getPlace())) {
            PsiFile containingFile;
            PsiElement psiElement = (PsiElement)event.getData(CommonDataKeys.PSI_ELEMENT);
            if (psiElement instanceof PsiMethod && (containingFile = psiElement.getContainingFile()) != null) {
                method = psiElement;
                document = containingFile.getViewProvider().getDocument();
            }
        } else {
            Editor editor = ToggleMethodBreakpointAction.getEditor(event);
            if (editor != null) {
                document = editor.getDocument();
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                if (file != null) {
                    FileType fileType;
                    VirtualFile virtualFile = file.getVirtualFile();
                    FileType fileType2 = fileType = virtualFile != null ? virtualFile.getFileType() : null;
                    if (JavaFileType.INSTANCE == fileType || JavaClassFileType.INSTANCE == fileType) {
                        method = ToggleMethodBreakpointAction.findMethod(project, editor);
                    }
                }
            }
        }
        return method != null ? new PlaceInDocument(document, method.getTextOffset()) : null;
    }

    @Nullable
    static Editor getEditor(AnActionEvent event) {
        @Nullable FileEditor editor = (FileEditor)event.getData(PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR);
        return editor instanceof TextEditor ? ((TextEditor)editor).getEditor() : null;
    }

    @Nullable
    private static PsiMethod findMethod(Project project, Editor editor) {
        if (editor == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        int offset = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)editor.getCaretModel().getOffset(), (String)" \t");
        return DebuggerUtilsEx.findPsiMethod(psiFile, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/ToggleMethodBreakpointAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/ToggleMethodBreakpointAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

