/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.codeinsight;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.codeinsight.ControlExceptionBreakpointSupport;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/debugger/codeinsight/ControlExceptionBreakpointJVMSupport;", "Lcom/intellij/xdebugger/codeinsight/ControlExceptionBreakpointSupport;", "<init>", "()V", "findClassReference", "Lcom/intellij/psi/PsiClass;", "psiElement", "Lcom/intellij/psi/PsiElement;", "findExceptionReference", "Lcom/intellij/xdebugger/codeinsight/ControlExceptionBreakpointSupport$ExceptionReference;", "project", "Lcom/intellij/openapi/project/Project;", "element", "JVMExceptionReference", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nControlExceptionBreakpointJVMSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlExceptionBreakpointJVMSupport.kt\ncom/intellij/debugger/codeinsight/ControlExceptionBreakpointJVMSupport\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1342#2:94\n1343#2:96\n1#3:95\n*S KotlinDebug\n*F\n+ 1 ControlExceptionBreakpointJVMSupport.kt\ncom/intellij/debugger/codeinsight/ControlExceptionBreakpointJVMSupport\n*L\n30#1:94\n30#1:96\n*E\n"})
public class ControlExceptionBreakpointJVMSupport
implements ControlExceptionBreakpointSupport {
    @Nullable
    protected final PsiClass findClassReference(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Sequence $this$forEach$iv = PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)true);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiClassType thrownType;
            UElement uastParent;
            PsiElement parent = (PsiElement)element$iv;
            boolean bl = false;
            if (UastContextKt.toUElement((PsiElement)parent) == null) continue;
            UElement uElement = uastParent;
            if (uElement instanceof UReferenceExpression) {
                PsiElement resolved = ((UReferenceExpression)uastParent).resolve();
                PsiElement psiElement2 = resolved;
                return psiElement2 instanceof PsiClass ? (PsiClass)resolved : (psiElement2 instanceof PsiMethod ? (((PsiMethod)resolved).isConstructor() ? ((PsiMethod)resolved).getContainingClass() : null) : null);
            }
            if (uElement instanceof UClass) {
                UElement clazzIdentifier;
                UIdentifier uastIdentifier;
                PsiClass clazz = ((UClass)uastParent).getJavaPsi();
                UElement uElement2 = UastContextKt.toUElement((PsiElement)psiElement);
                UIdentifier uIdentifier = uastIdentifier = uElement2 instanceof UIdentifier ? (UIdentifier)uElement2 : null;
                if (uastIdentifier == null || !Intrinsics.areEqual((Object)uastIdentifier.getName(), (Object)clazz.getName())) {
                    return null;
                }
                UElement uElement3 = ((UClass)uastParent).getUastAnchor();
                if (uElement3 != null && (uElement3 = uElement3.getSourcePsi()) != null) {
                    UElement uElement4;
                    UElement it = uElement4 = uElement3;
                    boolean bl2 = false;
                    v2 = Intrinsics.areEqual((Object)it.getText(), (Object)clazz.getName()) ? uElement4 : null;
                } else {
                    v2 = clazzIdentifier = null;
                }
                if (clazzIdentifier != null && !Intrinsics.areEqual((Object)psiElement, clazzIdentifier)) {
                    return null;
                }
                return clazz;
            }
            if (!(uElement instanceof UThrowExpression)) continue;
            PsiType psiType = ((UThrowExpression)uastParent).getThrownExpression().getExpressionType();
            PsiClassType psiClassType = thrownType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            return psiClassType != null ? psiClassType.resolve() : null;
        }
        return null;
    }

    @Nullable
    public ControlExceptionBreakpointSupport.ExceptionReference findExceptionReference(@NotNull Project project, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiClass psiClass = this.findClassReference(element);
        if (psiClass == null) {
            return null;
        }
        PsiClass clazz = psiClass;
        if (!InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.lang.Throwable")) {
            return null;
        }
        String string = clazz.getQualifiedName();
        if (string == null) {
            return null;
        }
        String qualifiedName = string;
        String string2 = clazz.getName();
        if (string2 == null) {
            string2 = qualifiedName;
        }
        String displayName = string2;
        return new JVMExceptionReference(qualifiedName, displayName);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/debugger/codeinsight/ControlExceptionBreakpointJVMSupport$JVMExceptionReference;", "Lcom/intellij/xdebugger/codeinsight/ControlExceptionBreakpointSupport$ExceptionReference;", "qualifiedName", "", "displayName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "findExistingBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "createBreakpoint", "intellij.java.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nControlExceptionBreakpointJVMSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlExceptionBreakpointJVMSupport.kt\ncom/intellij/debugger/codeinsight/ControlExceptionBreakpointJVMSupport$JVMExceptionReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n296#2,2:94\n*S KotlinDebug\n*F\n+ 1 ControlExceptionBreakpointJVMSupport.kt\ncom/intellij/debugger/codeinsight/ControlExceptionBreakpointJVMSupport$JVMExceptionReference\n*L\n85#1:94,2\n*E\n"})
    public static class JVMExceptionReference
    implements ControlExceptionBreakpointSupport.ExceptionReference {
        @NotNull
        private final String qualifiedName;
        @NotNull
        private final String displayName;

        public JVMExceptionReference(@NotNull String qualifiedName, @NotNull String displayName) {
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            this.qualifiedName = qualifiedName;
            this.displayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Nullable
        public XBreakpoint<?> findExistingBreakpoint(@NotNull Project project) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Collection collection = XDebuggerManager.getInstance((Project)project).getBreakpointManager().getBreakpoints(JavaExceptionBreakpointType.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBreakpoints(...)");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    XBreakpoint it = (XBreakpoint)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((JavaExceptionBreakpointProperties)it.getProperties()).myQualifiedName, (Object)this.qualifiedName)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        @Nullable
        public XBreakpoint<?> createBreakpoint(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExceptionBreakpoint exceptionBreakpoint = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager().addExceptionBreakpoint(this.qualifiedName);
            return exceptionBreakpoint != null ? exceptionBreakpoint.getXBreakpoint() : null;
        }
    }
}

