/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebuggerDispatchedCommandProvider;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/debugger/engine/DebuggerThreadDispatcher;", "Lkotlinx/coroutines/CoroutineDispatcher;", "managerThread", "Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl;", "<init>", "(Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl;)V", "dispatchedCommandsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "hasDispatchedCommands", "", "hasDispatchedCommands$intellij_java_debugger_impl", "dispatch", "", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "createCommand", "Lcom/intellij/debugger/engine/events/DebuggerCommandImpl;", "intellij.java.debugger.impl"})
public final class DebuggerThreadDispatcher
extends CoroutineDispatcher {
    @NotNull
    private final DebuggerManagerThreadImpl managerThread;
    @NotNull
    private final AtomicInteger dispatchedCommandsCounter;

    public DebuggerThreadDispatcher(@NotNull DebuggerManagerThreadImpl managerThread) {
        Intrinsics.checkNotNullParameter((Object)managerThread, (String)"managerThread");
        this.managerThread = managerThread;
        this.dispatchedCommandsCounter = new AtomicInteger();
    }

    public final boolean hasDispatchedCommands$intellij_java_debugger_impl() {
        return this.dispatchedCommandsCounter.get() > 0;
    }

    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        DebuggerCommandImpl debuggerCommand = this.createCommand(context, block);
        Job job = (Job)context.get((CoroutineContext.Key)Job.Key);
        if (job != null) {
            this.dispatchedCommandsCounter.incrementAndGet();
            job.invokeOnCompletion(arg_0 -> DebuggerThreadDispatcher.dispatch$lambda$0(this, arg_0));
        }
        this.managerThread.schedule(debuggerCommand);
    }

    private final DebuggerCommandImpl createCommand(CoroutineContext context, Runnable block) {
        DebuggerDispatchedCommandProvider debuggerDispatchedCommandProvider = (DebuggerDispatchedCommandProvider)context.get((CoroutineContext.Key)DebuggerDispatchedCommandProvider.Key);
        if (debuggerDispatchedCommandProvider == null) {
            throw new IllegalStateException(("No " + DebuggerDispatchedCommandProvider.Key + " in context").toString());
        }
        DebuggerDispatchedCommandProvider provider = debuggerDispatchedCommandProvider;
        return provider.createDebuggerCommand(block, (Function0<Unit>)((Function0)() -> DebuggerThreadDispatcher.createCommand$lambda$0(context, block)));
    }

    private static final Unit dispatch$lambda$0(DebuggerThreadDispatcher this$0, Throwable it) {
        this$0.dispatchedCommandsCounter.decrementAndGet();
        return Unit.INSTANCE;
    }

    private static final Unit createCommand$lambda$0(CoroutineContext $context, Runnable $block) {
        JobKt.cancel$default((CoroutineContext)$context, null, (int)1, null);
        $block.run();
        return Unit.INSTANCE;
    }
}

