/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.InvocationResult;
import com.intellij.debugger.engine.MethodInvokeUtils;
import com.intellij.debugger.engine.MethodInvokeUtilsKt;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.debugger.MethodInvoker;
import com.intellij.util.BitUtil;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.jetbrains.jdi.ArrayReferenceImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001aJ\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0018H\u0002\"2\u0010\u0000\u001a&\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002 \u0003*\u0012\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"ORIGINS_FOR_USE_WITH_HELPER", "Ljava/util/EnumSet;", "Lcom/intellij/xdebugger/impl/evaluate/XEvaluationOrigin;", "kotlin.jvm.PlatformType", "shouldUseHelper", "", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "tryInvokeWithHelper", "Lcom/intellij/debugger/engine/InvocationResult;", "type", "Lcom/sun/jdi/ReferenceType;", "objRef", "Lcom/sun/jdi/ObjectReference;", "method", "Lcom/sun/jdi/Method;", "originalArgs", "", "Lcom/sun/jdi/Value;", "evaluationContext", "invocationOptions", "", "internalEvaluate", "HELPER_FRAMES", "", "", "isHelperFrame", "frame", "INVOCATION_FAILED", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nMethodInvokeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodInvokeUtils.kt\ncom/intellij/debugger/engine/MethodInvokeUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,206:1\n1#2:207\n13#3:208\n1586#4:209\n1661#4,3:210\n1807#4,3:217\n1276#5,2:213\n37#6,2:215\n*S KotlinDebug\n*F\n+ 1 MethodInvokeUtils.kt\ncom/intellij/debugger/engine/MethodInvokeUtilsKt\n*L\n136#1:208\n147#1:209\n147#1:210,3\n200#1:217,3\n184#1:213,2\n191#1:215,2\n*E\n"})
public final class MethodInvokeUtilsKt {
    private static final EnumSet<XEvaluationOrigin> ORIGINS_FOR_USE_WITH_HELPER = EnumSet.of((Enum)XEvaluationOrigin.DIALOG, (Enum)XEvaluationOrigin.INLINE, (Enum)XEvaluationOrigin.EDITOR, (Enum)XEvaluationOrigin.BREAKPOINT_LOG);
    @NotNull
    private static final Set<String> HELPER_FRAMES;
    @NotNull
    private static final InvocationResult INVOCATION_FAILED;

    private static final boolean shouldUseHelper(EvaluationContextImpl $this$shouldUseHelper) {
        String string = Registry.Companion.get("debugger.evaluate.method.helper").getSelectedOption();
        return Intrinsics.areEqual((Object)string, (Object)"off") ? false : (Intrinsics.areEqual((Object)string, (Object)"always") ? true : ORIGINS_FOR_USE_WITH_HELPER.contains(XEvaluationOrigin.Companion.getOrigin((UserDataHolder)$this$shouldUseHelper)) || Intrinsics.areEqual((Object)$this$shouldUseHelper.getUserData(MethodInvokeUtils.getINVOKE_WITH_HELPER_KEY$intellij_java_debugger_impl()), (Object)true));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final InvocationResult tryInvokeWithHelper(@NotNull ReferenceType type, @Nullable ObjectReference objRef, @NotNull Method method, @NotNull List<? extends Value> originalArgs, @NotNull EvaluationContextImpl evaluationContext, int invocationOptions, boolean internalEvaluate) throws EvaluateException {
        String it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(originalArgs, (String)"originalArgs");
        Intrinsics.checkNotNullParameter((Object)((Object)evaluationContext), (String)"evaluationContext");
        if (internalEvaluate || !MethodInvokeUtilsKt.shouldUseHelper(evaluationContext) || BitUtil.isSet((int)invocationOptions, (int)2) || DebuggerUtils.isPrimitiveType((String)method.returnTypeName()) || DebuggerUtilsEx.isVoid(method) && !method.isConstructor() || Intrinsics.areEqual((Object)"clone", (Object)method.name())) {
            return INVOCATION_FAILED;
        }
        ReferenceType methodDeclaringType = method.declaringType();
        if (!DebuggerUtilsImpl.instanceOf(type, methodDeclaringType)) {
            boolean $i$a$-require-MethodInvokeUtilsKt$tryInvokeWithHelper$32 = false;
            String $i$a$-require-MethodInvokeUtilsKt$tryInvokeWithHelper$32 = "Invalid method";
            throw new IllegalArgumentException($i$a$-require-MethodInvokeUtilsKt$tryInvokeWithHelper$32.toString());
        }
        if (objRef != null && !DebuggerUtilsImpl.instanceOf(objRef.referenceType(), methodDeclaringType)) {
            boolean $i$a$-require-MethodInvokeUtilsKt$tryInvokeWithHelper$42 = false;
            String $i$a$-require-MethodInvokeUtilsKt$tryInvokeWithHelper$42 = "Invalid method";
            throw new IllegalArgumentException($i$a$-require-MethodInvokeUtilsKt$tryInvokeWithHelper$42.toString());
        }
        if (method.name().equals("forName") && Intrinsics.areEqual((Object)methodDeclaringType.name(), (Object)"java.lang.Class")) {
            return INVOCATION_FAILED;
        }
        DebugProcessImpl debugProcessImpl = evaluationContext.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)debugProcessImpl), (String)"getDebugProcess(...)");
        DebugProcessImpl debugProcess = debugProcessImpl;
        List invokerArgs = new ArrayList();
        ObjectReference implLookup = MethodInvokeUtils.INSTANCE.getMethodHandlesImplLookup(evaluationContext);
        if (implLookup == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(MethodInvokeUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot get MethodHandles.Lookup.IMPL_LOOKUP, java version " + evaluationContext.getVirtualMachineProxy().version());
            return INVOCATION_FAILED;
        }
        invokerArgs.add(implLookup);
        invokerArgs.add(type.classObject());
        invokerArgs.add(objRef);
        invokerArgs.add(DebuggerUtilsEx.mirrorOfString(method.name() + ";" + method.signature(), evaluationContext));
        invokerArgs.add(methodDeclaringType.classLoader());
        Iterable $this$map$iv = originalArgs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Value value = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Value)BoxingEvaluator.box(it, evaluationContext));
        }
        List boxedArgs = (List)destination$iv$iv;
        Object helperMethodName = "invoke";
        if (boxedArgs.size() > 10) {
            ReferenceType referenceType = debugProcess.findClass(evaluationContext, "java.lang.Object[]", evaluationContext.getClassLoader());
            Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ArrayType");
            ArrayType objectArrayClass = (ArrayType)referenceType;
            v3 = invokerArgs.add(DebuggerUtilsEx.mirrorOfArray(objectArrayClass, boxedArgs, (EvaluationContext)evaluationContext));
        } else {
            helperMethodName = "invoke" + boxedArgs.size();
            v3 = invokerArgs.addAll(boxedArgs);
        }
        try {
            Value value = DebuggerUtilsImpl.invokeHelperMethod(evaluationContext, MethodInvoker.class, (String)helperMethodName, invokerArgs, false, new String[0]);
            if (value instanceof ArrayReference) {
                Value wrapper = value;
                if ((value = ((ArrayReference)value).getValue(0)) instanceof ObjectReference) {
                    evaluationContext.getSuspendContext().keepAsync((ObjectReference)value);
                    if (DebuggerUtilsAsync.isAsyncEnabled() && wrapper instanceof ArrayReferenceImpl) {
                        ((ArrayReferenceImpl)wrapper).setFirstElementToNull();
                    } else {
                        ((ArrayReference)wrapper).setValue(0, null);
                    }
                }
            }
            return new InvocationResult(true, value);
        }
        catch (Exception e) {
            boolean bl;
            Iterator iterator;
            String helperExceptionStackTrace = MethodInvokeUtils.INSTANCE.getHelperExceptionStackTrace(evaluationContext, e);
            String methodCallString = method.name() + "(";
            String string = helperExceptionStackTrace;
            if (string != null && (string = StringsKt.lineSequence((CharSequence)string)) != null && (string = SequencesKt.filterNot((Sequence)string, (Function1)tryInvokeWithHelper.3.INSTANCE)) != null) {
                boolean bl2;
                block22: {
                    String $this$any$iv = string;
                    boolean $i$f$any = false;
                    iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        String it2 = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)it2, (CharSequence)methodCallString, (boolean)false, (int)2, null)) continue;
                        bl2 = true;
                        break block22;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            if (bl) {
                throw e;
            }
            if (e instanceof EvaluateException && e.getCause() instanceof IncompatibleThreadStateException) {
                throw e;
            }
            if (ApplicationManager.getApplication().isInternal()) {
                Iterator iterator2;
                String string2 = helperExceptionStackTrace;
                if (string2 != null) {
                    it = string2;
                    boolean bl4 = false;
                    Iterator $this$tryInvokeWithHelper_u24lambda_u244_u240 = iterator = new Attachment("helper_stack.txt", it);
                    boolean bl5 = false;
                    $this$tryInvokeWithHelper_u24lambda_u244_u240.setIncluded(true);
                    iterator2 = iterator;
                } else {
                    iterator2 = null;
                }
                Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull(iterator2);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Attachment[] attachments = thisCollection$iv.toArray(new Attachment[0]);
                DebuggerUtilsImpl.logError("Exception from helper (while evaluating " + methodDeclaringType.name() + "." + method.name() + "): " + e.getMessage(), (Throwable)new RuntimeExceptionWithAttachments((Throwable)e, Arrays.copyOf(attachments, attachments.length)));
            }
            return INVOCATION_FAILED;
        }
    }

    private static final boolean isHelperFrame(String frame) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = HELPER_FRAMES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)frame, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$isHelperFrame(String frame) {
        return MethodInvokeUtilsKt.isHelperFrame(frame);
    }

    static {
        Object[] objectArray = new String[]{Reflection.getOrCreateKotlinClass(MethodInvoker.class).getQualifiedName() + ".invoke", "java.lang.invoke.MethodHandle.invoke"};
        HELPER_FRAMES = SetsKt.setOf((Object[])objectArray);
        INVOCATION_FAILED = new InvocationResult(false, null);
    }
}

