/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist.java;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.jvm.problems.ArrayIndexProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.ArrayStoreProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.ClassCastProblem;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaListener;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.impl.dfaassist.DfaHint;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaDebuggerDfaListener
implements JavaDfaListener,
DebuggerDfaListener {
    private static final TokenSet BOOLEAN_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.ANDAND, JavaTokenType.OROR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.OR, JavaTokenType.EQEQ, JavaTokenType.NE});
    private final Map<PsiElement, DfaHint> myHints = new HashMap<PsiElement, DfaHint>();

    JavaDebuggerDfaListener() {
    }

    private void addHint(@NotNull PsiElement element, @Nullable DfaHint hint) {
        if (element == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(0);
        }
        if (hint != null) {
            this.myHints.merge(element, hint, DfaHint::merge);
        }
    }

    public void beforeExpressionPush(@NotNull DfaValue value, @NotNull PsiExpression expression, @NotNull DfaMemoryState state) {
        if (value == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(2);
        }
        if (state == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(3);
        }
        if (!JavaDebuggerDfaListener.shouldTrackExpressionValue(expression)) {
            return;
        }
        DfaHint hint = DfaHint.ANY_VALUE;
        DfType dfType = state.getDfType(value);
        if (dfType == DfTypes.TRUE) {
            hint = DfaHint.TRUE;
        } else if (dfType == DfTypes.FALSE) {
            hint = DfaHint.FALSE;
        } else if (dfType == DfType.FAIL) {
            hint = DfaHint.FAIL;
        }
        this.addHint((PsiElement)expression, hint);
    }

    public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
        NullabilityProblemKind.NullabilityProblem npeProblem;
        PsiExpression expression;
        if (problem == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(4);
        }
        if (value == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(5);
        }
        if (failed == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(6);
        }
        if (state == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(7);
        }
        if (problem instanceof ArrayStoreProblem) {
            this.addHint((PsiElement)((PsiAssignmentExpression)((ArrayStoreProblem)problem).getAnchor()).getLExpression(), failed == ThreeState.YES ? DfaHint.ASE : DfaHint.NONE);
        } else if (problem instanceof ArrayIndexProblem) {
            PsiArrayAccessExpression anchor = (PsiArrayAccessExpression)((ArrayIndexProblem)problem).getAnchor();
            this.addHint(anchor.getLastChild(), failed == ThreeState.YES ? DfaHint.AIOOBE : DfaHint.NONE);
        } else if (problem instanceof ClassCastProblem) {
            this.addHint(((ClassCastProblem)problem).getAnchor(), failed == ThreeState.YES ? DfaHint.CCE : DfaHint.NONE);
        } else if (problem instanceof NullabilityProblemKind.NullabilityProblem && (expression = (npeProblem = (NullabilityProblemKind.NullabilityProblem)problem).getDereferencedExpression()) != null && npeProblem.thrownException() != null) {
            DfaHint hint = failed == ThreeState.YES ? (npeProblem.thrownException().equals("java.lang.NullPointerException") ? DfaHint.NPE : DfaHint.NULL_AS_NOT_NULL) : DfaHint.NONE;
            this.addHint((PsiElement)expression, hint);
        }
    }

    private static boolean shouldTrackExpressionValue(@NotNull PsiExpression expr) {
        PsiExpression firstOperand;
        IElementType tokenType;
        if (expr == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(8);
        }
        if (BoolUtils.isNegated((PsiExpression)expr)) {
            return false;
        }
        if (expr instanceof PsiAssignmentExpression) {
            return false;
        }
        return !(expr instanceof PsiPolyadicExpression) || !BOOLEAN_TOKENS.contains(tokenType = ((PsiPolyadicExpression)expr).getOperationTokenType()) || (firstOperand = ((PsiPolyadicExpression)expr).getOperands()[0]) == null || !PsiTypes.booleanType().equals((Object)firstOperand.getType());
    }

    void cleanup() {
        this.myHints.entrySet().removeIf(e -> {
            PsiElement anchor = (PsiElement)e.getKey();
            DfaHint hint = (DfaHint)e.getValue();
            if (hint.getTitle() == null) {
                return true;
            }
            if (!(anchor instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expr = (PsiExpression)anchor;
            CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult((PsiElement)expr);
            return result != null && result.getExpressionValues(expr).size() == 1;
        });
    }

    @Override
    @NotNull
    public Map<PsiElement, DfaHint> computeHints() {
        this.cleanup();
        Map<PsiElement, DfaHint> map2 = Collections.unmodifiableMap(this.myHints);
        if (map2 == null) {
            JavaDebuggerDfaListener.$$$reportNull$$$0(9);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failed";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/dfaassist/java/JavaDebuggerDfaListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/dfaassist/java/JavaDebuggerDfaListener";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addHint";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeExpressionPush";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onCondition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldTrackExpressionValue";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

