/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.evaluation.AdditionalContextElement;
import com.intellij.debugger.engine.evaluation.AdditionalContextProvider;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkedObjectAdditionalContextProvider
implements AdditionalContextProvider {
    MarkedObjectAdditionalContextProvider() {
    }

    @NotNull
    public List<AdditionalContextElement> getAdditionalContextElements(@NotNull Project project, @Nullable PsiElement context) {
        JavaDebugProcess javaDebugProcess;
        if (project == null) {
            MarkedObjectAdditionalContextProvider.$$$reportNull$$$0(0);
        }
        XDebugSession xSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        XValueMarkers<?, ?> xValueMarkers = null;
        if (xSession instanceof XDebugSessionImpl) {
            XDebugSessionImpl session = (XDebugSessionImpl)xSession;
            xValueMarkers = session.getValueMarkers();
        } else if (ApplicationManager.getApplication().isUnitTestMode() && (javaDebugProcess = (JavaDebugProcess)XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaDebugProcess.class).stream().findFirst().orElse(null)) != null) {
            xValueMarkers = DebuggerUtilsImpl.getValueMarkers(javaDebugProcess.getDebuggerSession().getProcess());
        }
        if (xValueMarkers == null) {
            List<AdditionalContextElement> list = Collections.emptyList();
            if (list == null) {
                MarkedObjectAdditionalContextProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Map markers = xValueMarkers.getAllMarkers();
        if (markers.isEmpty()) {
            List<AdditionalContextElement> list = Collections.emptyList();
            if (list == null) {
                MarkedObjectAdditionalContextProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<AdditionalContextElement> list = MarkedObjectAdditionalContextProvider.collectMarkedValues(markers);
        if (list == null) {
            MarkedObjectAdditionalContextProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static List<AdditionalContextElement> collectMarkedValues(Map<?, ValueMarkup> markers) {
        ArrayList<AdditionalContextElement> result = new ArrayList<AdditionalContextElement>();
        for (Map.Entry<?, ValueMarkup> entry : markers.entrySet()) {
            ObjectReference objectRef = (ObjectReference)entry.getKey();
            ValueMarkup markup = entry.getValue();
            Object labelName = markup.getText();
            if (!StringUtil.isJavaIdentifier((String)labelName)) continue;
            try {
                labelName = (String)labelName + "_DebugLabel";
                Type type = objectRef.type();
                result.add(new AdditionalContextElement((String)labelName, type.signature(), type.name(), null, __ -> objectRef));
            }
            catch (ObjectCollectedException objectCollectedException) {}
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/MarkedObjectAdditionalContextProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/MarkedObjectAdditionalContextProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalContextElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalContextElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

