/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableValue;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

class ArrayAccessEvaluator
implements ModifiableEvaluator {
    private final Evaluator myArrayReferenceEvaluator;
    private final Evaluator myIndexEvaluator;
    @Deprecated
    private ArrayReference myEvaluatedArrayReference;
    @Deprecated
    private int myEvaluatedIndex;

    ArrayAccessEvaluator(Evaluator arrayReferenceEvaluator, Evaluator indexEvaluator) {
        this.myArrayReferenceEvaluator = arrayReferenceEvaluator;
        this.myIndexEvaluator = indexEvaluator;
    }

    @Override
    @NotNull
    public ModifiableValue evaluateModifiable(EvaluationContextImpl context) throws EvaluateException {
        Object object = this.myArrayReferenceEvaluator.evaluate(context);
        if (!(object instanceof ArrayReference)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.array.reference.expected", (Object[])new Object[0]));
        }
        ArrayReference evaluatedArrayReference = (ArrayReference)object;
        Value indexValue = (Value)this.myIndexEvaluator.evaluate(context);
        if (!DebuggerUtils.isInteger((Value)indexValue)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.invalid.index.expression", (Object[])new Object[0]));
        }
        int evaluatedIndex = ((PrimitiveValue)indexValue).intValue();
        try {
            Value value = evaluatedArrayReference.getValue(evaluatedIndex);
            this.myEvaluatedArrayReference = evaluatedArrayReference;
            this.myEvaluatedIndex = evaluatedIndex;
            return new ModifiableValue(value, new MyModifier(evaluatedArrayReference, evaluatedIndex));
        }
        catch (Exception e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    @Override
    public Modifier getModifier() {
        if (this.myEvaluatedArrayReference != null) {
            return new MyModifier(this.myEvaluatedArrayReference, this.myEvaluatedIndex);
        }
        return null;
    }

    private static class MyModifier
    implements Modifier {
        private final ArrayReference myEvaluatedArrayReference;
        private final int myEvaluatedIndex;

        private MyModifier(ArrayReference evaluatedArrayReference, int evaluatedIndex) {
            this.myEvaluatedArrayReference = evaluatedArrayReference;
            this.myEvaluatedIndex = evaluatedIndex;
        }

        public boolean canInspect() {
            return true;
        }

        public boolean canSetValue() {
            return true;
        }

        public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
            this.myEvaluatedArrayReference.setValue(this.myEvaluatedIndex, value);
        }

        public Type getExpectedType() throws EvaluateException {
            try {
                ArrayType type = (ArrayType)this.myEvaluatedArrayReference.referenceType();
                return type.componentType();
            }
            catch (ClassNotLoadedException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }

        public NodeDescriptorImpl getInspectItem(Project project) {
            return new ArrayElementDescriptorImpl(project, this.myEvaluatedArrayReference, this.myEvaluatedIndex);
        }
    }
}

