/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluatorBase;

public class ForStatementEvaluator
extends ForStatementEvaluatorBase {
    private final Evaluator myInitializationEvaluator;
    private final Evaluator myConditionEvaluator;
    private final Evaluator myUpdateEvaluator;

    public ForStatementEvaluator(Evaluator initializationEvaluator, Evaluator conditionEvaluator, Evaluator updateEvaluator, Evaluator bodyEvaluator, String labelName) {
        super(labelName, bodyEvaluator);
        this.myInitializationEvaluator = initializationEvaluator != null ? DisableGC.create(initializationEvaluator) : null;
        this.myConditionEvaluator = conditionEvaluator != null ? DisableGC.create(conditionEvaluator) : null;
        this.myUpdateEvaluator = updateEvaluator != null ? DisableGC.create(updateEvaluator) : null;
    }

    @Override
    protected Object evaluateInitialization(EvaluationContextImpl context, Object value) throws EvaluateException {
        if (this.myInitializationEvaluator != null) {
            return this.myInitializationEvaluator.evaluate(context);
        }
        return value;
    }

    @Override
    protected Object evaluateCondition(EvaluationContextImpl context) throws EvaluateException {
        if (this.myConditionEvaluator != null) {
            return this.myConditionEvaluator.evaluate(context);
        }
        return true;
    }

    @Override
    protected Object evaluateUpdate(EvaluationContextImpl context, Object value) throws EvaluateException {
        if (this.myUpdateEvaluator != null) {
            return this.myUpdateEvaluator.evaluate(context);
        }
        return value;
    }
}

