/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.sun.jdi.BooleanValue;

public class IfStatementEvaluator
implements Evaluator {
    private final Evaluator myConditionEvaluator;
    private final Evaluator myThenEvaluator;
    private final Evaluator myElseEvaluator;

    public IfStatementEvaluator(Evaluator conditionEvaluator, Evaluator thenEvaluator, Evaluator elseEvaluator) {
        this.myConditionEvaluator = DisableGC.create(conditionEvaluator);
        this.myThenEvaluator = DisableGC.create(thenEvaluator);
        this.myElseEvaluator = elseEvaluator == null ? null : DisableGC.create(elseEvaluator);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object value = this.myConditionEvaluator.evaluate(context);
        if (!(value instanceof BooleanValue)) {
            throw EvaluateExceptionUtil.BOOLEAN_EXPECTED;
        }
        value = ((BooleanValue)value).booleanValue() ? this.myThenEvaluator.evaluate(context) : (this.myElseEvaluator != null ? this.myElseEvaluator.evaluate(context) : context.getVirtualMachineProxy().mirrorOfVoid());
        return value;
    }
}

