/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerContextImpl
implements DebuggerContext {
    private static final Logger LOG = Logger.getInstance(DebuggerContextImpl.class);
    public static final DebuggerContextImpl EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(null, null, null, null);
    private boolean myInitialized;
    @Nullable
    private final DebuggerSession myDebuggerSession;
    private final SuspendContextImpl mySuspendContext;
    private final ThreadReferenceProxyImpl myThreadProxy;
    private StackFrameProxyImpl myFrameProxy;
    private SourcePosition mySourcePosition;
    private PsiElement myContextElement;

    private DebuggerContextImpl(@Nullable DebuggerSession session, @Nullable SuspendContextImpl context, ThreadReferenceProxyImpl threadProxy, StackFrameProxyImpl frameProxy, SourcePosition position, PsiElement contextElement, boolean initialized) {
        LOG.assertTrue(frameProxy == null || threadProxy == null || threadProxy == frameProxy.threadProxy());
        this.myDebuggerSession = session;
        this.myThreadProxy = threadProxy;
        this.myFrameProxy = frameProxy;
        this.mySourcePosition = position;
        this.mySuspendContext = context;
        this.myContextElement = contextElement;
        this.myInitialized = initialized;
    }

    @Nullable
    public DebuggerSession getDebuggerSession() {
        return this.myDebuggerSession;
    }

    @Nullable
    public DebugProcessImpl getDebugProcess() {
        return this.myDebuggerSession != null ? this.myDebuggerSession.getProcess() : null;
    }

    @Nullable
    public ThreadReferenceProxyImpl getThreadProxy() {
        return this.myThreadProxy;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }

    public Project getProject() {
        return this.myDebuggerSession != null ? this.myDebuggerSession.getProject() : null;
    }

    @Nullable
    public StackFrameProxyImpl getFrameProxy() {
        LOG.assertTrue(this.myInitialized);
        return this.myFrameProxy;
    }

    @Nullable
    public DebuggerManagerThreadImpl getManagerThread() {
        if (this.mySuspendContext != null) {
            return this.mySuspendContext.getManagerThread();
        }
        DebugProcessImpl debugProcess = this.getDebugProcess();
        return debugProcess != null ? debugProcess.getManagerThread() : null;
    }

    public SourcePosition getSourcePosition() {
        LOG.assertTrue(this.myInitialized);
        return this.mySourcePosition;
    }

    public PsiElement getContextElement() {
        LOG.assertTrue(this.myInitialized);
        PsiElement contextElement = this.myContextElement;
        if (contextElement != null && !contextElement.isValid()) {
            this.myContextElement = ContextUtil.getContextElement(this.mySourcePosition);
        }
        return this.myContextElement;
    }

    public EvaluationContextImpl createEvaluationContext(Value thisObject) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), thisObject);
    }

    @Nullable
    public EvaluationContextImpl createEvaluationContext() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        SuspendContextImpl context = this.getSuspendContext();
        return context != null ? new EvaluationContextImpl(context, this.getFrameProxy()) : null;
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@Nullable DebuggerSession session, @Nullable SuspendContextImpl context, ThreadReferenceProxyImpl threadProxy, StackFrameProxyImpl frameProxy) {
        LOG.assertTrue(frameProxy == null || threadProxy == null || threadProxy == frameProxy.threadProxy());
        return new DebuggerContextImpl(session, context, threadProxy, frameProxy, null, null, context == null);
    }

    public void initCaches() {
        if (this.myInitialized) {
            return;
        }
        this.myInitialized = true;
        if (this.myFrameProxy == null && this.myThreadProxy != null) {
            if (this.mySuspendContext != null && this.myThreadProxy.equals(this.mySuspendContext.getThread())) {
                this.myFrameProxy = this.mySuspendContext.getFrameProxy();
            } else {
                try {
                    this.myFrameProxy = this.myThreadProxy.frameCount() > 0 ? this.myThreadProxy.frame(0) : null;
                }
                catch (EvaluateException evaluateException) {
                    // empty catch block
                }
            }
        }
        if (this.myFrameProxy != null) {
            if (this.mySourcePosition == null) {
                this.mySourcePosition = ContextUtil.getSourcePosition((StackFrameContext)this);
            }
            this.myContextElement = ContextUtil.getContextElement(this.mySourcePosition);
        }
    }

    public void setPositionCache(SourcePosition position) {
        this.mySourcePosition = position;
    }

    public boolean isInitialised() {
        return this.myInitialized;
    }

    public boolean isEvaluationPossible() {
        DebugProcessImpl debugProcess = this.getDebugProcess();
        return debugProcess != null && debugProcess.isEvaluationPossible();
    }
}

