/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerParametersRunnerConfigurable;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PatchedRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.statistics.ProgramRunnerUsageCollector;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaProgramPatcher;
import com.intellij.execution.runners.JvmPatchableProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class GenericDebuggerRunner
implements JvmPatchableProgramRunner<GenericDebuggerRunnerSettings> {
    private static final Logger LOG = Logger.getInstance(GenericDebuggerRunner.class);

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(1);
        }
        return executorId.equals("Debug") && profile instanceof ModuleRunProfile && !(profile instanceof RunConfigurationWithSuppressedDefaultDebugAction);
    }

    @NotNull
    public String getRunnerId() {
        return "Debug";
    }

    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        RunProfileState state;
        if (environment == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(2);
        }
        if ((state = environment.getState()) == null) {
            return;
        }
        Project project = environment.getProject();
        ExecutionManager executionManager = ExecutionManager.getInstance((Project)project);
        RunProfile runProfile = environment.getRunProfile();
        StructuredIdeActivity activity = ProgramRunnerUsageCollector.INSTANCE.startExecute(project, (ProgramRunner)this, runProfile);
        if (runProfile instanceof TargetEnvironmentAwareRunProfile && state instanceof TargetEnvironmentAwareRunProfileState) {
            executionManager.startRunProfileWithPromise(environment, state, ignored -> this.doExecuteAsync((TargetEnvironmentAwareRunProfileState)state, environment).onSuccess(descr -> ProgramRunnerUsageCollector.INSTANCE.finishExecute(activity, (ProgramRunner)this, runProfile, true)));
        } else {
            executionManager.startRunProfile(environment, state, state1 -> this.doExecute(state, environment));
            ProgramRunnerUsageCollector.INSTANCE.finishExecute(activity, (ProgramRunner)this, runProfile, false);
        }
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (state instanceof JavaCommandLine && !JavaProgramPatcher.patchJavaCommandLineParamsUnderProgress((Project)env.getProject(), () -> JavaProgramPatcher.runCustomPatchers((JavaParameters)((JavaCommandLine)state).getJavaParameters(), (Executor)env.getExecutor(), (RunProfile)env.getRunProfile()))) {
            return null;
        }
        return this.createContentDescriptor(state, env);
    }

    protected @NotNull Promise<@Nullable RunContentDescriptor> doExecuteAsync(@NotNull TargetEnvironmentAwareRunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(5);
        }
        if (env == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Promise promise = state.prepareTargetToCommandExecution(env, LOG, "Failed to execute debug configuration async", () -> {
            if (state instanceof JavaCommandLine) {
                JavaCommandLine javaCommandLine = (JavaCommandLine)state;
                JavaProgramPatcher.runCustomPatchers((JavaParameters)javaCommandLine.getJavaParameters(), (Executor)env.getExecutor(), (RunProfile)env.getRunProfile());
            }
            return this.createContentDescriptor((RunProfileState)state, env);
        });
        if (promise == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(7);
        }
        return promise;
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        RemoteConnection connection;
        if (state == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(8);
        }
        if (environment == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(9);
        }
        if (state instanceof RemoteConnectionCreator) {
            RemoteConnectionCreator remoteConnectionCreator = (RemoteConnectionCreator)state;
            connection = remoteConnectionCreator.createRemoteConnection(environment);
            boolean isPollConnection = remoteConnectionCreator.isPollConnection();
            if (connection != null) {
                return this.attachVirtualMachine(state, environment, connection, isPollConnection);
            }
        }
        if (state instanceof JavaCommandLine) {
            int transport;
            JavaCommandLine javaCommandLine = (JavaCommandLine)state;
            JavaParameters parameters = javaCommandLine.getJavaParameters();
            RemoteConnection connection2 = new RemoteConnectionBuilder(true, transport, (transport = DebuggerSettings.getInstance().getTransport()) == 0 ? "0" : "").asyncAgent(true).project(environment.getProject()).create(parameters);
            return this.attachVirtualMachine(state, environment, connection2, true);
        }
        if (state instanceof PatchedRunnableState) {
            RemoteConnection connection3 = GenericDebuggerRunner.createPatchedConnection(environment);
            return this.attachVirtualMachine(state, environment, connection3, true);
        }
        if (state instanceof RemoteState) {
            RemoteState remoteState = (RemoteState)state;
            connection = GenericDebuggerRunner.createRemoteDebugConnection(remoteState, environment.getRunnerSettings());
            return this.attachVirtualMachine(state, environment, connection, false);
        }
        return null;
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(RunProfileState state, @NotNull ExecutionEnvironment env, RemoteConnection connection, boolean pollConnection) throws ExecutionException {
        if (env == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(10);
        }
        return this.attachVirtualMachine(state, env, connection, pollConnection ? 30000L : 0L);
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(RunProfileState state, @NotNull ExecutionEnvironment env, RemoteConnection connection, long pollTimeout) throws ExecutionException {
        if (env == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(11);
        }
        DefaultDebugEnvironment environment = new DefaultDebugEnvironment(env, state, connection, pollTimeout);
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(env.getProject()).attachVirtualMachine(environment);
        if (debuggerSession == null) {
            return null;
        }
        AtomicReference ex = new AtomicReference();
        AtomicReference result = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                final DebugProcessImpl debugProcess = debuggerSession.getProcess();
                XDebugProcessStarter starter = new XDebugProcessStarter(this){

                    @NotNull
                    public XDebugProcess start(@NotNull XDebugSession session) {
                        if (session == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        XDebugSessionImpl sessionImpl = (XDebugSessionImpl)session;
                        ExecutionResult executionResult = debugProcess.getExecutionResult();
                        sessionImpl.addExtraActions(executionResult.getActions());
                        if (executionResult instanceof DefaultExecutionResult) {
                            sessionImpl.addRestartActions(((DefaultExecutionResult)executionResult).getRestartActions());
                        }
                        sessionImpl.setPauseActionSupported(true);
                        JavaDebugProcess javaDebugProcess = JavaDebugProcess.create(session, debuggerSession);
                        if (javaDebugProcess == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return javaDebugProcess;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "session";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/debugger/impl/GenericDebuggerRunner$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/debugger/impl/GenericDebuggerRunner$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "start";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "start";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1 -> new IllegalStateException(string);
                        };
                    }
                };
                RunContentDescriptor descriptor = XDebuggerManager.getInstance((Project)env.getProject()).newSessionBuilder(starter).environment(env).startSession().getRunContentDescriptor();
                result.set(descriptor);
            }
            catch (ProcessCanceledException debugProcess) {
            }
            catch (ExecutionException e) {
                ex.set(e);
            }
        }, ModalityState.any());
        if (ex.get() != null) {
            throw (ExecutionException)((Object)ex.get());
        }
        return (RunContentDescriptor)result.get();
    }

    private static RemoteConnection createRemoteDebugConnection(RemoteState connection, RunnerSettings settings) {
        RemoteConnection remoteConnection = connection.getRemoteConnection();
        GenericDebuggerRunnerSettings debuggerRunnerSettings = (GenericDebuggerRunnerSettings)settings;
        if (debuggerRunnerSettings != null) {
            remoteConnection.setUseSockets(debuggerRunnerSettings.getTransport() == 0);
            remoteConnection.setDebuggerAddress(debuggerRunnerSettings.getDebugPort());
        }
        return remoteConnection;
    }

    public GenericDebuggerRunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        if (settingsProvider == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(12);
        }
        return new GenericDebuggerRunnerSettings();
    }

    public void patch(@NotNull JavaParameters javaParameters, @Nullable RunnerSettings settings, @NotNull RunProfile runProfile, boolean beforeExecution) throws ExecutionException {
        if (javaParameters == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(13);
        }
        if (runProfile == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(14);
        }
        GenericDebuggerRunner.doPatch(javaParameters, Objects.requireNonNull(settings), beforeExecution, runProfile instanceof RunConfiguration ? ((RunConfiguration)runProfile).getProject() : null);
        JavaProgramPatcher.runCustomPatchers((JavaParameters)javaParameters, (Executor)((Executor)Executor.EXECUTOR_EXTENSION_NAME.findExtensionOrFail(DefaultDebugExecutor.class)), (RunProfile)runProfile);
    }

    public static RemoteConnection createPatchedConnection(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (environment == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(15);
        }
        return GenericDebuggerRunner.doPatch(new JavaParameters(), environment.getRunnerSettings(), true, environment.getProject());
    }

    private static RemoteConnection doPatch(@NotNull JavaParameters javaParameters, @NotNull RunnerSettings settings, boolean beforeExecution, @Nullable Project project) throws ExecutionException {
        GenericDebuggerRunnerSettings debuggerSettings;
        if (javaParameters == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(16);
        }
        if (settings == null) {
            GenericDebuggerRunner.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmpty((String)(debuggerSettings = (GenericDebuggerRunnerSettings)settings).getDebugPort())) {
            debuggerSettings.setDebugPort(DebuggerUtils.getInstance().findAvailableDebugAddress(debuggerSettings.getTransport() == 0));
        }
        return new RemoteConnectionBuilder(debuggerSettings.LOCAL, debuggerSettings.getTransport(), debuggerSettings.getDebugPort()).asyncAgent(beforeExecution).project(project).create(javaParameters);
    }

    public SettingsEditor<GenericDebuggerRunnerSettings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        if (configuration instanceof RunConfigurationWithRunnerSettings && ((RunConfigurationWithRunnerSettings)configuration).isSettingsNeeded()) {
            return new GenericDebuggerParametersRunnerConfigurable(configuration.getProject());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/GenericDebuggerRunner";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/GenericDebuggerRunner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecuteAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteAsync";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createContentDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "attachVirtualMachine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "patch";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createPatchedConnection";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doPatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

