/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.DebuggerUtils;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedLocation
implements Location {
    private final int myLineNumber;
    @NotNull
    private final ReferenceType myReferenceType;
    @Nullable
    private final Method myMethod;
    @NotNull
    private final String myMethodName;

    public GeneratedLocation(@NotNull ReferenceType type, @NotNull String methodName, int lineNumber) {
        if (type == null) {
            GeneratedLocation.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            GeneratedLocation.$$$reportNull$$$0(1);
        }
        this.myLineNumber = lineNumber;
        this.myReferenceType = type;
        this.myMethodName = methodName;
        this.myMethod = DebuggerUtils.findMethod((ReferenceType)this.myReferenceType, (String)methodName, null);
    }

    @Override
    public ReferenceType declaringType() {
        return this.myReferenceType;
    }

    @Override
    public Method method() {
        return this.myMethod;
    }

    @NotNull
    public String methodName() {
        String string = this.myMethodName;
        if (string == null) {
            GeneratedLocation.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public long codeIndex() {
        return -2L;
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        return this.myReferenceType.sourceName();
    }

    @Override
    public String sourceName(String stratum) throws AbsentInformationException {
        return GeneratedLocation.firstOrThrow(this.myReferenceType.sourceNames(stratum));
    }

    @Override
    public String sourcePath() throws AbsentInformationException {
        return GeneratedLocation.firstOrThrow(this.myReferenceType.sourcePaths(this.myReferenceType.defaultStratum()));
    }

    @Override
    public String sourcePath(String stratum) throws AbsentInformationException {
        return GeneratedLocation.firstOrThrow(this.myReferenceType.sourcePaths(stratum));
    }

    @Override
    public int lineNumber() {
        return this.myLineNumber;
    }

    @Override
    public int lineNumber(String s) {
        return this.myLineNumber;
    }

    @Override
    public VirtualMachine virtualMachine() {
        return this.myReferenceType.virtualMachine();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GeneratedLocation location = (GeneratedLocation)other;
        return this.myLineNumber == location.myLineNumber && this.myReferenceType.equals(location.myReferenceType) && this.myMethodName.equals(location.myMethodName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.myReferenceType, this.myMethodName, this.myLineNumber);
    }

    @Override
    public int compareTo(@NotNull Location o) {
        int res;
        if (o == null) {
            GeneratedLocation.$$$reportNull$$$0(3);
        }
        if ((res = this.method().compareTo(o.method())) != 0) {
            return res;
        }
        return Long.compare(this.codeIndex(), o.codeIndex());
    }

    @Override
    public String toString() {
        return this.myReferenceType.name() + "." + this.myMethodName + ":" + this.myLineNumber;
    }

    private static String firstOrThrow(@NotNull List<String> list) throws AbsentInformationException {
        if (list == null) {
            GeneratedLocation.$$$reportNull$$$0(4);
        }
        if (list.isEmpty()) {
            throw new AbsentInformationException();
        }
        return list.get(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/GeneratedLocation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/GeneratedLocation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "firstOrThrow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

